/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.xml;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPProperties;
import com.sun.portal.desktop.dp.DPPropertyHolder;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPAttrs;
import com.sun.portal.desktop.dp.xml.XMLDPCollection;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPObject;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class XMLDPPropertyHolder
extends XMLDPObject
implements DPPropertyHolder,
XMLDPAttrs {
    protected Element propertiesElement = null;

    XMLDPPropertyHolder(DPContext dpc, DPRoot r, Element e) {
        super(dpc, r, e);
    }

    public Element getPropertiesElement() {
        if (this.propertiesElement == null) {
            this.propertiesElement = XMLDPObject.getChildElement(this.getElement(), "Properties", null);
            if (this.propertiesElement == null) {
                throw new DPError("XMLDPPropertyHolder.getPropertiesElement(): no properties element exists for node name=" + this.getName() + ", element=" + this.getElement().toString() + ", document=" + this.getElement().getOwnerDocument().toString());
            }
        }
        return this.propertiesElement;
    }

    public DPProperties getPropertiesFromThis() {
        Element pe = this.getPropertiesElement();
        DPProperties dpProperties = (DPProperties)this.getObject(pe);
        if (dpProperties == null) {
            dpProperties = XMLDPFactory.getInstance().getProperties(this.getContext(), this.getRoot(), pe);
            this.putObject(dpProperties);
        }
        return dpProperties;
    }

    public DPProperties getProperties() {
        DPProperties dpProperties = this.getPropertiesFromThis();
        if (dpProperties == null || !dpProperties.isMerged()) {
            Iterator i = this.getMergers().iterator();
            while (i.hasNext()) {
                DPPropertyHolder dpph = (DPPropertyHolder)i.next();
                if (this.getType() != dpph.getType()) {
                    throw new DPError("XMLDPPropertyHolder.getProperties(): type mismatch");
                }
                DPProperties dpp = ((XMLDPPropertyHolder)dpph).getPropertiesFromThis();
                dpProperties.addMerger(dpp);
            }
        }
        return dpProperties;
    }

    public abstract DPPropertyHolder getParentPropertyHolder();

    static Element createElement(DPContext dpc, Document d, String name, Element propertiesElement) {
        Element e = XMLDPObject.createElement(dpc, d, "Channel", name);
        e.appendChild(propertiesElement);
        XMLDPPropertyHolder.setDefaultsElement(e);
        return e;
    }

    public int getDefaultMergeType() {
        return XMLDPPropertyHolder.staticGetDefaultMergeType();
    }

    static int staticGetDefaultMergeType() {
        return 0;
    }

    public void setMergeDefaults() {
        XMLDPPropertyHolder.setMergeDefaultsElement(this.getElement());
    }

    public void setDefaults() {
        XMLDPPropertyHolder.setDefaultsElement(this.getElement());
    }

    static void setMergeDefaultsElement(Element e) {
        XMLDPObject.setMergeTypeElement(e, XMLDPPropertyHolder.staticGetDefaultMergeType());
        e.setAttribute("lock", "false");
        Element pe = XMLDPObject.getChildElement(e, "Properties", null);
        XMLDPCollection.setMergeDefaultsElement(pe);
    }

    static void setDefaultsElement(Element e) {
        XMLDPPropertyHolder.setMergeDefaultsElement(e);
        e.setAttribute("advanced", "false");
        Element pe = XMLDPObject.getChildElement(e, "Properties", null);
        XMLDPCollection.setDefaultsElement(pe);
    }
}

