/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.config;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.AdminUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.ssoadapter.config.ClientAwareAppContext;
import com.sun.ssoadapter.config.DSAMEConnection;
import com.sun.ssoadapter.config.DSAMEConstants;
import com.sun.ssoadapter.config.DSAMEUtils;
import com.sun.ssoadapter.config.SAALException;
import com.sun.ssoadapter.config.SessionListener;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PSClientAwareAppContext
implements ClientAwareAppContext,
DSAMEConstants,
SSOTokenListener {
    private static final String SSO_TOKEN = "ps.session";
    private String thisClassName = null;
    private SSOTokenManager tokenMgr = null;
    private SessionListener listener = null;
    private AMClientDetector cd = null;
    private DSAMEConnection dsameConn = null;
    private DSAMEUtils dsameUtils = null;

    public void init(SessionListener sl) throws SAALException {
        this.thisClassName = this.getClass().getName();
        this.listener = sl;
        String bindDN = AdminUtils.getAdminDN();
        String password = new String(AdminUtils.getAdminPassword());
        try {
            this.dsameConn = new DSAMEConnection(bindDN, password);
            this.tokenMgr = DSAMEConnection.getSSOTokenManager();
            this.dsameUtils = DSAMEUtils.getInstance(this.dsameConn);
        }
        catch (SSOException se) {
            throw new SAALException(this.thisClassName + ": " + (Object)((Object)se));
        }
        this.cd = new AMClientDetector();
    }

    private void addClientTypeInfo(Map service, String clnt) {
        String client;
        String string = client = clnt != null ? clnt : "default";
        if (service != null) {
            service.put("clientType", client);
        }
    }

    public String getStringAttribute(Map service, String attributeName) throws IOException, MissingResourceException {
        return this.getStringAttribute(service, "default", attributeName);
    }

    public String getStringAttribute(Map service, String clientType, String attributeName) throws IOException, MissingResourceException {
        String serviceName = this.dsameUtils.getServiceName(service);
        String val = null;
        Set vals = this.getAttribute(serviceName, clientType, attributeName);
        if (vals != null && vals.size() > 0) {
            Iterator iter = vals.iterator();
            val = (String)iter.next();
        }
        return val;
    }

    public Set getAttribute(Map service, String attributeName) throws IOException, MissingResourceException {
        return this.getAttribute(service, "default", attributeName);
    }

    public Set getAttribute(Map service, String clientType, String attributeName) throws IOException, MissingResourceException {
        String serviceName = this.dsameUtils.getServiceName(service);
        return this.getAttribute(serviceName, clientType, attributeName);
    }

    private Set getAttribute(String serviceName, String client, String attrName) throws MissingResourceException, IOException {
        if (serviceName == null) {
            throw new MissingResourceException("Missing in Map", "DSAMEServiceAppContext", "serviceName");
        }
        Set vals = this.dsameConn.getGlobalAttribute(serviceName, attrName);
        Set retVals = null;
        int type = this.dsameUtils.getAttributeType(serviceName, attrName);
        switch (type) {
            case 1: {
                retVals = vals;
                break;
            }
            case 3: {
                retVals = this.dsameUtils.getClientValues(vals, client, null, true);
                break;
            }
            default: {
                retVals = vals;
            }
        }
        return retVals;
    }

    private SSOTokenManager getSSOTokenManager() {
        return this.tokenMgr;
    }

    protected SSOToken getSSOToken(HttpServletRequest req) {
        SSOToken token = (SSOToken)req.getAttribute(SSO_TOKEN);
        if (token == null) {
            try {
                token = this.getSSOTokenManager().createSSOToken(req);
                req.setAttribute(SSO_TOKEN, (Object)token);
            }
            catch (SSOException se) {
                token = null;
            }
        }
        return token;
    }

    public boolean validateSession(HttpServletRequest req) {
        String uid;
        boolean isValid = false;
        SSOToken token = this.getSSOToken(req);
        if (token != null && this.getSSOTokenManager().isValidToken(token) && (uid = this.getUserID(token)) != null) {
            isValid = true;
        }
        return isValid;
    }

    private String getUserID(SSOToken token) {
        Principal p = null;
        try {
            if (token == null) {
                return null;
            }
            p = token.getPrincipal();
        }
        catch (SSOException ssoe) {
            return null;
        }
        return p.toString();
    }

    public String getSessionID(HttpServletRequest req) {
        SSOToken token = this.getSSOToken(req);
        String tokenID = null;
        if (token != null) {
            tokenID = token.getTokenID().toString();
        }
        return tokenID;
    }

    public void addSessionListener(HttpServletRequest req) throws IllegalStateException {
        try {
            SSOToken token = this.getSSOToken(req);
            token.addSSOTokenListener((SSOTokenListener)this);
        }
        catch (SSOException se) {
            throw new IllegalStateException("DSAMESessionUserContext.addSessionListener()" + (Object)((Object)se));
        }
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        String sid = evt.getToken().getTokenID().toString();
        this.listener.sessionDestroyed(sid);
    }

    public boolean isAuthlessEnabled() {
        Boolean authlessEnabled;
        try {
            authlessEnabled = Boolean.valueOf(this.dsameConn.getGlobalStringAttribute("SunPortalDesktopService", "sunPortalDesktopEnableAuthlessDesktop"));
        }
        catch (IOException ioe) {
            authlessEnabled = Boolean.valueOf("false");
        }
        return authlessEnabled;
    }

    public boolean isAuthorizedAuthlessUID(String uid) {
        Map authorized = this.getAuthorizedAuthlessUIDs();
        return authorized.containsKey(uid);
    }

    public Map getAuthorizedAuthlessUIDs() {
        Set uidPasswordPairs = null;
        HashMap<String, String> authorized = null;
        try {
            uidPasswordPairs = this.dsameConn.getGlobalAttribute("SunPortalDesktopService", "sunPortalDesktopAuthorizedAuthlessUIDs");
            authorized = new HashMap<String, String>();
        }
        catch (IOException ioe) {
            return authorized;
        }
        Iterator i = uidPasswordPairs.iterator();
        while (i.hasNext()) {
            String pair = (String)i.next();
            int sep = pair.indexOf(124);
            String uid = pair.substring(0, sep);
            String pw = pair.substring(sep + 1);
            authorized.put(uid, pw);
        }
        return authorized;
    }

    public String getClientType(HttpServletRequest req) {
        String clientType = this.cd.getClientType(req);
        return clientType;
    }
}

