/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.calendar.pim;

import com.aligo.pim.PimTaskStatusType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimTaskItem;
import com.sun.comclient.calendar.Attach;
import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.RecurrencePattern;
import com.sun.comclient.calendar.VAlarm;
import com.sun.comclient.calendar.VTodo;
import com.sun.ssoadapter.calendar.pim.APimCalendar;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class APimTask
extends VTodo {
    private PimTaskItem taskItem;
    private APimCalendar parentCal;
    private SimpleDateFormat isoFormatter;
    private String isoFormat = "yyyyMMdd'T'HHmmss'Z'";
    private boolean isNew = false;
    private TimeZone tz = null;
    private String description = null;
    private DateTime start = null;
    private DateTime end = null;
    private PimTaskStatusType status = PimTaskStatusType.NOT_COMPLETE;
    private String summary = null;
    private String id = null;
    private static boolean enableCache = true;

    public APimTask(APimCalendar cal, PimTaskItem item, boolean isNew) {
        this.taskItem = item;
        this.parentCal = cal;
        this.isNew = isNew;
        this.isoFormatter = new SimpleDateFormat(this.isoFormat);
        this.isoFormatter.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.isoFormatter.setLenient(false);
        this.tz = cal.getTimeZone();
        if (this.taskItem != null) {
            try {
                this.description = this.taskItem.getText();
                this.status = this.taskItem.getStatus();
                this.summary = this.taskItem.getSubject();
                this.id = this.taskItem.getID();
                this.end = this.toDateTime(this.taskItem.getDueDate());
                this.start = this.toDateTime(this.taskItem.getStartDate());
                if (enableCache) {
                    this.taskItem = null;
                }
            }
            catch (PimException pex) {
                pex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public APimTask(APimCalendar cal, PimTaskItem item) {
        this(cal, item, false);
    }

    private DateTime toDateTime(Date date) throws Exception {
        if (date != null) {
            String tmp = this.isoFormatter.format(date);
            return new DateTime(tmp, this.tz);
        }
        return null;
    }

    public void addAlarmComponent(VAlarm alarm) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addAttachment(Attach attachment) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addCategory(String category) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addExceptionDate(DateTime exceptionDate) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addExceptionRule(RecurrencePattern exceptionRule) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addRecurrenceDate(DateTime recurrenceDate) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addRecurrenceRule(RecurrencePattern recurrenceRule) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addRelatedTo(String relatedTo) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void addResource(String resource) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public VAlarm[] getAlarmComponents() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public Attach[] getAttachments() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String[] getCategories() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String getClassification() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public DateTime getCompletedTime() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public DateTime getCreated() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String getDescription() throws CalendarComponentException {
        try {
            if (this.taskItem == null) {
                return this.description;
            }
            return this.taskItem.getText();
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public DateTime[] getExceptionDates() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public RecurrencePattern[] getExceptionRules() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String getGeo() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public DateTime getLastModified() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String getLocation() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public int getPercent() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public int getPriority() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public DateTime[] getRecurrenceDates() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public DateTime getRecurrenceID() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public boolean isRecurring() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public RecurrencePattern[] getRecurrenceRules() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String[] getRelatedTos() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String[] getResources() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public int getSequence() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public DateTime getStart() throws CalendarComponentException {
        try {
            if (this.taskItem == null) {
                return this.start;
            }
            return this.toDateTime(this.taskItem.getStartDate());
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public String getStatus() throws CalendarComponentException {
        try {
            if (this.taskItem == null) {
                return this.status.toString();
            }
            PimTaskStatusType status = this.taskItem.getStatus();
            return status.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CalendarComponentException(ex.getMessage());
        }
    }

    public String getSummary() throws CalendarComponentException {
        try {
            if (this.taskItem == null) {
                return this.summary;
            }
            return this.taskItem.getSubject();
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public boolean isAllDay() throws OperationNotSupportedException {
        return true;
    }

    public void removeAlarmComponent(VAlarm alarm) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllAlarmComponents() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllAttachments() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllCategories() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllExceptionDates() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllExceptionRules() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllRecurrenceDates() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllRecurrenceRules() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllRelatedTos() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllResources() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAttachment(Attach attachment) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeCategory(String category) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeExceptionDate(DateTime exceptionDate) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeExceptionRule(RecurrencePattern exceptionRule) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeRecurrenceDate(DateTime recurrenceDate) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeRecurrenceRule(RecurrencePattern recurrenceRule) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeRelatedTo(String relatedTo) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeResource(String resource) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setAllDay(boolean allday) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setClassification(String classification) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setDescription(String description) throws CalendarComponentException {
        try {
            if (this.taskItem != null) {
                this.taskItem.setText(description);
            }
            this.description = description;
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public void setDuration(Duration duration) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setGeo(String geo) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setLastModified(DateTime lastModified) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setLocation(String location) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setPercent(int percent) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setPriority(int priority) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setSequence(int sequence) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setStart(DateTime dtstart) throws CalendarComponentException {
        try {
            if (this.taskItem != null) {
                this.taskItem.setStartDate(dtstart.getTime());
            }
            this.start = dtstart;
        }
        catch (PimException pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public void setStatus(String status) throws CalendarComponentException {
        try {
            this.status = status.equalsIgnoreCase("completed") ? PimTaskStatusType.COMPLETE : PimTaskStatusType.NOT_COMPLETE;
            if (this.taskItem != null) {
                this.taskItem.setStatus(this.status);
            }
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public void setSummary(String summary) throws CalendarComponentException {
        try {
            if (this.taskItem != null) {
                this.taskItem.setSubject(summary);
            }
            this.summary = summary;
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public String toString() {
        return null;
    }

    public void setEnd(DateTime dtend) throws CalendarComponentException {
        try {
            if (this.taskItem != null) {
                this.taskItem.setDueDate(dtend.getTime());
            }
            this.end = dtend;
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public DateTime getEnd() throws CalendarComponentException {
        try {
            if (this.taskItem != null) {
                return this.toDateTime(this.taskItem.getDueDate());
            }
            return this.end;
        }
        catch (Exception pex) {
            pex.printStackTrace();
            throw new CalendarComponentException(pex.getMessage());
        }
    }

    public void setCalID(String id) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String getCalID() throws CalendarComponentException {
        return this.parentCal.getCalID();
    }

    public String getUrl() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void setUrl(String url) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public String getID() throws CalendarComponentException {
        try {
            if (this.taskItem != null) {
                return this.taskItem.getID();
            }
            return this.id;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CalendarComponentException(ex.getMessage());
        }
    }

    public void setID(String uid) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllRequestStatus() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void removeRequestStatus(String requeststatus) throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public void addRequestStatus(String requeststatus) throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public String[] getRequestStatus() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public void setOrganizer(Organizer organizer) throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public Organizer getOrganizer() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public Duration getDuration() throws OperationNotSupportedException, CalendarComponentException {
        return null;
    }

    public void setStamp(DateTime dtstamp) throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public DateTime getStamp() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllComments() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public void removeComment(String comment) throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public void addComment(String comment) throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public String[] getComments() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllContacts() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public void removeContact(String contact) throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public void addContact(String contact) throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public String[] getContacts() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public void removeAllAttendees() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public void removeAttendee(Attendee attendee) throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public void addAttendee(Attendee attendee) throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public Attendee[] getAttendees() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public boolean hasAttendee() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public boolean isConfirmed() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public boolean isCompleted() throws CalendarComponentException {
        try {
            if (this.taskItem != null) {
                this.status = this.taskItem.getStatus();
            }
            return this.status == PimTaskStatusType.COMPLETE;
        }
        catch (Exception ex) {
            throw new CalendarComponentException(ex.getMessage());
        }
    }

    public VAlarm createAlarm() throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public boolean isCalIdTheOrganizer(String calId) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public Attendee getAttendee(String calid) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("");
    }

    public void delete() throws PimException {
        if (this.taskItem != null) {
            this.taskItem.delete();
        } else if (this.id != null) {
            this.taskItem = this.parentCal.getTaskItems().getTaskItem(this.id);
            this.taskItem.delete();
            if (enableCache) {
                this.taskItem = null;
            }
        }
    }

    public void update() throws PimException {
        if (this.taskItem == null) {
            this.taskItem = this.id == null ? this.parentCal.getTaskItems().addTaskItem() : this.parentCal.getTaskItems().getTaskItem(this.id);
            if (this.description != null) {
                this.taskItem.setText(this.description);
            }
            if (this.status != null) {
                this.taskItem.setStatus(this.status);
            }
            if (this.summary != null) {
                this.taskItem.setSubject(this.summary);
            }
            if (this.end != null) {
                this.taskItem.setDueDate(this.end.getTime());
            }
            if (this.start != null) {
                this.taskItem.setStartDate(this.start.getTime());
            }
        }
        this.taskItem.update();
        this.isNew = false;
        if (this.id == null) {
            this.id = this.taskItem.getID();
        }
        if (enableCache) {
            this.taskItem = null;
        }
    }

    public boolean isPublic() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public int getPendingAttendeesCount() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public int getTentativeAttendeesCount() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public int getDeclinedAttendeesCount() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public int getAcceptedAttendeesCount() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }

    public boolean hasAlarm() throws OperationNotSupportedException, CalendarComponentException {
        throw new OperationNotSupportedException("");
    }
}

