/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenListener;
import com.sun.ssoadapter.SSOAdapterConstants;
import com.sun.ssoadapter.SSOAdapterException;
import java.util.Locale;
import java.util.Properties;

public abstract class SSOAdapter
implements SSOAdapterConstants,
SSOTokenListener {
    protected String adapterName;
    protected Properties adapterProperties;
    protected SSOToken token;
    protected Locale locale;
    protected String identifier;

    protected SSOAdapter() {
    }

    public void init(String adapterName, SSOToken token, Properties adapterProperties) throws SSOAdapterException {
        this.adapterName = adapterName;
        this.token = token;
        this.adapterProperties = adapterProperties;
        try {
            this.identifier = "dn=" + token.getPrincipal().getName() + " ssoadapter=" + adapterName + " ";
        }
        catch (Exception e) {
            this.identifier = " ssoadapter=" + adapterName + " ";
        }
    }

    public abstract Object getConnection();

    public SSOToken getSSOToken() throws SSOAdapterException {
        return this.token;
    }

    public String getName() {
        return this.adapterName;
    }

    public Properties getProperties() {
        return this.adapterProperties;
    }

    public abstract boolean closeConnection();

    public abstract void ssoTokenChanged(SSOTokenEvent var1);
}

