/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimImportanceType;
import com.aligo.pim.interfaces.PimMailItem;
import com.aligo.pim.interfaces.PimMailMessageItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimImportanceTypeMapper;
import com.aligo.pim.lotus.LotusPimMailMessageItem;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Vector;
import lotus.domino.Document;
import lotus.domino.NotesException;
import lotus.domino.RichTextItem;
import lotus.domino.RichTextStyle;
import lotus.domino.ViewEntry;
import lotus.domino.ViewEntryCollection;

public class LotusPimMailItem
extends LotusPimMailMessageItem
implements PimMailItem {
    public LotusPimMailItem(ViewEntry viewEntry, LotusPimSession lotusPimSession, Recycle recycle) {
        super(viewEntry, lotusPimSession, recycle);
    }

    public LotusPimMailItem(ViewEntryCollection viewEntryCollection, LotusPimSession lotusPimSession, Recycle recycle) {
        super(viewEntryCollection, lotusPimSession, recycle);
    }

    public LotusPimMailItem(Document document, LotusPimSession lotusPimSession, Recycle recycle) {
        super(document, lotusPimSession, recycle);
    }

    public PimMailMessageItem reply() throws LotusPimException {
        try {
            Document document = this.getLotusDocument().createReplyMessage(false);
            if (document == null) {
                return null;
            }
            this.getRecycle().add(document);
            String string = this.getLotusDocument().getItemValueString("Subject");
            string = "RE: " + string;
            document.replaceItemValue("Subject", (Object)string);
            document.replaceItemValue("Form", (Object)"Reply");
            LotusPimMailItem lotusPimMailItem = new LotusPimMailItem(document, this.getLotusPimSession(), this.getRecycle());
            return lotusPimMailItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimMailMessageItem replyAll() throws LotusPimException {
        try {
            Document document = this.getLotusDocument().createReplyMessage(true);
            if (document == null) {
                return null;
            }
            Recycle recycle = this.getRecycle();
            recycle.add(document);
            String string = this.getLotusDocument().getItemValueString("Subject");
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            vector = this.verifyEmails(this.getLotusDocument(), "SendTo");
            vector2 = this.verifyEmails(this.getLotusDocument(), "CopyTo");
            vector3 = this.verifyEmails(this.getLotusDocument(), "BlindCopyTo");
            int n = 0;
            while (n < vector.size()) {
                vector2.add(vector.elementAt(n));
                ++n;
            }
            string = "RE: " + string;
            Vector<String> vector4 = new Vector<String>();
            vector4.add(this.getLotusDocument().getItemValueString("From"));
            document.replaceItemValue("SendTo", vector4);
            document.replaceItemValue("CopyTo", (Object)vector2);
            document.replaceItemValue("BlindCopyTo", (Object)vector3);
            document.replaceItemValue("Subject", (Object)string);
            LotusPimMailItem lotusPimMailItem = new LotusPimMailItem(document, this.getLotusPimSession(), this.getRecycle());
            return lotusPimMailItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimMessageItem forward() throws LotusPimException {
        try {
            Document document = this.returnForwardDocument();
            if (document == null) {
                return null;
            }
            document.replaceItemValue("Subject", (Object)("FW: " + this.getLotusDocument().getItemValueString("Subject")));
            LotusPimMailItem lotusPimMailItem = new LotusPimMailItem(document, this.getLotusPimSession(), this.getRecycle());
            return lotusPimMailItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getName() throws LotusPimException {
        return "MailItem : " + this.getSubject();
    }

    public void setBody(String string) throws LotusPimException {
        try {
            Document document = this.getLotusDocument();
            Recycle recycle = this.getRecycle();
            try {
                RichTextItem richTextItem = null;
                if (this.getLotusDocument().hasItem("Body")) {
                    richTextItem = (RichTextItem)this.getLotusDocument().getFirstItem("Body");
                    richTextItem.remove();
                }
                richTextItem = document.createRichTextItem("Body");
                RichTextStyle richTextStyle = this.getLotusSession().createRichTextStyle();
                richTextStyle.setFontSize(9);
                richTextItem.appendStyle(richTextStyle);
                richTextItem.appendText(string);
            }
            catch (Exception exception) {
                this.getLotusDocument().replaceItemValue("Body", (Object)string);
            }
        }
        catch (Exception exception) {
            if (exception instanceof NotesException) {
                NotesException notesException = (NotesException)((Object)exception);
            }
            throw new LotusPimException(exception);
        }
    }

    public void setSubject(String string) throws LotusPimException {
        try {
            this.getLotusDocument().replaceItemValue("Subject", (Object)string);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setImportance(PimImportanceType pimImportanceType) throws LotusPimException {
        try {
            this.getLotusDocument().replaceItemValue("Importance", (Object)LotusPimImportanceTypeMapper.getType(pimImportanceType));
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void update() throws LotusPimException {
    }
}

