/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netlet.eproxy.NetletGroup;
import com.sun.portal.netlet.eproxy.NetletGroupManager;
import com.sun.portal.util.GWDebug;

public class SessionKeepAlive
implements Runnable {
    private long activateTime = 0L;
    private boolean status = true;
    private NetletGroupManager manager = null;
    private long maxIdleTime = 0L;
    private final long interval = 100L;

    public SessionKeepAlive(NetletGroupManager netletGroupManager, long l) {
        this.maxIdleTime = l;
        this.manager = netletGroupManager;
        this.init();
    }

    private void init() {
        this.maxIdleTime *= 60000L;
        this.activateTime = this.maxIdleTime / 100L;
    }

    public void run() {
        long l = 0L;
        NetletGroup netletGroup = null;
        long l2 = 2L * this.activateTime + 5L;
        SSOTokenManager sSOTokenManager = null;
        try {
            sSOTokenManager = SSOTokenManager.getInstance();
        }
        catch (SSOException sSOException) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("SessionKeepAlive: Unable to get SSOTokenManager instance -> " + (Object)((Object)sSOException));
            }
            this.status = false;
        }
        while (this.status) {
            try {
                String[] stringArray = NetletGroupManager.getRegisteredSessions();
                int n = 0;
                while (n < stringArray.length) {
                    String string = stringArray[n];
                    if (string != null && string.trim().length() != 0) {
                        netletGroup = NetletGroupManager.getNetletGroup(string);
                        if (System.currentTimeMillis() - netletGroup.getUserLoginTime() >= netletGroup.getMaxSessionTime()) {
                            NetletGroupManager.unregister(string);
                        } else {
                            l = System.currentTimeMillis() - netletGroup.getLastActivityTime();
                            if (l < l2) {
                                if (netletGroup.needToExtend()) {
                                    SSOToken sSOToken = null;
                                    try {
                                        sSOToken = sSOTokenManager.createSSOToken(string);
                                    }
                                    catch (SSOException sSOException) {
                                        sSOToken = null;
                                    }
                                    if (!(sSOToken != null && sSOTokenManager.isValidToken(sSOToken) || netletGroup.getNetletRunUponLogout())) {
                                        NetletGroupManager.unregister(string);
                                    }
                                }
                            } else if (l >= this.maxIdleTime) {
                                NetletGroupManager.unregister(string);
                            }
                        }
                    } else {
                        NetletGroupManager.unregister(string);
                    }
                    ++n;
                }
                Thread.sleep(this.activateTime);
            }
            catch (InterruptedException interruptedException) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("SessionKeepAlive: Caught interrrupted exception -> " + interruptedException);
                }
                this.status = false;
            }
        }
    }
}

