/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.econnection.ReaderWriter;
import com.sun.portal.netlet.econnection.ReaderWriterDecrypt;
import com.sun.portal.netlet.econnection.ReaderWriterEncrypt;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.eproxy.SessionAuthenticator;
import com.sun.portal.netlet.eproxy.SessionRequest;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.NetletProfile;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.SystemProperties;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;

public class RWGroupFtp
extends ReaderWriterLock {
    public boolean done;
    private Socket fromClient;
    private Socket toServer;
    private ReaderWriterDecrypt src_to_dst;
    private ReaderWriterEncrypt dst_to_src;
    private SessionAuthenticator sessionAuth;
    private SessionRequest sessionReq;
    private static int ip_part1;
    private static int ip_part2;
    private static int ip_part3;
    private static int ip_part4;
    private long startTime;

    public RWGroupFtp(Socket socket, SessionAuthenticator sessionAuthenticator, SessionRequest sessionRequest) {
        block19: {
            block18: {
                this.done = false;
                this.fromClient = socket;
                this.sessionAuth = sessionAuthenticator;
                this.sessionReq = sessionRequest;
                ServerSocket serverSocket = null;
                try {
                    serverSocket = new ServerSocket(0);
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.incrementServerSockets();
                    }
                }
                catch (IOException iOException) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("RWGroupFtp: unable to create server socket for ftp." + iOException);
                    }
                    return;
                }
                String string = null;
                try {
                    string = InetAddress.getLocalHost().getHostAddress().replace('.', ',');
                }
                catch (Exception exception) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("RWGroupFtp: Unable to get IP address");
                    }
                    return;
                }
                int n = serverSocket.getLocalPort();
                String string2 = string + "," + n / 256 + "," + n % 256;
                System.out.println("Reply " + string2);
                try {
                    DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                    dataOutputStream.writeInt(ip_part1);
                    dataOutputStream.writeInt(ip_part2);
                    dataOutputStream.writeInt(ip_part3);
                    dataOutputStream.writeInt(ip_part4);
                    dataOutputStream.writeInt(n / 256);
                    dataOutputStream.writeInt(n % 256);
                    dataOutputStream.flush();
                }
                catch (Exception exception) {
                    return;
                }
                boolean bl = serverSocket instanceof SSLServerSocket;
                try {
                    this.toServer = serverSocket.accept();
                    if (PerfContextObject.ENABLE_PERF) {
                        if (bl) {
                            SocketCount.incrementSSLSockets();
                        } else {
                            SocketCount.incrementPlainSockets();
                        }
                    }
                }
                catch (Exception exception) {
                    if (!GWDebug.debug.errorEnabled()) break block18;
                    GWDebug.debug.error("RWGroupCrypt: ftp data server socket can't accept. " + exception);
                }
            }
            try {
                this.src_to_dst = new ReaderWriterDecrypt(this, this.fromClient.getInputStream(), this.toServer.getOutputStream());
                this.dst_to_src = new ReaderWriterEncrypt(this, this.toServer.getInputStream(), this.fromClient.getOutputStream(), this.getNetletKeepAliveInterval(sessionRequest));
            }
            catch (Exception exception) {
                System.out.println("Unable to create ReaderWriter threads.");
                exception.printStackTrace();
            }
            try {
                GWThreadPool.run(this.src_to_dst);
                GWThreadPool.run(this.dst_to_src);
            }
            catch (InterruptedException interruptedException) {
                if (!GWDebug.debug.errorEnabled()) break block19;
                GWDebug.debug.error("Could not start ReaderWriterClear tasks", interruptedException);
            }
        }
        this.startTime = System.currentTimeMillis();
    }

    public synchronized void notifyFinished(ReaderWriter readerWriter) {
        if (readerWriter == this.src_to_dst) {
            if (this.dst_to_src != null) {
                this.dst_to_src.stop();
            }
        } else if (readerWriter == this.dst_to_src && this.src_to_dst != null) {
            this.src_to_dst.stop();
        }
        this.cleanup();
    }

    public synchronized void stopAll() {
        if (!this.done) {
            if (this.dst_to_src != null) {
                this.dst_to_src.stop();
            }
            if (this.src_to_dst != null) {
                this.src_to_dst.stop();
            }
            this.cleanup();
        }
    }

    public void cleanup() {
        try {
            if (this.fromClient != null) {
                try {
                    block14: {
                        try {
                            this.fromClient.close();
                            if (!PerfContextObject.ENABLE_PERF) break block14;
                            if (this.fromClient instanceof SSLSocket) {
                                SocketCount.decrementSSLSockets();
                                break block14;
                            }
                            SocketCount.decrementPlainSockets();
                        }
                        catch (Exception exception) {
                            Object var3_2 = null;
                            this.fromClient = null;
                        }
                    }
                    Object var3_1 = null;
                    this.fromClient = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.fromClient = null;
                    throw throwable;
                }
            }
            if (this.toServer != null) {
                try {
                    block16: {
                        try {
                            this.toServer.close();
                            if (!PerfContextObject.ENABLE_PERF) break block16;
                            if (this.toServer instanceof SSLSocket) {
                                SocketCount.decrementSSLSockets();
                                break block16;
                            }
                            SocketCount.decrementPlainSockets();
                        }
                        catch (Exception exception) {
                            Object var5_8 = null;
                            this.toServer = null;
                        }
                    }
                    Object var5_7 = null;
                    this.toServer = null;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    this.toServer = null;
                    throw throwable;
                }
            }
            Object var7_11 = null;
            this.src_to_dst = null;
            this.dst_to_src = null;
            this.done = true;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            this.src_to_dst = null;
            this.dst_to_src = null;
            this.done = true;
            throw throwable;
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public long getLastActivityTime() {
        if (this.src_to_dst.getLastActivityTime() > this.dst_to_src.getLastActivityTime()) {
            return this.src_to_dst.getLastActivityTime();
        }
        return this.dst_to_src.getLastActivityTime();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getAppletSrcPort() {
        return -1;
    }

    private int getNetletKeepAliveInterval(SessionRequest sessionRequest) {
        try {
            String string = sessionRequest.getSessionID();
            NetletProfile netletProfile = new NetletProfile(string);
            return NetletProfile.getInt("KeepAliveInterval", 0);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    static {
        block2: {
            String string = SystemProperties.get("gateway.external.ip");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            try {
                ip_part1 = Integer.parseInt(string2);
                ip_part2 = Integer.parseInt(string3);
                ip_part3 = Integer.parseInt(string4);
                ip_part4 = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                if (!GWDebug.debug.errorEnabled()) break block2;
                GWDebug.debug.error("RWGroupFtp: invalid ip in platform.conf");
            }
        }
    }
}

