/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimFieldType;
import com.aligo.pim.PimSortType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimGlobalAddressBook;
import com.aligo.pim.exchangewebdav.ExWebDavPimGlobalAddressEntryItem;
import com.aligo.pim.exchangewebdav.ExWebDavPimGlobalAddressEntryItemFilter;
import com.aligo.pim.exchangewebdav.ExWebDavPimMessageItems;
import com.aligo.pim.exchangewebdav.ExWebDavPimSession;
import com.aligo.pim.exchangewebdav.util.WebDavField;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItemFilter;
import com.aligo.pim.interfaces.PimAddressEntryItems;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimMessageItemFilter;
import java.util.TreeMap;
import org.w3c.dom.Element;

public class ExWebDavPimGlobalAddressEntryItems
extends ExWebDavPimMessageItems
implements PimAddressEntryItems {
    private ExWebDavPimGlobalAddressBook m_oPimGlobalAddressBook;
    private ExWebDavPimGlobalAddressEntryItemFilter m_oPimAddressEntryItemFilter;
    private boolean m_bIsInitializeCalled = false;
    private PimSortType m_oPimSortType = PimSortType.ASCENDING;
    private TreeMap m_oGlobalAddressEntryItems = new TreeMap();
    private Object[] m_oKeySetArray;

    public ExWebDavPimGlobalAddressEntryItems(ExWebDavPimGlobalAddressBook pimGlobalAddressBook, ExWebDavPimSession pimSession) throws ExWebDavPimException {
        super(pimSession);
        this.m_oPimGlobalAddressBook = pimGlobalAddressBook;
    }

    public ExWebDavPimGlobalAddressBook getPimGlobalAddressBook() {
        return this.m_oPimGlobalAddressBook;
    }

    public PimAddressEntryItem addAddressEntryItem() throws ExWebDavPimException {
        return null;
    }

    public PimAddressEntryItemFilter getAddressEntryItemFilter() throws ExWebDavPimException {
        try {
            if (this.m_oPimAddressEntryItemFilter == null) {
                this.m_oPimAddressEntryItemFilter = new ExWebDavPimGlobalAddressEntryItemFilter();
            }
            return this.m_oPimAddressEntryItemFilter;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void populateCache(String response) throws ExWebDavPimException {
        try {
            int numOfElements = XMLUtilities.getNumOfElements(response, WebDavField.ITEM);
            int itemNum = 0;
            while (itemNum < numOfElements) {
                Element itemElement = XMLUtilities.getValueAsElement(response, WebDavField.ITEM, itemNum);
                String displayName = XMLUtilities.getValue(itemElement, WebDavField.DN);
                if (displayName != null) {
                    this.m_oGlobalAddressEntryItems.put(displayName.toLowerCase(), itemElement);
                }
                ++itemNum;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void initializeCache() throws ExWebDavPimException {
        try {
            String baseref = this.getPimSession().getRootFolderName() + "/" + this.getPimSession().getUserInfo().getMailbox() + "/?Cmd=galfind";
            if (this.m_oPimAddressEntryItemFilter != null && this.m_oPimAddressEntryItemFilter.getFilterString() != null) {
                String filterCriteria = this.m_oPimAddressEntryItemFilter.getFilterString();
                if (filterCriteria != null) {
                    String href = baseref + filterCriteria;
                    HTTPResponse response = this.getPimSession().getHttpConnector().sendRequestReturnAsXml(href);
                    this.populateCache(response.getText());
                }
            } else {
                String baseHref = baseref + "&DN=";
                int asciiDecimal = 65;
                while (asciiDecimal <= 90) {
                    char[] ch = new char[]{(char)asciiDecimal};
                    String href = baseHref + new String(ch);
                    HTTPResponse response = this.getPimSession().getHttpConnector().sendRequestReturnAsXml(href);
                    this.populateCache(response.getText());
                    ++asciiDecimal;
                }
            }
            if (this.m_oGlobalAddressEntryItems.size() > 0) {
                this.m_oKeySetArray = this.m_oGlobalAddressEntryItems.keySet().toArray();
            }
            this.m_bIsInitializeCalled = true;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public int getCount() throws ExWebDavPimException {
        try {
            if (!this.m_bIsInitializeCalled) {
                this.initializeCache();
            }
            if (this.m_oKeySetArray != null) {
                return this.m_oKeySetArray.length;
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public PimAddressEntryItem getAddressEntryItem(int itemNumber) throws ExWebDavPimException {
        try {
            if (!this.m_bIsInitializeCalled) {
                this.initializeCache();
            }
            if (itemNumber >= this.getCount()) {
                return null;
            }
            int actualItemNumber = itemNumber;
            if (this.m_oPimSortType.equals(PimSortType.DESCENDING)) {
                actualItemNumber = this.getCount() - 1 - itemNumber;
            }
            return new ExWebDavPimGlobalAddressEntryItem(this.getPimSession(), (Element)this.m_oGlobalAddressEntryItems.get(this.m_oKeySetArray[actualItemNumber]));
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getAddressEntryItem(String id) throws ExWebDavPimException {
        try {
            String actualId;
            Element element;
            if (!this.m_bIsInitializeCalled) {
                this.initializeCache();
            }
            if ((element = (Element)this.m_oGlobalAddressEntryItems.get(actualId = id.toLowerCase())) != null) {
                return new ExWebDavPimGlobalAddressEntryItem(this.getPimSession(), element);
            }
            return null;
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getFirstAddressEntryItem() throws ExWebDavPimException {
        try {
            return this.getAddressEntryItem(this.getFirstIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getNextAddressEntryItem() throws ExWebDavPimException {
        try {
            return this.getAddressEntryItem(this.getNextIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getLastAddressEntryItem() throws ExWebDavPimException {
        try {
            return this.getAddressEntryItem(this.getLastIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressEntryItem getPreviousAddressEntryItem() throws ExWebDavPimException {
        try {
            return this.getAddressEntryItem(this.getPreviousIndex());
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void clearCache() {
        this.m_oGlobalAddressEntryItems = new TreeMap();
        this.getFirstIndex();
        this.m_bIsInitializeCalled = false;
        this.m_oPimAddressEntryItemFilter = null;
        this.m_oKeySetArray = null;
    }

    public void delete() throws ExWebDavPimException {
    }

    public void sort(PimSortType type) throws ExWebDavPimException {
        try {
            if (type != null) {
                this.m_oPimSortType = type;
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public void setOrderBy(PimFieldType[] pimFieldType) throws ExWebDavPimException {
    }

    public PimMessageItemFilter getMessageItemFilter() throws ExWebDavPimException {
        return this.getAddressEntryItemFilter();
    }

    public PimMessageItem getMessageItem(int itemNumber) throws ExWebDavPimException {
        return this.getAddressEntryItem(itemNumber);
    }

    public PimMessageItem getMessageItem(String id) throws ExWebDavPimException {
        return this.getAddressEntryItem(id);
    }

    public PimMessageItem getFirstMessageItem() throws ExWebDavPimException {
        return this.getFirstAddressEntryItem();
    }

    public PimMessageItem getNextMessageItem() throws ExWebDavPimException {
        return this.getNextAddressEntryItem();
    }

    public PimMessageItem getLastMessageItem() throws ExWebDavPimException {
        return this.getLastAddressEntryItem();
    }

    public PimMessageItem getPreviousMessageItem() throws ExWebDavPimException {
        return this.getPreviousAddressEntryItem();
    }

    public PimMessageItem addMessageItem() throws ExWebDavPimException {
        return this.addAddressEntryItem();
    }

    public PimItem getItem(int itemNumber) throws ExWebDavPimException {
        return this.getMessageItem(itemNumber);
    }

    public PimItem getItem(String id) throws ExWebDavPimException {
        return this.getMessageItem(id);
    }

    public PimItem addItem() throws ExWebDavPimException {
        return this.addMessageItem();
    }

    public PimItem getFirstItem() throws ExWebDavPimException {
        return this.getFirstMessageItem();
    }

    public PimItem getNextItem() throws ExWebDavPimException {
        return this.getNextMessageItem();
    }

    public PimItem getLastItem() throws ExWebDavPimException {
        return this.getLastMessageItem();
    }

    public PimItem getPreviousItem() throws ExWebDavPimException {
        return this.getPreviousMessageItem();
    }

    public void addAddressEntryItem(PimAddressEntryItem pimAddressEntryItem) throws PimException {
    }
}

