/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.re;

import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.re.Pattern;
import java.util.ArrayList;

public final class RegExp {
    public static final String[] splitElements(String aPatternsString, String aPatternSeperator) {
        return RegExp.parsePatterns(aPatternsString, aPatternSeperator, null);
    }

    public static final String[] parsePatterns(String aPatternsString, String aPatternSeperator, String aChildPattern) {
        if (aPatternsString.length() == 0) {
            return Constants.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> lList = new ArrayList<String>();
        String[] stz = StringHelper.tokenize(aPatternsString, aPatternSeperator);
        int i = 0;
        while (i < stz.length) {
            String rule = stz[i];
            if (rule.equals("***")) {
                lList.add("");
            } else {
                if (aChildPattern != null) {
                    int childIndex = 0;
                    while (childIndex < rule.length()) {
                        String childRule = "";
                        childIndex = rule.indexOf(aChildPattern);
                        if (childIndex == -1) break;
                        if (childIndex == 0) {
                            lList.add("**");
                        } else if (rule.charAt(childIndex - 1) != Constants.ESCAPE_FORWARD_SLASH_CHAR) {
                            childRule = rule.substring(0, childIndex);
                            lList.add(childRule);
                        }
                        rule = childRule + "*" + rule.substring(childIndex + aChildPattern.length());
                    }
                }
                lList.add(rule);
            }
            ++i;
        }
        return lList.toArray(Constants.EMPTY_STRING_ARRAY);
    }

    public static int indexOf(Pattern aRulePattern, String aValue) {
        String[] sArray;
        int size;
        if (aValue == null || aValue.length() == 0 || aRulePattern.input.length() == 0) {
            return -1;
        }
        if (aRulePattern.ignoreCase) {
            aValue = aValue.toLowerCase();
        }
        if ((size = (sArray = aRulePattern.getSubStrings()).length) == 0) {
            return aValue.length();
        }
        boolean isFirstToken = true;
        int fromIndex = 0;
        int i = 0;
        while (i < size) {
            if (fromIndex >= aValue.length()) {
                return -1;
            }
            String token = sArray[i];
            int index = aValue.indexOf(token, fromIndex);
            if (index == -1) {
                return -1;
            }
            if (isFirstToken) {
                if (!aRulePattern.starsWithAsterisk && index != 0) {
                    return -1;
                }
                isFirstToken = false;
            }
            fromIndex = index + token.length();
            ++i;
        }
        if (aRulePattern.endsWithAsterisk) {
            return aValue.length();
        }
        return fromIndex;
    }

    public static final boolean match(Pattern[] aMatchPatterns, String aValue) {
        int i = 0;
        while (i < aMatchPatterns.length) {
            if (RegExp.match(aMatchPatterns[i], aValue)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final boolean matchImpl(Pattern aMatchPattern, String aValue) {
        if (aValue == null) {
            return false;
        }
        if (aMatchPattern.onlyAsterisk) {
            return true;
        }
        aValue = aValue.trim();
        if (!aMatchPattern.hasAsterisk) {
            if (aMatchPattern.ignoreCase) {
                return aMatchPattern.input.equalsIgnoreCase(aValue);
            }
            return aMatchPattern.input.equals(aValue);
        }
        int index = RegExp.indexOf(aMatchPattern, aValue);
        if (index == -1) {
            return false;
        }
        return index == aValue.length();
    }

    public static final boolean match(Pattern aMatchPattern, String aValue) {
        boolean lResult = RegExp.matchImpl(aMatchPattern, aValue);
        if (aMatchPattern.negate) {
            lResult = !lResult;
        }
        return lResult;
    }

    public static void main(String[] args) {
        System.out.println(RegExp.indexOf(new Pattern(args[0]), args[1]));
    }
}

