/*
 * Decompiled with CFR 0.152.
 */
package com.sun.addressbook.ldap;

import com.sun.addressbook.ABDebug;
import com.sun.addressbook.ABFilter;
import com.sun.addressbook.ABSearchTerm;
import com.sun.addressbook.ABStore;
import com.sun.addressbook.ABStoreException;
import com.sun.addressbook.AddressBook;
import com.sun.addressbook.Element;
import com.sun.addressbook.Entry;
import com.sun.addressbook.Group;
import com.sun.addressbook.OperationNotSupportedException;
import com.sun.addressbook.ldap.LdapABConstants;
import com.sun.addressbook.ldap.LdapABSearchTerm;
import com.sun.addressbook.ldap.LdapABStore;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPCompareAttrNames;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPEntryComparator;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;

public class LdapAddressBook
extends AddressBook {
    private static long lastPabTimeStamp = 0L;
    private LdapABStore ldapStore = null;
    private String fullPabSearchBase = null;
    private String pabLang = null;

    public LdapAddressBook(ABStore store, String abID) {
        super(store, abID);
        this.ldapStore = (LdapABStore)store;
        this.fullPabSearchBase = this.ldapStore.getFullPabSearchBase();
        this.pabLang = this.ldapStore.getPabLang();
    }

    public Element[] fetch(ABFilter abFilter) throws ABStoreException, OperationNotSupportedException {
        if (abFilter.getElementType() == 1) {
            ABDebug.logMessage("LdapAddressBook.fetch():  fetchEntries called");
            return this.fetchEntries(abFilter);
        }
        if (abFilter.getElementType() == 2) {
            ABDebug.logMessage("LdapAddressBook.fetch():  fetchGroups called");
            return this.fetchGroups(abFilter);
        }
        if (abFilter.getElementType() == 4) {
            String msg = "LdapAddressBook.fetch: Multiple/Sub address books not supported in SunONE Messaging Server";
            ABDebug.logError(msg);
            throw new OperationNotSupportedException(msg);
        }
        ABDebug.logMessage("LdapAddressBook.fetch():  fetchAll called");
        return this.fetchAll(abFilter);
    }

    protected Entry[] fetchEntries(ABFilter abFilter) throws ABStoreException, OperationNotSupportedException {
        LDAPConnection ld = this.ldapStore.LDAPConnect();
        ArrayList<Entry> listEntries = null;
        if (ld == null) {
            String msg = "LdapAddressBook.fetch:failed to get ldap conn from pool";
            ABDebug.logError(msg);
            throw new ABStoreException(msg);
        }
        String searchBase = this.fullPabSearchBase;
        String searchFilterHeader = "(&(memberofpab=" + this.abID + ")(" + "objectclass" + "=" + "pabperson" + ")";
        if (abFilter.getGroup() != null) {
            searchFilterHeader = searchFilterHeader + "(memberofpabgroup=" + abFilter.getGroup().getUn() + ")";
        }
        String searchFilter = (String)abFilter.getSearchFilter();
        searchFilter = searchFilterHeader + searchFilter + ")";
        ABDebug.logMessage("LdapAddressBook.fetch(): search Filter = " + searchFilter);
        LDAPSearchResults ldapsearchresults = null;
        String[] searchAttr = new String[]{"un", "givenname", "sn", "cn", "mail", "description", "telephonenumber", "homephone", "mobile", "street", "l", "st", "postalcode", "co", "facsimiletelephonenumber", "pager", "dateofbirth", "labeleduri", "memberofpab", "memberofpabgroup"};
        try {
            ldapsearchresults = ld.search(searchBase, 2, searchFilter, searchAttr, false);
            if (ldapsearchresults == null) {
                ABDebug.logError("LdapAddressBook.fetch: ldapsearchresults should never be null!Problem in ldap search");
                this.ldapStore.LDAPClose(ld);
                throw new ABStoreException("LdapAddressBook.fetch: ldapsearchresults should never null");
            }
        }
        catch (LDAPException ldapE) {
            ABDebug.logError("LdapAddressBook.fetch: search for pab entries failed: " + (Object)((Object)ldapE));
            this.ldapStore.LDAPClose(ld);
            throw new ABStoreException("LdapAddressBook.fetch: search for pab entries failed: " + (Object)((Object)ldapE));
        }
        if (ldapsearchresults != null) {
            ABDebug.logMessage("LdapAddressBook.fetch(): searchresults count = " + ldapsearchresults.getCount());
            String sortBy = abFilter.getSortBy();
            if (sortBy != null && !sortBy.trim().equals("")) {
                boolean ascend = true;
                ascend = abFilter.getSortOrder() == 1 ? true : abFilter.getSortOrder() != 2;
                String sortAttr = null;
                LdapABConstants constants = new LdapABConstants();
                try {
                    Field attr = constants.getClass().getField("ATTR_" + sortBy);
                    String attrName = (String)attr.get(null);
                    ABDebug.logMessage("LdapAddressBook.fetch: Sort By = " + attrName);
                    sortAttr = attrName;
                }
                catch (IllegalAccessException iae) {
                    ABDebug.logError("Cannot access ATTR_" + sortBy);
                    throw new ABStoreException("Cannot access ATTR_" + sortBy + " from LdapABConstants");
                }
                catch (NoSuchFieldException nfe) {
                    ABDebug.logError("Field ATTR_" + sortBy + " not found");
                    throw new ABStoreException("Field ATTR_" + sortBy + " not found");
                }
                if (sortAttr != null) {
                    ldapsearchresults.sort((LDAPEntryComparator)new LDAPCompareAttrNames(sortAttr, ascend));
                }
            }
            listEntries = new ArrayList<Entry>(ldapsearchresults.getCount());
            int index = 0;
            try {
                while (ldapsearchresults.hasMoreElements()) {
                    LDAPEntry ldapentry = ldapsearchresults.next();
                    listEntries.add(this.toEntry(ldapentry, searchAttr, index));
                    ++index;
                }
            }
            catch (LDAPException ldapE) {
                String msg = "LdapAddressBook.fetch:  problem processing pab search results:  " + (Object)((Object)ldapE);
                ABDebug.logError(msg);
                this.ldapStore.LDAPClose(ld);
                throw new ABStoreException(msg);
            }
        }
        ldapsearchresults = null;
        this.ldapStore.LDAPClose(ld);
        ABDebug.logMessage("Final listEntries.size = " + listEntries.size());
        return listEntries.toArray(new Entry[listEntries.size()]);
    }

    protected Group[] fetchGroups(ABFilter abFilter) throws ABStoreException, OperationNotSupportedException {
        Object groups = null;
        LDAPConnection ld = this.ldapStore.LDAPConnect();
        ArrayList<Group> listGroups = null;
        if (ld == null) {
            String msg = "LdapAddressBook.connect:failed to get ldap connection from pool";
            ABDebug.logError(msg);
            throw new ABStoreException(msg);
        }
        String searchBase = this.fullPabSearchBase;
        String searchFilterHeader = "(&(memberofpab=" + this.abID + ")(" + "objectclass" + "=" + "pabgroup" + ")";
        if (abFilter.getGroup() != null) {
            searchFilterHeader = searchFilterHeader + "(memberofpabgroup=" + abFilter.getGroup().getUn() + ")";
        }
        String searchFilter = (String)abFilter.getSearchFilter();
        searchFilter = searchFilterHeader + searchFilter + ")";
        ABDebug.logMessage("LdapAddressBook.fetchGroups(): search Filter = " + searchFilter);
        LDAPSearchResults ldapsearchresults = null;
        String[] searchAttr = new String[]{"un", "cn", "description"};
        try {
            ldapsearchresults = ld.search(searchBase, 2, searchFilter, searchAttr, false);
            if (ldapsearchresults == null) {
                ABDebug.logError("LdapAddressBook.fetchGroups: ldapsearchresults should never be null!Problem in ldap search");
                this.ldapStore.LDAPClose(ld);
                throw new ABStoreException("LdapAddressBook.fetchGroups: ldapsearchresults should never null");
            }
        }
        catch (LDAPException ldapE) {
            ABDebug.logError("LdapAddressBook.fetchGroups: search for pab entries failed: " + (Object)((Object)ldapE));
            this.ldapStore.LDAPClose(ld);
            throw new ABStoreException("LdapAddressBook.fetchGroups: search for pab entries failed: " + (Object)((Object)ldapE));
        }
        if (ldapsearchresults != null) {
            ABDebug.logMessage("LdapAddressBook.fetchGroups(): searchresults count = " + ldapsearchresults.getCount());
            String sortBy = abFilter.getSortBy();
            if (sortBy != null && sortBy.trim().equals("cn")) {
                boolean ascend = true;
                ascend = abFilter.getSortOrder() == 1 ? true : abFilter.getSortOrder() != 2;
                Object sortAttr = null;
                ldapsearchresults.sort((LDAPEntryComparator)new LDAPCompareAttrNames(sortBy, ascend));
            }
            listGroups = new ArrayList<Group>(ldapsearchresults.getCount());
            int index = 0;
            try {
                while (ldapsearchresults.hasMoreElements()) {
                    LDAPEntry ldapentry = ldapsearchresults.next();
                    listGroups.add(this.toGroup(ldapentry, searchAttr, index));
                    ++index;
                }
            }
            catch (LDAPException ldapE) {
                this.ldapStore.LDAPClose(ld);
                throw new ABStoreException("LdapAddressBook.fetchGroups:  problem processing groups fetch results:  " + (Object)((Object)ldapE));
            }
        }
        ldapsearchresults = null;
        this.ldapStore.LDAPClose(ld);
        ABDebug.logMessage("Final listGroups.size = " + listGroups.size());
        return listGroups.toArray(new Group[listGroups.size()]);
    }

    protected Element[] fetchAll(ABFilter abFilter) throws ABStoreException, OperationNotSupportedException {
        LDAPConnection ld = this.ldapStore.LDAPConnect();
        ArrayList<Element> listElements = null;
        if (ld == null) {
            String msg = "LdapAddressBook.fetch:failed to get ldap conn from pool";
            ABDebug.logError(msg);
            throw new ABStoreException(msg);
        }
        String searchBase = this.fullPabSearchBase;
        String searchFilterHeader = "(&(memberofpab=" + this.abID + ")(| ( " + "objectclass" + "=" + "pabperson" + " ) ( " + "objectclass" + "=" + "pabgroup" + " ) )";
        if (abFilter.getGroup() != null) {
            searchFilterHeader = searchFilterHeader + "(memberofpabgroup=" + abFilter.getGroup().getUn() + ")";
        }
        String searchFilter = (String)abFilter.getSearchFilter();
        searchFilter = searchFilterHeader + searchFilter + ")";
        ABDebug.logMessage("LdapAddressBook.fetch(): search Filter = " + searchFilter);
        ABDebug.logMessage("LdapAddressBook.fetch(): searchFilterHeader = " + searchFilterHeader);
        LDAPSearchResults ldapsearchresults = null;
        String[] searchAttr = new String[]{"un", "givenname", "sn", "cn", "mail", "description", "telephonenumber", "homephone", "mobile", "street", "l", "st", "postalcode", "co", "facsimiletelephonenumber", "pager", "dateofbirth", "labeleduri", "memberofpab", "memberofpabgroup", "objectclass"};
        try {
            ldapsearchresults = ld.search(searchBase, 2, searchFilter, searchAttr, false);
            if (ldapsearchresults == null) {
                ABDebug.logError("LdapAddressBook.fetch: ldapsearchresults should never be null!Problem in ldap search");
                this.ldapStore.LDAPClose(ld);
                throw new ABStoreException("LdapAddressBook.fetch: ldapsearchresults should never null");
            }
        }
        catch (LDAPException ldapE) {
            ABDebug.logError("LdapAddressBook.fetch: search for pab entries failed: " + (Object)((Object)ldapE));
            this.ldapStore.LDAPClose(ld);
            throw new ABStoreException("LdapAddressBook.fetch: search for pab entries failed: " + (Object)((Object)ldapE));
        }
        if (ldapsearchresults != null) {
            ABDebug.logMessage("LdapAddressBook.fetch(): searchresults count = " + ldapsearchresults.getCount());
            String sortBy = abFilter.getSortBy();
            ABDebug.logMessage("LdapAddressBook.sortBy(): sortBy = " + sortBy);
            if (sortBy != null && sortBy.trim().equals("cn")) {
                boolean ascend = true;
                ascend = abFilter.getSortOrder() == 1 ? true : abFilter.getSortOrder() != 2;
                ABDebug.logMessage("LdapAddressBook.fetchAll(): ascend = " + ascend);
                ldapsearchresults.sort((LDAPEntryComparator)new LDAPCompareAttrNames(sortBy, ascend));
            } else {
                ABDebug.logMessage("LdapAddressBook.fetchAll(): results not sorted");
            }
            listElements = new ArrayList<Element>(ldapsearchresults.getCount());
            int index = 0;
            try {
                while (ldapsearchresults.hasMoreElements()) {
                    LDAPEntry ldapentry = ldapsearchresults.next();
                    this.printResults(ldapentry, searchAttr);
                    LDAPAttribute tmp = ldapentry.getAttribute("objectclass");
                    String obj_class = tmp.getStringValueArray()[tmp.size() - 1];
                    if (obj_class.equals("pabperson")) {
                        listElements.add(this.toEntry(ldapentry, searchAttr, index));
                    } else if (obj_class.equals("pabgroup")) {
                        String[] groupAttr = new String[]{"un", "cn", "description"};
                        listElements.add(this.toGroup(ldapentry, groupAttr, index));
                    }
                    ++index;
                }
            }
            catch (LDAPException ldapE) {
                String msg = "LdapAddressBook.fetch:  problem processing pab search results:  " + (Object)((Object)ldapE);
                ABDebug.logError(msg);
                this.ldapStore.LDAPClose(ld);
                throw new ABStoreException(msg);
            }
        }
        ldapsearchresults = null;
        this.ldapStore.LDAPClose(ld);
        ABDebug.logMessage("Final listElements.size = " + listElements.size());
        return listElements.toArray(new Element[listElements.size()]);
    }

    public void add(Element element) throws ABStoreException, OperationNotSupportedException {
        if (element.getElementType() == 1) {
            this.addEntry((Entry)element);
            return;
        }
        if (element.getElementType() == 2) {
            this.addGroup((Group)element);
            return;
        }
        if (element.getElementType() == 4) {
            String msg = "LdapAddressBook.add: Creating address books not supported";
            throw new OperationNotSupportedException(msg);
        }
        String msg = "LdapAddressBook.add: Invalid elementType";
        throw new ABStoreException(msg);
    }

    protected void addEntry(Entry entry) throws ABStoreException, OperationNotSupportedException {
        String[] objClass = new String[]{"top", "person", "organizationalPerson", "inetOrgPerson", "pabperson"};
        LDAPConnection ld = this.ldapStore.LDAPConnect();
        if (ld == null) {
            String msg = "LdapAddressBook.connect:failed to get ldap connection from pool";
            ABDebug.logError(msg);
            throw new ABStoreException(msg);
        }
        LDAPAttributeSet entryAttr = new LDAPAttributeSet();
        entryAttr.add(new LDAPAttribute("objectclass", objClass));
        entryAttr.add(new LDAPAttribute("memberofpab", this.abID));
        if (entry.getFn() != null) {
            entryAttr.add(new LDAPAttribute("givenname", entry.getFn()));
        }
        if (entry.getLn() != null) {
            entryAttr.add(new LDAPAttribute("sn", entry.getLn()));
        }
        if (entry.getCn() == null) {
            entry.setCn(entry.getFn() + " " + entry.getLn());
        }
        entryAttr.add(new LDAPAttribute("cn", entry.getCn()));
        if (entry.getEm() != null) {
            entryAttr.add(new LDAPAttribute("mail", entry.getEm()));
        }
        if (entry.getDescription() != null) {
            entryAttr.add(new LDAPAttribute("description", entry.getDescription()));
        }
        if (entry.getBp() != null) {
            entryAttr.add(new LDAPAttribute("telephonenumber", entry.getBp()));
        }
        if (entry.getHp() != null) {
            entryAttr.add(new LDAPAttribute("homephone", entry.getHp()));
        }
        if (entry.getMp() != null) {
            entryAttr.add(new LDAPAttribute("mobile", entry.getMp()));
        }
        if (entry.getHomeStreet() != null) {
            entryAttr.add(new LDAPAttribute("street", entry.getHomeStreet()));
        }
        if (entry.getHomeCity() != null) {
            entryAttr.add(new LDAPAttribute("l", entry.getHomeCity()));
        }
        if (entry.getHomeState() != null) {
            entryAttr.add(new LDAPAttribute("st", entry.getHomeState()));
        }
        if (entry.getHomeZip() != null) {
            entryAttr.add(new LDAPAttribute("postalcode", entry.getHomeZip()));
        }
        if (entry.getHomeCountry() != null) {
            entryAttr.add(new LDAPAttribute("co", entry.getHomeCountry()));
        }
        if (entry.getFp() != null) {
            entryAttr.add(new LDAPAttribute("facsimiletelephonenumber", entry.getFp()));
        }
        if (entry.getPp() != null) {
            entryAttr.add(new LDAPAttribute("pager", entry.getPp()));
        }
        if (entry.getDob() != null) {
            entryAttr.add(new LDAPAttribute("dateofbirth", entry.getDob()));
        }
        if (entry.getUri() != null) {
            entryAttr.add(new LDAPAttribute("labeleduri", entry.getUri()));
        }
        if (entry.getMemberofpabgroup() != null) {
            entryAttr.add(new LDAPAttribute("memberofpabgroup", entry.getMemberofpabgroup()));
        }
        String dn = "un=" + this.trimForIMS51(entry.getFn()) + this.trimForIMS51(entry.getLn()) + this.pabTimeStamp() + "," + this.fullPabSearchBase;
        LDAPEntry ldapentry = new LDAPEntry(dn, entryAttr);
        try {
            ld.add(ldapentry);
        }
        catch (LDAPException ldapE) {
            String msg = "LdapAddressBook.add: failed to add pab entry - " + entry.getUn() + " : " + (Object)((Object)ldapE);
            ABDebug.logError(msg);
            this.ldapStore.LDAPClose(ld);
            throw new ABStoreException(msg);
        }
        this.ldapStore.LDAPClose(ld);
    }

    protected void addGroup(Group group) throws ABStoreException, OperationNotSupportedException {
        String[] objClass = new String[]{"top", "pabgroup"};
        LDAPConnection ld = this.ldapStore.LDAPConnect();
        if (ld == null) {
            String msg = "LdapAddressBook.connect:failed to get ldap connection from pool";
            ABDebug.logError(msg);
            throw new ABStoreException(msg);
        }
        LDAPAttributeSet groupAttr = new LDAPAttributeSet();
        groupAttr.add(new LDAPAttribute("objectclass", objClass));
        groupAttr.add(new LDAPAttribute("memberofpab", this.abID));
        if (group.getCn() != null) {
            groupAttr.add(new LDAPAttribute("cn", group.getCn()));
        }
        if (group.getDescription() != null) {
            groupAttr.add(new LDAPAttribute("description", group.getDescription()));
        }
        String dn = "un=" + this.trimForIMS51(group.getCn()) + this.pabTimeStamp() + "," + this.fullPabSearchBase;
        LDAPEntry ldapentry = new LDAPEntry(dn, groupAttr);
        try {
            ld.add(ldapentry);
        }
        catch (LDAPException ldapE) {
            String msg = "LdapAddressBook.addGroup: failed to add pab group - " + group.getUn() + " :" + (Object)((Object)ldapE);
            ABDebug.logError(msg);
            this.ldapStore.LDAPClose(ld);
            throw new ABStoreException(msg);
        }
        this.ldapStore.LDAPClose(ld);
    }

    public void modify(Element oldElement, Element newElement) throws ABStoreException, OperationNotSupportedException {
        if (oldElement.getElementType() == 1) {
            this.modifyEntry((Entry)oldElement, (Entry)newElement);
            return;
        }
        if (oldElement.getElementType() == 2) {
            this.modifyGroup((Group)oldElement, (Group)newElement);
            return;
        }
        if (oldElement.getElementType() == 4) {
            String msg = "LdapAddressBook.add: Modifying address books not supported";
            throw new OperationNotSupportedException(msg);
        }
        String msg = "LdapAddressBook.add: Invalid elementType";
        throw new ABStoreException(msg);
    }

    protected void modifyEntry(Entry oldEntry, Entry newEntry) throws ABStoreException, OperationNotSupportedException {
        LDAPConnection ld = this.ldapStore.LDAPConnect();
        if (ld == null) {
            String msg = "LdapAddressBook.connect:failed to get ldap connection from pool";
            ABDebug.logError(msg);
            throw new ABStoreException(msg);
        }
        LDAPModificationSet mods = new LDAPModificationSet();
        if (newEntry.getFn() != null) {
            mods.add(2, new LDAPAttribute("givenname", newEntry.getFn()));
        }
        if (newEntry.getLn() != null) {
            mods.add(2, new LDAPAttribute("sn", newEntry.getLn()));
        }
        if (newEntry.getCn() == null) {
            String fn = newEntry.getFn();
            String ln = newEntry.getLn();
            if (ln == null) {
                ln = "";
            }
            if (fn == null) {
                fn = "";
            }
            newEntry.setCn(fn + " " + ln);
        }
        mods.add(2, new LDAPAttribute("cn", newEntry.getCn()));
        if (newEntry.getEm() != null) {
            mods.add(2, new LDAPAttribute("mail", newEntry.getEm()));
        }
        if (newEntry.getDescription() != null) {
            mods.add(2, new LDAPAttribute("description", newEntry.getDescription()));
        }
        if (newEntry.getBp() != null) {
            mods.add(2, new LDAPAttribute("telephonenumber", newEntry.getBp()));
        }
        if (newEntry.getHp() != null) {
            mods.add(2, new LDAPAttribute("homephone", newEntry.getHp()));
        }
        if (newEntry.getMp() != null) {
            mods.add(2, new LDAPAttribute("mobile", newEntry.getMp()));
        }
        if (newEntry.getHomeStreet() != null) {
            mods.add(2, new LDAPAttribute("street", newEntry.getHomeStreet()));
        }
        if (newEntry.getHomeCity() != null) {
            mods.add(2, new LDAPAttribute("l", newEntry.getHomeCity()));
        }
        if (newEntry.getHomeState() != null) {
            mods.add(2, new LDAPAttribute("st", newEntry.getHomeState()));
        }
        if (newEntry.getHomeZip() != null) {
            mods.add(2, new LDAPAttribute("postalcode", newEntry.getHomeZip()));
        }
        if (newEntry.getHomeCountry() != null) {
            mods.add(2, new LDAPAttribute("co", newEntry.getHomeCountry()));
        }
        if (newEntry.getFp() != null) {
            mods.add(2, new LDAPAttribute("facsimiletelephonenumber", newEntry.getFp()));
        }
        if (newEntry.getPp() != null) {
            mods.add(2, new LDAPAttribute("pager", newEntry.getPp()));
        }
        if (newEntry.getDob() != null) {
            mods.add(2, new LDAPAttribute("dateofbirth", newEntry.getDob()));
        }
        if (newEntry.getUri() != null) {
            mods.add(2, new LDAPAttribute("labeleduri", newEntry.getUri()));
        }
        if (newEntry.getMemberofpabgroup() != null) {
            mods.add(2, new LDAPAttribute("memberofpabgroup", newEntry.getMemberofpabgroup()));
        }
        String dn = "un=" + oldEntry.getUn() + "," + this.fullPabSearchBase;
        try {
            ld.modify(dn, mods);
        }
        catch (LDAPException ldapE) {
            String msg = "LdapAddressBook.modify:  failed to modify pab entry - " + oldEntry.getUn() + " :" + (Object)((Object)ldapE);
            ABDebug.logError(msg);
            this.ldapStore.LDAPClose(ld);
            throw new ABStoreException(msg);
        }
        this.ldapStore.LDAPClose(ld);
    }

    public void modifyGroup(Group oldGroup, Group newGroup) throws ABStoreException, OperationNotSupportedException {
        LDAPConnection ld = this.ldapStore.LDAPConnect();
        if (ld == null) {
            String msg = "LdapAddressBook.connect:failed to get ldap connection from pool";
            ABDebug.logError(msg);
            throw new ABStoreException(msg);
        }
        LDAPModificationSet mods = new LDAPModificationSet();
        if (newGroup.getCn() != null) {
            mods.add(2, new LDAPAttribute("cn", newGroup.getCn()));
        }
        if (newGroup.getDescription() != null) {
            mods.add(2, new LDAPAttribute("description", newGroup.getDescription()));
        }
        String dn = "un=" + oldGroup.getUn() + "," + this.fullPabSearchBase;
        try {
            ld.modify(dn, mods);
        }
        catch (LDAPException ldapE) {
            String msg = "LdapAddressBook.renameGroup:  failed to modify pab group - " + oldGroup.getUn() + " :" + (Object)((Object)ldapE);
            ABDebug.logError(msg);
            this.ldapStore.LDAPClose(ld);
            throw new ABStoreException(msg);
        }
        this.ldapStore.LDAPClose(ld);
    }

    public void delete(Element element) throws ABStoreException, OperationNotSupportedException {
        if (element.getElementType() == 1) {
            this.deleteEntry((Entry)element);
            return;
        }
        if (element.getElementType() == 2) {
            this.deleteGroup((Group)element);
            return;
        }
        if (element.getElementType() == 4) {
            String msg = "LdapAddressBook.add: Deleting address books not supported";
            throw new OperationNotSupportedException(msg);
        }
        String msg = "LdapAddressBook.add: Invalid elementType";
        throw new ABStoreException(msg);
    }

    protected void deleteEntry(Entry entry) throws ABStoreException, OperationNotSupportedException {
        LDAPConnection ld = this.ldapStore.LDAPConnect();
        if (ld == null) {
            String msg = "LdapAddressBook.connect:failed to get ldap connection from pool";
            ABDebug.logError(msg);
            throw new ABStoreException(msg);
        }
        String entryUNtoDel = entry.getUn();
        try {
            String dn = "un=" + entryUNtoDel + "," + this.fullPabSearchBase;
            ld.delete(dn);
        }
        catch (LDAPException ldapE) {
            String msg = "LdapAddressBook.delete: failed to delete Entry - " + entry.getUn() + " : " + (Object)((Object)ldapE);
            ABDebug.logError(msg);
            this.ldapStore.LDAPClose(ld);
            throw new ABStoreException(msg);
        }
        this.ldapStore.LDAPClose(ld);
    }

    protected void deleteGroup(Group group) throws ABStoreException, OperationNotSupportedException {
        LDAPConnection ld = this.ldapStore.LDAPConnect();
        if (ld == null) {
            String msg = "LdapAddressBook.connect:failed to get ldap connection from pool";
            ABDebug.logError(msg);
            throw new ABStoreException(msg);
        }
        String groupUNtoDel = group.getUn();
        try {
            String dn = "un=" + groupUNtoDel + "," + this.fullPabSearchBase;
            ld.delete(dn);
        }
        catch (LDAPException ldapE) {
            String msg = "LdapAddressBook.deleteGroup: failed to delete Group - " + group.getUn() + " :" + (Object)((Object)ldapE);
            ABDebug.logError(msg);
            this.ldapStore.LDAPClose(ld);
            throw new ABStoreException(msg);
        }
        this.ldapStore.LDAPClose(ld);
    }

    public ABSearchTerm newABSearchTerm(String name, String value, boolean exact) {
        return new LdapABSearchTerm(name, value, exact);
    }

    public ABSearchTerm newABSearchTerm(ABSearchTerm term, int op) throws ABStoreException {
        return new LdapABSearchTerm(term, op);
    }

    public ABSearchTerm newABSearchTerm(ABSearchTerm[] terms, int op) throws ABStoreException {
        return new LdapABSearchTerm(terms, op);
    }

    public Element[] fetchGroupMembers(ABFilter filter, Group group) throws ABStoreException, OperationNotSupportedException {
        filter.setGroup(group);
        Element[] elements = this.fetch(filter);
        filter.setGroup(null);
        return elements;
    }

    public void addGroupMember(Element element, Group group) throws ABStoreException, OperationNotSupportedException {
        if (group.getUn() == null) {
            throw new ABStoreException("LdapAddressBook.addGroupMember: Address Book Group not defined");
        }
        LDAPConnection ld = this.ldapStore.LDAPConnect();
        if (ld == null) {
            String msg = "LdapAddressBook.connect:failed to get ldap connection from pool";
            ABDebug.logError(msg);
            throw new ABStoreException(msg);
        }
        if (element.getElementType() == 1) {
            LDAPModificationSet mods = new LDAPModificationSet();
            mods.add(0, new LDAPAttribute("memberofpabgroup", group.getUn()));
            String dn = "un=" + element.getUn() + "," + this.fullPabSearchBase;
            try {
                ld.modify(dn, mods);
            }
            catch (LDAPException ldapE) {
                String msg = "LdapAddressBook.addGroupMember: failed to add address book element to group - " + group.getUn() + " :" + (Object)((Object)ldapE);
                ABDebug.logError(msg);
                this.ldapStore.LDAPClose(ld);
                throw new ABStoreException(msg);
            }
        }
        if (element.getElementType() == 2) {
            Group subGroup = (Group)element;
            ABFilter filter = new ABFilter();
            ABSearchTerm term = this.newABSearchTerm("any", "*", true);
            filter.setSearchTerm(term);
            filter.setElementType(3);
            Element[] elms = this.fetchGroupMembers(filter, subGroup);
            int i = 0;
            while (i < elms.length) {
                LDAPModificationSet mods = new LDAPModificationSet();
                mods.add(0, new LDAPAttribute("memberofpabgroup", group.getUn()));
                String dn = "un=" + elms[i].getUn() + "," + this.fullPabSearchBase;
                try {
                    ld.modify(dn, mods);
                }
                catch (LDAPException ldapE) {
                    String msg = "LdapAddressBook.addGroupMember: failed to add address book element to group - " + group.getUn() + " :" + (Object)((Object)ldapE);
                    ABDebug.logError(msg);
                    this.ldapStore.LDAPClose(ld);
                    throw new ABStoreException(msg);
                }
                ++i;
            }
        }
        this.ldapStore.LDAPClose(ld);
    }

    public void deleteGroupMember(Element element, Group group) throws ABStoreException, OperationNotSupportedException {
        if (group.getUn() == null) {
            throw new ABStoreException("LdapAddressBook.deleteGroupMember: Address Book Group not defined");
        }
        LDAPConnection ld = this.ldapStore.LDAPConnect();
        if (ld == null) {
            String msg = "LdapAddressBook.connect:failed to get ldap connection from pool";
            ABDebug.logError(msg);
            throw new ABStoreException(msg);
        }
        LDAPModificationSet mods = new LDAPModificationSet();
        mods.add(1, new LDAPAttribute("memberofpabgroup", group.getUn()));
        String dn = "un=" + element.getUn() + "," + this.fullPabSearchBase;
        try {
            ld.modify(dn, mods);
        }
        catch (LDAPException ldapE) {
            String msg = "LdapAddressBook.deleteGroupMember: failed to delete address book element from group - " + group.getUn() + " :" + (Object)((Object)ldapE);
            ABDebug.logError(msg);
            this.ldapStore.LDAPClose(ld);
            throw new ABStoreException(msg);
        }
        this.ldapStore.LDAPClose(ld);
    }

    private synchronized String pabTimeStamp() {
        long current = System.currentTimeMillis() / 1000L - 915170400L;
        lastPabTimeStamp = current > lastPabTimeStamp ? current : ++lastPabTimeStamp;
        return Long.toString(lastPabTimeStamp);
    }

    private String trimForIMS51(String str) {
        StringBuffer trimmedStr = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                trimmedStr.append(c);
            }
            ++i;
        }
        return trimmedStr.toString();
    }

    private Entry toEntry(LDAPEntry ldapentry, String[] attrs, int index) {
        Entry entry = null;
        String[] strEntry = new String[attrs.length];
        int i = 0;
        while (i < attrs.length) {
            LDAPAttribute ldapattribute = ldapentry.getAttribute(attrs[i], "lang-" + this.pabLang);
            if (ldapattribute != null) {
                Enumeration enumeration = ldapattribute.getStringValues();
                boolean flag = false;
                while (enumeration != null && enumeration.hasMoreElements()) {
                    strEntry[i] = (String)enumeration.nextElement();
                    flag = true;
                }
                if (!flag) {
                    strEntry[i] = "";
                }
            } else {
                strEntry[i] = "";
            }
            ++i;
        }
        entry = new Entry(strEntry[0], strEntry[1], strEntry[2], strEntry[3], strEntry[4], strEntry[5], strEntry[6], strEntry[7], strEntry[8], strEntry[9], strEntry[10], strEntry[11], strEntry[12], strEntry[13], null, null, null, null, null, strEntry[14], strEntry[15], strEntry[16], strEntry[17], strEntry[18], strEntry[19], "", Integer.toString(index));
        return entry;
    }

    private Group toGroup(LDAPEntry ldapentry, String[] attrs, int index) {
        Group group = null;
        String[] strGroup = new String[attrs.length];
        int i = 0;
        while (i < attrs.length) {
            LDAPAttribute ldapattribute = ldapentry.getAttribute(attrs[i], "lang-" + this.pabLang);
            if (ldapattribute != null) {
                Enumeration enumeration = ldapattribute.getStringValues();
                boolean flag = false;
                while (enumeration != null && enumeration.hasMoreElements()) {
                    strGroup[i] = (String)enumeration.nextElement();
                    flag = true;
                }
                if (!flag) {
                    strGroup[i] = "";
                }
            } else {
                strGroup[i] = "";
            }
            ++i;
        }
        group = new Group(strGroup[0], strGroup[1], strGroup[2], Integer.toString(index));
        return group;
    }

    private void printResults(LDAPEntry ldapentry, String[] as) {
        StringBuffer content = new StringBuffer();
        content.append("==================================================================\n");
        content.append("Length of attributes is " + as.length + "\n");
        int i = 0;
        while (i < as.length) {
            LDAPAttribute ldapattribute = ldapentry.getAttribute(as[i], "lang-" + this.pabLang);
            if (ldapattribute != null) {
                Enumeration enumeration = ldapattribute.getStringValues();
                boolean flag = false;
                while (enumeration != null && enumeration.hasMoreElements()) {
                    String s = (String)enumeration.nextElement();
                    content.append(as[i] + " : " + s + "\n");
                    flag = true;
                }
                if (!flag) {
                    content.append(as[i] + " has no value\n");
                }
                content.append("----------------\n");
            } else {
                content.append(as[i] + " not present!!! \n");
            }
            ++i;
        }
        content.append("DN: " + ldapentry.getDN() + "\n");
        content.append("==================================================================\n");
        ABDebug.logError(content.toString());
    }
}

