/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.econnection;

import com.sun.portal.netlet.econnection.CipherMsg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SessionCipherMsg
extends CipherMsg {
    protected byte[] sessId = null;

    public SessionCipherMsg() {
        super((byte)1, (short)1);
    }

    public SessionCipherMsg(byte[] byArray, int n) {
        super((byte)1, (short)1);
        this.msgLen = n;
        this.sessId = new byte[n];
        System.arraycopy(byArray, 0, this.sessId, 0, n);
    }

    public int readMsg(DataInputStream dataInputStream) {
        int n = 0;
        n = this.readHeader(dataInputStream);
        if (n == 0) {
            if (this.msgLen > 0) {
                if (this.sessId != null) {
                    this.sessId = null;
                }
                byte[] byArray = new byte[this.msgLen];
                try {
                    dataInputStream.readFully(byArray, 0, this.msgLen);
                    this.sessId = new byte[this.msgLen];
                    System.arraycopy(byArray, 0, this.sessId, 0, this.msgLen);
                }
                catch (IOException iOException) {
                    System.out.println("SessionMsg: readMsg IOE: " + iOException);
                    n = -1;
                }
                byArray = null;
            } else {
                n = -1;
            }
        }
        return n;
    }

    public int writeMsg(DataOutputStream dataOutputStream) {
        int n = 0;
        try {
            byte[] byArray = new byte[this.sessId.length];
            System.arraycopy(this.sessId, 0, byArray, 0, this.msgLen);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(11 + this.sessId.length);
            DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
            int n2 = this.msgLen;
            this.writeHeaderToByteArray(byteArrayOutputStream);
            byteArrayOutputStream.write(byArray, 0, this.msgLen);
            byteArrayOutputStream.writeTo(dataOutputStream);
            dataOutputStream.flush();
            this.msgLen = n2;
            byArray = null;
        }
        catch (IOException iOException) {
            System.out.println("SessionMsg: writeMsg IOE: " + iOException);
            n = -1;
        }
        return n;
    }

    public byte[] getToDataStream() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.sessId, 0, this.msgLen);
        return byteArrayOutputStream.toByteArray();
    }

    public int setFromDataStream(byte[] byArray, int n) {
        int n2 = 0;
        if (n > 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.msgLen = n;
            byteArrayInputStream.read(this.sessId, 0, this.msgLen);
        } else {
            n2 = -1;
        }
        return n2;
    }

    public byte[] getSessionId() {
        if (this.msgLen > 0) {
            byte[] byArray = new byte[this.msgLen];
            System.arraycopy(this.sessId, 0, byArray, 0, this.msgLen);
            return byArray;
        }
        return null;
    }

    public void setSessionId(byte[] byArray, int n) {
        this.msgLen = 0;
        if (this.sessId != null) {
            this.sessId = null;
        }
        this.sessId = new byte[n];
        System.arraycopy(byArray, 0, this.sessId, 0, n);
        this.msgLen = n;
    }
}

