/*
 * Decompiled with CFR 0.152.
 */
import com.sun.portal.netlet.econnection.Base64;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

class ProxySConn
extends Connection
implements ActionListener {
    private DataInputStream in_b;
    private DataOutputStream out_b;
    private String dhost;
    private int dport;
    private ProxyAuthDialog pad;
    private String puser;
    private String ppass;
    private SClientMgr parentMgr;

    public ProxySConn(int n, String string, boolean bl) {
        super(n, string);
    }

    public ProxySConn(int n, String string, String string2) {
        super(n, string);
        NetletSocketFactory netletSocketFactory = NetletSocketFactory.getNetletSocketFactory(SServer.getGWProtocol(), SServer.isJSSEEnabled, SServer.isPDCEnabled);
        this.conn = string2 != null ? netletSocketFactory.getSocket(this.conn, string, n, this.parseCipherList(string2)) : netletSocketFactory.getSocket(this.conn, string, n, null);
    }

    public ProxySConn(int n, String string, int n2, String string2, SClientMgr sClientMgr, String string3) throws ProxyAuthNeededException, ProxyAuthFailedException {
        this(n, string, n2, string2, sClientMgr, false, string3);
    }

    public ProxySConn(int n, String string, int n2, String string2, SClientMgr sClientMgr, boolean bl, String string3) throws ProxyAuthNeededException, ProxyAuthFailedException {
        super(n, string);
        this.dhost = string2;
        this.dport = n2;
        this.parentMgr = sClientMgr;
        if (this.conn != null) {
            try {
                this.in_b = new DataInputStream(this.conn.getInputStream());
                this.out_b = new DataOutputStream(this.conn.getOutputStream());
            }
            catch (IOException iOException) {
                System.out.println("ProxySConn setup IOE: " + iOException);
                try {
                    this.conn.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this.conn = null;
                return;
            }
            if (this.doProxyConnect(bl) != 0) {
                try {
                    this.conn.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.conn = null;
            }
            NetletSocketFactory netletSocketFactory = NetletSocketFactory.getNetletSocketFactory(SServer.getGWProtocol(), SServer.isJSSEEnabled, SServer.isPDCEnabled);
            this.conn = string3 != null ? netletSocketFactory.getSocket(this.conn, string2, n2, this.parseCipherList(string3)) : netletSocketFactory.getSocket(this.conn, string2, n2, null);
        }
    }

    public int doProxyConnect(boolean bl) throws ProxyAuthNeededException, ProxyAuthFailedException {
        int n = 0;
        String string = "CONNECT " + this.dhost + ":" + this.dport + " HTTP/1.0\r\n";
        try {
            if (bl || this.parentMgr != null && this.parentMgr.getProxyAuth()) {
                if (this.parentMgr != null) {
                    this.puser = this.parentMgr.getProxyAuthUsername();
                    this.ppass = this.parentMgr.getProxyAuthPassword();
                }
                if (this.puser == null || this.ppass == null) {
                    this.pad = new ProxyAuthDialog(new Frame(), this);
                    System.out.println("Netlet showing proxy authentication dialog");
                    this.pad.showWarning();
                    this.pad.waitForAction();
                }
                if (this.puser == null || this.ppass == null) {
                    throw new ProxyAuthFailedException(NetletUtil.getString("psconn.1"));
                }
                string = string + "Proxy-Authorization: Basic " + Base64.encode(this.puser + ":" + this.ppass) + "\r\n\r\n";
            } else {
                string = string + "\r\n";
            }
            this.out_b.write(string.getBytes(), 0, string.length());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.in_b));
            String string2 = "";
            while ((string2 = bufferedReader.readLine()) != null && string2.length() >= 3) {
                if (!string2.startsWith("HTTP/1")) continue;
                int n2 = string2.indexOf(" ");
                String string3 = string2.substring(n2 + 1);
                if (string3.startsWith("407")) {
                    throw new ProxyAuthNeededException("Proxy Authentication Required");
                }
                if (!string3.startsWith("401")) continue;
                throw new ProxyAuthFailedException(NetletUtil.getString("psconn.3"));
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.out.println("ProxySConn SIOBE connecting to proxy: " + stringIndexOutOfBoundsException);
            n = -1;
        }
        catch (IOException iOException) {
            System.out.println("ProxySConn IOE connecting to proxy: " + iOException);
            n = -1;
        }
        return n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!"cancel".equals(actionEvent.getActionCommand())) {
            this.puser = NetletUtil.rfc1522(this.pad.getUsername());
            this.ppass = NetletUtil.rfc1522(this.pad.getPassword());
            this.parentMgr.setProxyAuthUsername(this.puser);
            this.parentMgr.setProxyAuthPassword(this.ppass);
        }
        this.pad.notifyAction();
        ((Component)this.pad).setVisible(false);
        this.pad.dispose();
    }

    private String[] parseCipherList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n] = stringTokenizer.nextElement().toString();
        }
        return stringArray;
    }
}

