/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.js;

import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.engines.AbstractRewriter;
import com.sun.portal.rewriter.engines.PageContent;
import com.sun.portal.rewriter.engines.RewriterBroker;
import com.sun.portal.rewriter.engines.js.parser.JSParser;
import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.Resource;
import com.sun.portal.rewriter.util.StringHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;

public final class JSRewriter
extends AbstractRewriter {
    public JSRewriter(RewriterBroker aRewriterBroker) {
        super(aRewriterBroker, "application/x-javascript");
    }

    public final void plugableRewriter(PageContent aPageContent, Translator aTranslator) {
        this.parseJS(aPageContent, aTranslator);
    }

    private final void parseJS(PageContent aPageContent, Translator aTranslator) {
        try {
            int[][] indexList = new JSParser(aPageContent.getOriginalContent() + "\nfunction dummy(){}", this.getRuleSet(), aTranslator).parse();
            if (indexList.length > 0) {
                String rest;
                StringBuffer lResultBuffer = aPageContent.getResultBuffer();
                BufferedReader in = new BufferedReader(new StringReader(aPageContent.getOriginalContent()));
                LinkedList<Integer> lExpressionList = new LinkedList<Integer>();
                LinkedList<Integer> lSystemList = new LinkedList<Integer>();
                int bufferLineNo = -1;
                String line = null;
                int lineCursor = 0;
                int i = 0;
                while (i < indexList.length) {
                    int[] spec = indexList[i];
                    int opCode = spec[0];
                    int startLineNo = spec[1];
                    int startLineOffset = spec[2];
                    while (bufferLineNo < startLineNo) {
                        if (line != null) {
                            lResultBuffer.append(line.substring(lineCursor, line.length())).append('\n');
                        }
                        line = in.readLine();
                        lineCursor = 0;
                        ++bufferLineNo;
                    }
                    if (line != null) {
                        lResultBuffer.append(line.substring(lineCursor, startLineOffset));
                        lineCursor = startLineOffset;
                        switch (opCode) {
                            case 2: {
                                lExpressionList.addFirst(new Integer(lResultBuffer.length()));
                                break;
                            }
                            case 3: {
                                int expStart = (Integer)lExpressionList.removeFirst();
                                String bContent = lResultBuffer.substring(expStart);
                                lResultBuffer.replace(expStart, lResultBuffer.length(), this.translateEXPRESSION(bContent, aTranslator));
                                break;
                            }
                            case 7: {
                                lSystemList.addFirst(new Integer(lResultBuffer.length()));
                                break;
                            }
                            case 8: {
                                int beginIndex = (Integer)lSystemList.removeFirst();
                                String systemVariable = lResultBuffer.substring(beginIndex).trim();
                                lResultBuffer.replace(beginIndex, lResultBuffer.length(), this.translateSYSTEM(systemVariable, aTranslator));
                                break;
                            }
                            default: {
                                String bVariableValue;
                                int endLineNo = spec[3];
                                int endLineOffset = spec[4];
                                if (endLineNo == startLineNo) {
                                    bVariableValue = line.substring(lineCursor, endLineOffset - 1);
                                } else {
                                    StringBuffer sb = new StringBuffer();
                                    while (bufferLineNo < endLineNo) {
                                        sb.append(line.substring(lineCursor, line.length() - 1));
                                        line = in.readLine();
                                        lineCursor = 0;
                                        ++bufferLineNo;
                                    }
                                    sb.append(line.substring(0, endLineOffset - 1));
                                    bVariableValue = sb.toString();
                                }
                                lineCursor = endLineOffset - 1;
                                this.rewriteStringValue(bVariableValue, opCode, aTranslator, lResultBuffer);
                                break;
                            }
                        }
                    }
                    ++i;
                }
                if (line != null) {
                    lResultBuffer.append(line.substring(lineCursor, line.length()));
                }
                if ((rest = Resource.read((Reader)in)).length() > 0) {
                    lResultBuffer.append('\n');
                    lResultBuffer.append(rest);
                } else {
                    char endChar = aPageContent.charAt(aPageContent.length() - 1);
                    if (endChar == '\r' || endChar == '\n') {
                        lResultBuffer.append('\n');
                    }
                }
            }
        }
        catch (IOException e) {
            Debug.error("Bug in JSRewriter", e);
        }
    }

    private final void rewriteStringValue(String aValue2Rewrite, int aOpCode, Translator aTranslator, StringBuffer aResultBuffer) {
        String trimmedValue = aValue2Rewrite.trim();
        if (trimmedValue.length() == 0) {
            aResultBuffer.append(aValue2Rewrite);
            return;
        }
        switch (aOpCode) {
            case 1: {
                aResultBuffer.append(this.translateURL(aValue2Rewrite, aTranslator));
                break;
            }
            case 4: {
                aResultBuffer.append(this.translateDHTML(aValue2Rewrite, aTranslator));
                break;
            }
            case 5: {
                aResultBuffer.append(this.translateDJS(aValue2Rewrite, aTranslator));
            }
        }
    }

    public final void endRewriting(PageContent aPageContent, Translator aTranslator) {
        String jsFunctionsDefination = aTranslator.getLookAheadInfo().readJSFunctions(aTranslator);
        if (jsFunctionsDefination.length() != 0) {
            aPageContent.getResultBuffer().append(jsFunctionsDefination);
        }
    }

    private String translateURL(String aURI, Translator aTranslator) {
        return aTranslator.translate(aURI);
    }

    private final String translateEXPRESSION(String aJSExpression, Translator aTranslator) {
        String expContent = StringHelper.normalize(aJSExpression);
        if (expContent.length() == 0) {
            return aJSExpression;
        }
        int htmlEntityIndex = JSRewriter.parseForHTMLEntityIndex(expContent);
        char zeroChar = expContent.charAt(0);
        if (htmlEntityIndex == -1 && (zeroChar == '\"' || zeroChar == '\'' || zeroChar == '\\')) {
            int plusIndex = aJSExpression.indexOf(43);
            if (plusIndex != -1) {
                String firstPart = aJSExpression.substring(0, plusIndex);
                String[] parts = StringHelper.regExpSplit(firstPart, "");
                String urlPart = parts[1];
                if (urlPart.length() > 0 && (urlPart.startsWith("/") || urlPart.startsWith(".") || urlPart.regionMatches(true, 0, "http://", 0, 7) && urlPart.length() > 7 || urlPart.regionMatches(true, 0, "https://", 0, 8) && urlPart.length() > 8 || !urlPart.regionMatches(true, 0, "http", 0, 4))) {
                    StringBuffer sb = new StringBuffer(aJSExpression.length());
                    sb.append(aTranslator.translate(firstPart));
                    sb.append(aJSExpression.substring(plusIndex));
                    return sb.toString();
                }
            } else {
                return this.translateURL(aJSExpression, aTranslator);
            }
        }
        StringBuffer sb = new StringBuffer(aJSExpression.length());
        sb.append(aTranslator.getJSFunctionSpec().getExpressionFunctionName()).append('(').append(aJSExpression).append(')');
        aTranslator.getLookAheadInfo().addJSFunction(aTranslator.getJSFunctionSpec().getExpressionFunctionName());
        return sb.toString();
    }

    private String translateDHTML(String aDHTMLContent, Translator aTranslator) {
        String bHTMLContent = aDHTMLContent;
        char startChar = bHTMLContent.charAt(0);
        while (Character.isWhitespace(startChar) || startChar == Constants.DOUBLE_QUOTES_CHAR || startChar == Constants.SINGLE_QUOTES_CHAR || startChar == Constants.ESCAPE_FORWARD_SLASH_CHAR) {
            bHTMLContent = startChar == Constants.ESCAPE_FORWARD_SLASH_CHAR && bHTMLContent.length() >= "\\n".length() ? bHTMLContent.substring("\\n".length()) : bHTMLContent.substring(1);
            if (bHTMLContent.length() == 0) break;
            startChar = bHTMLContent.charAt(0);
        }
        if (bHTMLContent.length() == 0) {
            return aDHTMLContent;
        }
        StringBuffer sb = new StringBuffer(aDHTMLContent.length());
        int trimIndex = aDHTMLContent.indexOf(bHTMLContent);
        if (trimIndex > 0) {
            sb.append(aDHTMLContent.substring(0, trimIndex));
        }
        int appendedIndex = 0;
        if (!bHTMLContent.startsWith("<")) {
            bHTMLContent = "<" + bHTMLContent;
            appendedIndex = 1;
        }
        sb.append(this.getRewriterBroker().getInstance("text/html").rewrite(bHTMLContent, aTranslator).substring(appendedIndex));
        return sb.toString();
    }

    private final String translateDJS(String aDJSContent, Translator aTranslator) {
        String[] split = this.trimDJSQuotes(aDJSContent);
        if (StringHelper.startsWithIgnoreCase(split[1], "http:") || StringHelper.startsWithIgnoreCase(split[1], "https:") || split[1].startsWith("/") || split[1].startsWith(".")) {
            return aTranslator.translate(aDJSContent);
        }
        int i = split[1].indexOf(40);
        int j = split[1].indexOf(46);
        int k = split[1].indexOf(61);
        int l = split[1].indexOf(43);
        int m = split[1].indexOf(63);
        boolean isLocation = split[1].startsWith("location");
        if (isLocation || i != -1 || j != -1 || k != -1 || l != -1) {
            if (m == -1) {
                return this.doDJSRewrite(aDJSContent, aTranslator);
            }
            if (m < l && m < k && m < j) {
                return aTranslator.translate(aDJSContent);
            }
        }
        return this.doDJSRewrite(aDJSContent, aTranslator);
    }

    private String doDJSRewrite(String aDJSContent, Translator aTranslator) {
        String[] splitted = this.trimDJSQuotes(aDJSContent);
        String lResult = this.rewrite(splitted[1], aTranslator);
        return splitted[0] + lResult + splitted[2];
    }

    private final String translateSYSTEM(String aSystemVariable, Translator aTranslator) {
        StringBuffer lResultBuffer = new StringBuffer(aTranslator.getJSFunctionSpec().getSystemFunctionName());
        lResultBuffer.append("(");
        int i = aSystemVariable.lastIndexOf(".");
        if (i != -1) {
            lResultBuffer.append(aSystemVariable.substring(0, i));
        } else {
            lResultBuffer.append("null");
        }
        lResultBuffer.append(", ").append("'").append(aSystemVariable).append("', ");
        lResultBuffer.append(aSystemVariable);
        lResultBuffer.append(')');
        aTranslator.getLookAheadInfo().addJSFunction(aTranslator.getJSFunctionSpec().getSystemFunctionName());
        return lResultBuffer.toString();
    }

    private static int parseForHTMLEntityIndex(String expContent) {
        int queryIndex;
        int htmlEntityIndex = expContent.indexOf("&#");
        if (htmlEntityIndex != -1 && (queryIndex = expContent.indexOf("?")) != -1 && queryIndex < htmlEntityIndex) {
            htmlEntityIndex = -1;
        }
        return htmlEntityIndex;
    }

    private String[] trimDJSQuotes(String aDJSContent) {
        String lDJSContent = aDJSContent.trim();
        String[] lResult = new String[]{"", aDJSContent, ""};
        if (lDJSContent.startsWith("\"") || lDJSContent.startsWith("'")) {
            int quoteBegin = aDJSContent.indexOf(lDJSContent.charAt(0)) + 1;
            lResult[0] = aDJSContent.substring(0, quoteBegin);
            lResult[1] = aDJSContent.substring(quoteBegin).trim();
            String endChar = lResult[1].substring(lResult[1].length() - 1);
            if (endChar.charAt(0) == lDJSContent.charAt(0)) {
                lResult[2] = aDJSContent.substring(aDJSContent.lastIndexOf(endChar));
                lResult[1] = lResult[1].substring(0, lResult[1].length() - 1);
            }
        }
        return lResult;
    }
}

