/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.util.GWDebug;
import java.net.URLDecoder;

public class SSOUtil {
    public static SSOToken getSSOToken(String string) throws Exception {
        return SSOUtil.getSSOTokenNoDecode(URLDecoder.decode(string));
    }

    public static SSOToken getSSOTokenNoDecode(String string) throws Exception {
        SSOToken sSOToken = null;
        SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
        try {
            sSOToken = sSOTokenManager.createSSOToken(string);
            if (!sSOTokenManager.isValidToken(sSOToken)) {
                throw new SSOException("SSOToken creation suceeded , but it is not valid");
            }
        }
        catch (SSOException sSOException) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("SSOUtil: Unable to create SSOToken -> ", sSOException);
            }
            throw sSOException;
        }
        catch (Exception exception) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("SSOUtil: Unable to decode the SessionID -> ", exception);
            }
            throw exception;
        }
        return sSOToken;
    }
}

