/*
 * Decompiled with CFR 0.152.
 */
package migration_is60.modules.srap.netfile;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import migration_is60.modules.srap.netfile.DataHolder;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFRecord;

public class NetfileDynamicMigration {
    private static final char c_eol = '\n';
    private static final char DOT = '.';
    private String s_empty_string = "";
    private String S_DEFAULT_ENCODING = "ISO-8859-1";
    private ResourceBundle nfRes = null;
    private String inputFile;
    private String outputFile;

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Usage : <input ldiff file> , <output xml file>");
            System.exit(0);
        }
        NetfileDynamicMigration netfileDynamicMigration = new NetfileDynamicMigration(stringArray[0], stringArray[1]);
        netfileDynamicMigration.migrate();
        System.exit(0);
    }

    public NetfileDynamicMigration(String string, String string2) {
        this.inputFile = string;
        this.outputFile = string2;
        try {
            this.nfRes = ResourceBundle.getBundle("srapNetfileDynamicMigration");
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Unable to lead resource bundle : srapNetfileDynamicMigration");
            missingResourceException.printStackTrace();
            System.exit(0);
        }
    }

    void migrate() {
        int n = 0;
        try {
            LDIF lDIF = new LDIF(this.inputFile);
            FileWriter fileWriter = new FileWriter(this.outputFile);
            LDIFRecord lDIFRecord = lDIF.nextRecord();
            NetfileDynamicMigration.printHeader(fileWriter);
            while (lDIFRecord != null) {
                System.out.println("\n # Entry id:" + n);
                ++n;
                DataHolder dataHolder = this.ConvertRecord(lDIFRecord);
                try {
                    this.OutputRecord(fileWriter, dataHolder);
                }
                catch (Exception exception) {
                    System.out.println("Error writing to output file:" + this.outputFile);
                    exception.printStackTrace();
                }
                lDIFRecord = lDIF.nextRecord();
            }
            fileWriter.write("\n</Requests>");
            fileWriter.close();
            System.out.println("Processed " + n + " entries");
            System.out.println("Output available in file " + this.outputFile);
        }
        catch (IOException iOException) {
            System.out.println("Error:" + iOException.toString());
            iOException.printStackTrace();
        }
    }

    DataHolder ConvertRecord(LDIFRecord lDIFRecord) {
        ArrayList arrayList = new ArrayList();
        DataHolder dataHolder = new DataHolder(lDIFRecord.getDN());
        LDIFAttributeContent lDIFAttributeContent = (LDIFAttributeContent)lDIFRecord.getContent();
        LDAPAttribute[] lDAPAttributeArray = lDIFAttributeContent.getAttributes();
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet(lDAPAttributeArray);
        int n = 0;
        while (n < lDAPAttributeArray.length) {
            String string = lDAPAttributeArray[n].getName();
            String[] stringArray = lDAPAttributeSet.getAttribute(lDAPAttributeArray[n].getName()).getStringValueArray();
            int n2 = 0;
            while (n2 < stringArray.length) {
                List list = this.parseCommonHostsData(stringArray[n2]);
                arrayList.addAll(list);
                ++n2;
            }
            ++n;
        }
        dataHolder.setData(arrayList);
        return dataHolder;
    }

    static void printHeader(FileWriter fileWriter) throws IOException {
        Locale locale = Locale.getDefault();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("AMConfig");
        String string = new String();
        String string2 = "";
        if (resourceBundle.getObject("com.iplanet.am.rootsuffix") != null) {
            string2 = (String)resourceBundle.getObject("com.iplanet.am.rootsuffix");
        }
        if (resourceBundle.getObject("com.iplanet.am.installdir") != null) {
            string = (String)resourceBundle.getObject("com.iplanet.am.installdir");
            string = string.substring(0, string.indexOf("SUNWam"));
        }
        fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        fileWriter.write("\n<!--  PROPRIETARY/CONFIDENTIAL/ Use of this product is subject");
        fileWriter.write("\n to license terms. Copyright 2001 Sun Microsystems Inc.");
        fileWriter.write("Some preexisting portions Copyright 2001 Netscape");
        fileWriter.write("Communications Corp. All rights reserved. -->");
        fileWriter.write("\n<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN \" ");
        fileWriter.write("\"file:" + string + "SUNWam/dtd/amAdmin.dtd\">");
        fileWriter.write("\n<Requests>");
    }

    void writeData(FileWriter fileWriter, DataHolder dataHolder) throws IOException {
        Iterator iterator = dataHolder.data.iterator();
        while (iterator.hasNext()) {
            fileWriter.write("\n        <Value>");
            fileWriter.write(iterator.next().toString());
            fileWriter.write("\n        </Value>");
        }
    }

    void OutputRecord(FileWriter fileWriter, DataHolder dataHolder) throws IOException {
        if (dataHolder.isNull()) {
            return;
        }
        if (dataHolder.dataType == 2) {
            fileWriter.write("\n<OrganizationRequests DN=\"" + dataHolder.dn + "\">");
            fileWriter.write("\n    <ModifyServiceTemplate serviceName=\"srapNetFileService\" schemaType=\"Dynamic\">");
            fileWriter.write("\n       <AttributeValuePair>");
            fileWriter.write("\n           <Attribute name=\"sunPortalNetFileCommonHostData\"/>");
            fileWriter.write("\n        ");
            this.writeData(fileWriter, dataHolder);
            fileWriter.write("\n       </AttributeValuePair>");
            fileWriter.write("\n    </ModifyServiceTemplate>");
            fileWriter.write("\n</OrganizationRequests>");
        } else if (dataHolder.dataType == 1) {
            fileWriter.write("\n<RoleRequests DN=\"" + dataHolder.dn + "\">");
            fileWriter.write("\n    <ModifyServiceTemplate serviceName=\"srapNetFileService\" schemaType=\"1.0\">");
            fileWriter.write("\n       <AttributeValuePair>");
            fileWriter.write("\n           <Attribute name=\"sunPortalNetFileCommonHostData\"/>");
            this.writeData(fileWriter, dataHolder);
            fileWriter.write("\n       </AttributeValuePair>");
            fileWriter.write("\n    </ModifyServiceTemplate>");
            fileWriter.write("\n</RoleRequests>");
        } else {
            fileWriter.write("\n<PeopleContainerRequests DN=\"" + dataHolder.dn.substring(dataHolder.dn.indexOf(44) + 1) + "\">");
            fileWriter.write("\n    <ModifyUser modifyDN=\"" + dataHolder.dn + "\" >");
            fileWriter.write("\n       <AttributeValuePair>");
            fileWriter.write("\n           <Attribute name=\"sunPortalNetFileCommonHostData\"/>");
            this.writeData(fileWriter, dataHolder);
            fileWriter.write("\n       </AttributeValuePair>");
            fileWriter.write("\n    </ModifyUser>");
            fileWriter.write("\n</PeopleContainerRequests>");
        }
    }

    List parseCommonHostsData(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("machine_name=")) {
                if (stringBuffer != null) {
                    arrayList.add(stringBuffer.toString());
                }
                stringBuffer = new StringBuffer();
                stringBuffer.append(string2).append('\n');
                continue;
            }
            stringBuffer.append(string2).append('\n');
        }
        if (stringBuffer != null) {
            arrayList.add(stringBuffer.toString());
        }
        int n = 0;
        while (n < arrayList.size()) {
            try {
                String string3 = (String)arrayList.get(n);
                HashMap hashMap = this.parseHost(string3, "\n");
                hashMap = this.verifyHostData(hashMap);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Unable to parse common host data " + exception.getMessage());
                arrayList.remove(n);
            }
            ++n;
        }
        return arrayList;
    }

    HashMap parseHost(String string, String string2) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(stringTokenizer.countTokens() + 2);
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            hashMap.put("shares", arrayList);
            hashMap.put("share_passwords", arrayList2);
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.startsWith("machine_name=")) {
                    string3 = this.removePrefix("machine_name=", string4);
                    if (string3 == null || string3.equals("")) {
                        throw new Exception("illegal_machine_name");
                    }
                    hashMap.put("machine_name", string3);
                    continue;
                }
                if (string4.startsWith("machine_type=")) {
                    string3 = this.removePrefix("machine_type=", string4);
                    if (string3 == null || string3.equals("")) {
                        throw new Exception("illegal_machine_type");
                    }
                    hashMap.put("machine_type", string3);
                    continue;
                }
                if (string4.startsWith("machine_encoding=")) {
                    hashMap.put("machine_encoding", this.removePrefix("machine_encoding=", string4));
                    continue;
                }
                if (string4.startsWith("machine_domain=")) {
                    hashMap.put("machine_domain", this.removePrefix("machine_domain=", string4));
                    continue;
                }
                if (string4.startsWith("machine_password=")) {
                    hashMap.put("machine_password", this.removePrefix("machine_password=", string4));
                    continue;
                }
                if (string4.startsWith("machine_user_name=")) {
                    hashMap.put("machine_user_name", this.removePrefix("machine_user_name=", string4));
                    continue;
                }
                if (!string4.startsWith("share_name=")) continue;
                arrayList.add(this.removePrefix("share_name=", string4));
                String string5 = stringTokenizer.nextToken();
                arrayList2.add(this.removePrefix("share_password=", string5));
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to parse host data " + exception);
            throw new Exception("Illegal data format for common host ");
        }
        return hashMap;
    }

    String removePrefix(String string, String string2) throws Exception {
        if (!string2.startsWith(string)) {
            throw new Exception("illegal_machine_data_format");
        }
        string2 = string2.substring(string.length(), string2.length());
        return this.removeCtrlMChar(string2);
    }

    void removeCtrlMChar(String string, String string2, StringBuffer stringBuffer) {
        int n = string2.lastIndexOf(10);
        int n2 = string2.lastIndexOf(13);
        if (n < 0 && n2 < 0) {
            stringBuffer.append(string).append(string2).append('\n');
        } else if (n2 < 0 && n >= 0) {
            stringBuffer.append(string).append(string2.substring(0, n)).append('\n');
        } else {
            System.out.println("i is " + n + " j is " + n2 + " value is " + string2.substring(0, n2));
            stringBuffer.append(string).append(string2.substring(0, n2)).append('\n');
        }
    }

    String removeCtrlMChar(String string) {
        int n = string.lastIndexOf(10);
        int n2 = string.lastIndexOf(13);
        if (n < 0 && n2 < 0) {
            return string + '\n';
        }
        if (n2 < 0 && n >= 0) {
            return string.substring(0, n) + '\n';
        }
        return string.substring(0, n2) + '\n';
    }

    HashMap verifyHostData(HashMap hashMap) throws Exception {
        if (hashMap.get("machine_name") == null) {
            throw new Exception("illegal_machine_name");
        }
        hashMap = this.verifyCharacterEncoding(hashMap);
        this.verifyMachineType(hashMap);
        if (hashMap.get("machine_domain") == null) {
            hashMap.put("machine_domain", this.s_empty_string);
        }
        if (hashMap.get("machine_password") == null) {
            hashMap.put("machine_password", this.s_empty_string);
        }
        if (hashMap.get("machine_user_name") == null) {
            hashMap.put("machine_user_name", this.s_empty_string);
        }
        return hashMap;
    }

    void verifyMachineType(HashMap hashMap) throws Exception {
        Object v = hashMap.get("machine_type");
        if (v == null) {
            throw new Exception("illegal_machine_type");
        }
        String string = (String)v;
        if (!((string = string.trim()).equals("FTP") || string.equals("NETWARE") || string.equals("NFS") || string.equals("NT") || string.equals("WIN"))) {
            throw new Exception("illegal_machine_type");
        }
        System.out.println("Machine Type verified is " + (String)v);
    }

    HashMap verifyCharacterEncoding(HashMap hashMap) throws Exception {
        int n;
        Object v = hashMap.remove("machine_encoding");
        String string = this.s_empty_string;
        if (v != null) {
            string = (String)v;
            string = string.trim();
        }
        if ((n = string.indexOf(40)) == -1) {
            throw new Exception("Bad encoding : " + string);
        }
        int n2 = string.indexOf(41, n);
        if (n2 == -1) {
            throw new Exception("Bad encoding : " + string);
        }
        string = string.substring(n + 1, n2);
        String string2 = this.nfRes.getString("encoding_" + string);
        if (string2 == null || string2.trim().equals(this.s_empty_string) || string2.trim().equals("encoding_" + string)) {
            throw new Exception("Unknown encoding : " + string);
        }
        System.out.println("Machine encoding being placed is " + string2);
        return hashMap;
    }
}

