/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.CookieList;
import com.sun.portal.rproxy.connectionhandler.HTTPRequest;
import com.sun.portal.rproxy.connectionhandler.HTTPResponse;
import com.sun.portal.rproxy.connectionhandler.InternalCookie;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.SSOUtil;
import com.sun.portal.util.ServiceIdentifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class CookieManager {
    public static final boolean isCookieManager = GatewayProfile.getBoolean("EnableCookieManager", true);
    private static final String sessionCookieName = SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro");
    private static final String SRAP_SET_COOKIE_PROPERTY = "internalSRAPSetCookieProperty";
    private static boolean cookie_management = GatewayProfile.getBoolean("CookieManagement", false) && ServiceIdentifier.isGateway();

    private static String getReqSessionCookie(Request request) {
        String string = request.getRequestHeader("Cookie");
        if (string == null) {
            return null;
        }
        String string2 = string.substring(string.indexOf(58) + 1);
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens() && string3 == null) {
            String string4 = stringTokenizer.nextToken().trim();
            int n = string4.indexOf(61);
            if (n == -1 || !string4.substring(0, n).trim().equals(sessionCookieName)) continue;
            string3 = string4.substring(n + 1).trim();
        }
        return string3;
    }

    public static SSOToken getUserSession(Request request, HTTPResponse hTTPResponse) {
        SSOToken sSOToken;
        String string;
        block16: {
            string = null;
            sSOToken = null;
            string = request instanceof HTTPRequest ? ((HTTPRequest)request).getSessionID() : CookieManager.getReqSessionCookie(request);
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("getUserSession :: sessid : " + string);
            }
            if (string != null) {
                try {
                    sSOToken = SSOUtil.getSSOToken(string);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Cookie Manager -> token " + sSOToken);
                    }
                }
                catch (Exception exception) {
                    sSOToken = null;
                    if (!GWDebug.debug.messageEnabled()) break block16;
                    GWDebug.debug.message("Cookie Manager -> Exception ", exception);
                }
            }
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Cookie Manager -> token1 " + sSOToken);
        }
        if (sSOToken != null) {
            return sSOToken;
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Cookie Manager -> Trying Response ");
        }
        List list = hTTPResponse.getHeaderAttributeList("set-cookie");
        Iterator iterator = list.iterator();
        string = null;
        while (iterator.hasNext()) {
            String string2;
            String string3 = iterator.next().toString();
            int n = string3.indexOf(58);
            if (n == -1 || (n = (string3 = string3.substring(n + 1).trim()).indexOf(61)) == -1 || !(string2 = string3.substring(0, n).trim()).equals(sessionCookieName)) continue;
            int n2 = string3.indexOf(59, n);
            n2 = n2 == -1 ? string3.length() : n2;
            string = string3.substring(n + 1, n2).trim();
            break;
        }
        if (string != null) {
            try {
                sSOToken = SSOUtil.getSSOToken(string);
            }
            catch (Exception exception) {
                sSOToken = null;
            }
        }
        if (sSOToken == null) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Cookie Manager -> got SSOToken " + string);
            }
        } else if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Cookie Manager -> DID NOT GET SSOToken " + string);
        }
        return sSOToken;
    }

    public static void processSetCookieHeaders(Request request, HTTPResponse hTTPResponse) {
        List list = hTTPResponse.getHeaderAttributeList("set-cookie");
        Iterator iterator = list.iterator();
        boolean bl = false;
        boolean bl2 = false;
        SSOToken sSOToken = null;
        CookieList cookieList = null;
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            int n = string.indexOf(sessionCookieName);
            if (n != -1) {
                boolean bl3 = false;
                int n2 = string.indexOf("=", n);
                if (n2 != -1 && string.substring(n, n2).trim().equals(sessionCookieName)) {
                    bl3 = true;
                }
                if (bl3) {
                    if (bl) continue;
                    String string2 = null;
                    n = string.indexOf(";", n2 + 1);
                    if (n == -1) {
                        n = string.length();
                    }
                    string2 = string.substring(n2 + 1, n).trim();
                    request.setSessionValue(string2);
                    bl = true;
                    continue;
                }
            }
            if (!isCookieManager) continue;
            if (!bl2) {
                String string3;
                block23: {
                    sSOToken = CookieManager.getUserSession(request, hTTPResponse);
                    if (sSOToken == null) {
                        if (!GWDebug.debug.messageEnabled()) continue;
                        GWDebug.debug.message("Cookie Manager unable to set Cookies : No valid Session.");
                        continue;
                    }
                    bl2 = true;
                    string3 = null;
                    try {
                        string3 = sSOToken.getProperty(SRAP_SET_COOKIE_PROPERTY);
                    }
                    catch (Exception exception) {
                        if (!GWDebug.debug.messageEnabled()) break block23;
                        GWDebug.debug.message("Unable to get Cookie Manager properties", exception);
                    }
                }
                if (string3 != null) {
                    cookieList = new CookieList(string3);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Cookie Manager stored cookies : " + string3);
                    }
                } else {
                    cookieList = new CookieList();
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Cookie Manager properties -> no saved cookeis.");
                    }
                }
            }
            cookieList.processCookie(string, request.getHost());
        }
        if (cookieList != null && cookieList.isModified()) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Cookie Manager : Saving cookies");
            }
            try {
                sSOToken.setProperty(SRAP_SET_COOKIE_PROPERTY, cookieList.getEncodedValue());
            }
            catch (SSOException sSOException) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Unable to set Cookie Manager properties");
                }
            }
        } else if (cookieList != null) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Cookie Manager : No modifications");
            }
        } else if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Cookie Manager : cookieList == null !!");
        }
    }

    public static void processCookies(Request request) {
        CookieList cookieList;
        block20: {
            String string;
            SSOToken sSOToken;
            block19: {
                if (!ServiceIdentifier.isGateway()) {
                    return;
                }
                if (!isCookieManager) {
                    return;
                }
                String string2 = request.getSessionID();
                sSOToken = null;
                try {
                    sSOToken = SSOUtil.getSSOToken(string2);
                }
                catch (Exception exception) {
                    sSOToken = null;
                }
                if (sSOToken == null) {
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("No session !!");
                    }
                    return;
                }
                string = null;
                try {
                    string = sSOToken.getProperty(SRAP_SET_COOKIE_PROPERTY);
                }
                catch (SSOException sSOException) {
                    if (!GWDebug.debug.messageEnabled()) break block19;
                    GWDebug.debug.message("Unable to get Cookie Manager properties");
                }
            }
            if (string == null || string.trim().length() == 0) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("savedCookies ==  !!" + string);
                }
                return;
            }
            cookieList = new CookieList(string);
            if (cookieList.isModified()) {
                try {
                    sSOToken.setProperty(SRAP_SET_COOKIE_PROPERTY, cookieList.getEncodedValue());
                }
                catch (SSOException sSOException) {
                    if (!GWDebug.debug.messageEnabled()) break block20;
                    GWDebug.debug.message("Unable to set Cookie Manager properties");
                }
            }
        }
        Hashtable hashtable = CookieManager.getCookiesAsHashtable(request.getRequestHeader("Cookie"));
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("From Request : " + hashtable);
        }
        if (CookieManager.processRequestCookieList(hashtable, cookieList, request.getHost(), request.getObject())) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Cookie changed to " + hashtable);
            }
            Enumeration enumeration = hashtable.elements();
            StringBuffer stringBuffer = new StringBuffer().append("Cookie : ").append(enumeration.nextElement().toString());
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(" ; ").append(enumeration.nextElement().toString());
            }
            request.setRequestHeader("Cookie", stringBuffer.toString());
        } else if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("No cookie change " + hashtable);
        }
    }

    private static boolean processRequestCookieList(Hashtable hashtable, CookieList cookieList, String string, String string2) {
        boolean bl = false;
        if (cookieList == null || cookieList.length() == 0) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("processRequestCookieList :: cookieList : " + cookieList);
                if (cookieList != null) {
                    GWDebug.debug.message("processRequestCookieList :: cookieList length : " + cookieList.length());
                }
            }
            return bl;
        }
        if (cookie_management) {
            Enumeration enumeration = cookieList.enumerate();
            InternalCookie internalCookie = null;
            while (enumeration.hasMoreElements()) {
                internalCookie = (InternalCookie)enumeration.nextElement();
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Cookie from Session : : " + internalCookie);
                }
                hashtable.put(internalCookie.getName(), internalCookie.getNameValue());
            }
            return true;
        }
        if (string == null) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("processRequestCookieList :: host : " + string + " returning");
            }
            return bl;
        }
        string = string.trim().toLowerCase();
        if (string2 != null) {
            string2 = string2.trim();
        }
        Enumeration enumeration = cookieList.enumerate();
        InternalCookie internalCookie = null;
        while (enumeration.hasMoreElements()) {
            internalCookie = (InternalCookie)enumeration.nextElement();
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Cookie from Session : : " + internalCookie);
            }
            boolean bl2 = false;
            String string3 = internalCookie.getDomain();
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Cookie domain : " + string3);
                GWDebug.debug.message("Cookie domain : " + internalCookie.getPath());
            }
            if (string3 == null) {
                if (string.equalsIgnoreCase(internalCookie.getHost())) {
                    bl2 = true;
                }
            } else if (string.endsWith(string3 = string3.trim().toLowerCase())) {
                bl2 = true;
            }
            if (!bl2) continue;
            String string4 = internalCookie.getPath();
            if (string4 == null) {
                hashtable.put(internalCookie.getName(), internalCookie.getNameValue());
                bl = true;
                continue;
            }
            if (!string2.startsWith(string4.trim())) continue;
            hashtable.put(internalCookie.getName(), internalCookie.getNameValue());
            bl = true;
        }
        return bl;
    }

    private static Hashtable getCookiesAsHashtable(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string == null || string.trim().length() == 0) {
            return hashtable;
        }
        int n = string.indexOf(58);
        if (n == -1) {
            return hashtable;
        }
        string = string.substring(n + 1).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            n = string2.indexOf(61);
            if (n == -1) continue;
            hashtable.put(string2.substring(0, n).trim(), string2);
        }
        return hashtable;
    }
}

