/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.Password;
import com.sun.portal.cli.cert.SRADecoder;
import com.sun.portal.cli.cert.SRADecoderException;
import com.sun.portal.cli.cert.SRAPBEImpl;
import java.io.File;
import java.io.FileInputStream;
import java.security.cert.CertificateFactory;
import java.util.StringTokenizer;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.primitive.Name;

public class JSSUtil {
    private static SRADecoder defPassDecoder = null;

    public static void setDefaultDecoder(String string) throws SRADecoderException {
        if (defPassDecoder == null) {
            defPassDecoder = new SRAPBEImpl(string);
            defPassDecoder.init();
        }
    }

    public static SRADecoder getDefaultDecoder() {
        return defPassDecoder;
    }

    public static boolean certExist(JSSContext jSSContext, String string) {
        try {
            jSSContext.getCryptoManager().findCertByNickname(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static X509Certificate getCertByNickname(JSSContext jSSContext, String string) throws Exception {
        return jSSContext.getCryptoManager().findCertByNickname(string);
    }

    public static X509Certificate addCertificate(JSSContext jSSContext, File file, String string, boolean bl) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        java.security.cert.Certificate certificate = certificateFactory.generateCertificate(fileInputStream);
        byte[] byArray = certificate.getEncoded();
        if (bl) {
            return jSSContext.getCryptoManager().importCACertPackage(byArray);
        }
        return jSSContext.getCryptoManager().importCertPackage(byArray, string);
    }

    public static void verifyCertificate(Certificate certificate) {
        try {
            certificate.verify();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            CertAdminUtil.println(CertAdminLocale.getPFString("m49", "Could not verify the certificate!") + CertAdminConstants.newline + exception);
        }
    }

    public static X509Certificate changeCertificateTrust(X509Certificate x509Certificate, String string, String string2, String string3) throws Exception {
        int n = JSSUtil.getTrust(string);
        int n2 = JSSUtil.getTrust(string2);
        int n3 = JSSUtil.getTrust(string3);
        try {
            InternalCertificate internalCertificate = (InternalCertificate)x509Certificate;
            internalCertificate.setSSLTrust(n);
            internalCertificate.setEmailTrust(n2);
            internalCertificate.setObjectSigningTrust(n3);
            return internalCertificate;
        }
        catch (Exception exception) {
            return x509Certificate;
        }
    }

    public static String getTrust(X509Certificate x509Certificate) {
        try {
            InternalCertificate internalCertificate = (InternalCertificate)x509Certificate;
            return JSSUtil.getTrustStr(internalCertificate.getSSLTrust(), true) + "," + JSSUtil.getTrustStr(internalCertificate.getEmailTrust()) + "," + JSSUtil.getTrustStr(internalCertificate.getObjectSigningTrust());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static int getTrust(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        int n = 0;
        String string2 = "";
        int n2 = 0;
        while (n2 < cArray.length) {
            block11: {
                int n3;
                block5: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block4: {
                                            string2 = new Character(cArray[n2]).toString();
                                            if (!string2.equals("p")) break block4;
                                            n3 = 1;
                                            break block5;
                                        }
                                        if (!string2.equals("P")) break block6;
                                        n3 = 2;
                                        break block5;
                                    }
                                    if (!string2.equals("c")) break block7;
                                    n3 = 8;
                                    break block5;
                                }
                                if (!string2.equals("T")) break block8;
                                n3 = 136;
                                break block5;
                            }
                            if (!string2.equals("C")) break block9;
                            n3 = 24;
                            break block5;
                        }
                        if (!string2.equals("u")) break block10;
                        n3 = 64;
                        break block5;
                    }
                    if (!string2.equals("N")) break block11;
                    n3 = 0;
                }
                n = n2 == 0 ? n3 : (n |= n3);
            }
            ++n2;
        }
        return n;
    }

    public static String getTrustStr(int n) {
        return JSSUtil.getTrustStr(n, false);
    }

    public static String getTrustStr(int n, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = "";
        if ((0x10 & n) == 16) {
            string = string + "C";
            bl2 = true;
        }
        if ((0x80 & n) == 128) {
            string = string + "T";
            if (bl) {
                bl3 = true;
            }
        }
        if ((2 & n) == 2) {
            string = string + "P";
            bl4 = false;
        }
        if ((0x40 & n) == 64) {
            string = string + "u";
        }
        if ((8 & n) == 8 && !bl2 && !bl3) {
            string = string + "c";
        }
        if ((1 & n) == 1 && !bl4) {
            string = string + "p";
        }
        return string;
    }

    public static String[][] getNameDS(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        String[][] stringArray = new String[n][2];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
            if (stringTokenizer2.countTokens() == 2) {
                stringArray[n2][0] = stringTokenizer2.nextToken().trim();
                stringArray[n2][1] = stringTokenizer2.nextToken().trim();
            }
            ++n2;
        }
        return stringArray;
    }

    public static Name getIssuer(String string) throws Exception {
        String[][] stringArray = JSSUtil.getNameDS(string);
        Name name = new Name();
        int n = stringArray.length - 1;
        while (n >= 0) {
            String string2 = stringArray[n][0];
            String string3 = stringArray[n][1];
            if (string2.equals("C")) {
                name.addCountryName(string3);
            } else if (string2.equals("L")) {
                name.addLocalityName(string3);
            } else if (string2.equals("ST")) {
                name.addStateOrProvinceName(string3);
            } else if (string2.equals("O")) {
                name.addOrganizationName(string3);
            } else if (string2.equals("OU")) {
                name.addOrganizationalUnitName(string3);
            } else if (string2.equals("CN")) {
                name.addCommonName(string3);
            }
            --n;
        }
        return name;
    }

    public static String getCertWithSubject(CryptoToken cryptoToken, Name name) throws Exception {
        String string = name.getRFC1485();
        X509Certificate[] x509CertificateArray = cryptoToken.getCryptoStore().getCertificates();
        int n = 0;
        while (n < x509CertificateArray.length) {
            X509Certificate x509Certificate = x509CertificateArray[n];
            Certificate certificate = (Certificate)ASN1Util.decode((ASN1Template)Certificate.getTemplate(), (byte[])x509Certificate.getEncoded());
            CertificateInfo certificateInfo = certificate.getInfo();
            Name name2 = certificateInfo.getSubject();
            if (string.equalsIgnoreCase(name2.getRFC1485())) {
                return x509Certificate.getNickname();
            }
            ++n;
        }
        return null;
    }

    public static Password decryptPassword(String string) throws SRADecoderException {
        return JSSUtil.decryptPassword(JSSUtil.getDefaultDecoder(), string);
    }

    public static String encryptPassword(String string) throws SRADecoderException {
        return JSSUtil.encryptPassword(JSSUtil.getDefaultDecoder(), string);
    }

    public static boolean isPasswordEncrypted(String string) {
        return JSSUtil.isPasswordEncrypted(JSSUtil.getDefaultDecoder(), string);
    }

    public static Password decryptPassword(SRADecoder sRADecoder, String string) throws SRADecoderException {
        String string2;
        String string3;
        String string4;
        String string5;
        if (string == null) {
            return null;
        }
        Password password = new Password();
        password.setEncrypted(false);
        password.setPassword(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() == 2 && (string5 = stringTokenizer.nextToken()).equals(string4 = sRADecoder.digest(string3 = sRADecoder.decrypt(string2 = stringTokenizer.nextToken())))) {
            password.setEncrypted(true);
            password.setPassword(string3);
            return password;
        }
        return password;
    }

    public static String encryptPassword(SRADecoder sRADecoder, String string) throws SRADecoderException {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = sRADecoder.encrypt(string);
        String string3 = sRADecoder.digest(string);
        stringBuffer.append(string3);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static boolean isPasswordEncrypted(SRADecoder sRADecoder, String string) {
        if (string == null) {
            return false;
        }
        try {
            String string2;
            String string3;
            String string4;
            String string5;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            if (stringTokenizer.countTokens() == 2 && (string5 = stringTokenizer.nextToken()).equals(string4 = sRADecoder.digest(string3 = sRADecoder.decrypt(string2 = stringTokenizer.nextToken())))) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }
}

