/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter;

import com.sun.portal.rewriter.Rewriter;
import com.sun.portal.rewriter.RewriterModule;
import com.sun.portal.rewriter.engines.AbstractRewriter;
import com.sun.portal.rewriter.engines.RewriterBroker;
import com.sun.portal.rewriter.rom.InvalidXMLException;
import com.sun.portal.rewriter.rom.RuleSet;
import com.sun.portal.rewriter.rom.RuleSetManager;
import com.sun.portal.rewriter.services.DataServiceException;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.collections.TypedHashCache;
import com.sun.portal.rewriter.util.uri.PageSpec;
import java.util.Properties;

public final class RewriterPool {
    private static RewriterPool defaultPool;
    private final TypedHashCache rewriterBrokerCache = new TypedHashCache(class$com$sun$portal$rewriter$engines$RewriterBroker == null ? (class$com$sun$portal$rewriter$engines$RewriterBroker = RewriterPool.class$("com.sun.portal.rewriter.engines.RewriterBroker")) : class$com$sun$portal$rewriter$engines$RewriterBroker);
    public final RuleSetManager rulesetManager;
    static /* synthetic */ Class class$com$sun$portal$rewriter$engines$RewriterBroker;

    public RewriterPool(RuleSetManager aRuleSetManager) {
        this.rulesetManager = aRuleSetManager;
        this.rulesetManager.getDataService().getChangeNotifier().addObserver(this.rewriterBrokerCache);
        if (defaultPool == null) {
            defaultPool = this;
        }
    }

    public Rewriter getRewriter(String aRuleSetID, PageSpec aPageSpec) throws InvalidXMLException, DataServiceException {
        return this.getRewriter(aRuleSetID, aPageSpec.getMIME());
    }

    public Rewriter getRewriter(String aRuleSetID, String aMIME) throws InvalidXMLException, DataServiceException {
        RewriterBroker lRewriterBroker = (RewriterBroker)this.rewriterBrokerCache.get(aRuleSetID.toLowerCase());
        if (lRewriterBroker == null) {
            RuleSet lRuleSet = this.rulesetManager.fetchRuleSet(aRuleSetID);
            lRewriterBroker = new RewriterBroker(lRuleSet);
            this.rewriterBrokerCache.put(lRuleSet.getID(), lRewriterBroker);
        } else if (Debug.isMessageEnabled()) {
            Debug.message("Using the Cached Rewriter id : " + aRuleSetID);
        }
        return lRewriterBroker.getInstance(aMIME);
    }

    public static Rewriter create(String aXMLRuleSet, String aMIME) throws InvalidXMLException {
        RuleSet lRuleSet = RuleSetManager.create(aXMLRuleSet);
        return RewriterPool.create(lRuleSet, aMIME);
    }

    public static Rewriter create(RuleSet aRuleSet, String aMIME) {
        RewriterBroker aChain = new RewriterBroker(aRuleSet);
        return aChain.getInstance(StringHelper.normalize(aMIME));
    }

    public static final RewriterPool getDefault() {
        return defaultPool;
    }

    public static void main(String[] args) throws Exception {
        String lBaseDir = args[0];
        String lFileName = args[1];
        Properties props = new Properties();
        props.setProperty("DATA_SOURCE_TYPE", "FILE");
        props.setProperty("DATA_SERVICE_BASE", lBaseDir);
        RewriterModule.init(props, null, null);
        Rewriter r = RewriterPool.create(RuleSetManager.getDefault().retrieve(lFileName), "text/css");
        Debug.println(((AbstractRewriter)r).getRuleSet().toXML());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

