#!/usr/bin/perl

use File::Copy;
use File::Basename;
use File::Spec;
use File::Path;

$BUILD_NUMBER = "2004.189.0215";
$DS_PACKAGE = "directory-5.2_Patch_2-us.sparc-sun-solaris2.8.tar.gz";
$IS_WINDOWS = 0;
$USE_NATIVE_ZIP = 0;


sub change_dir {
  my $dir = shift;
  print "Change dir to $dir\n";
  return chdir $dir;
}

sub cmd {
  $c = shift;
  print "$c\n";
  system("$c");
  if( $? ) {
    print "Error: $!, exiting\n";
    exit 1;
  }
}

sub cmd_silent {
  $c = shift;
  system("$c");
  if( $? ) {
    print "Error: $!, exiting\n";
    exit 1;
  }
}

sub cmd_noerr {
  $c = shift;
  print "$c\n";
  system("$c");
  if( $? ) {
    return 1;
  }
  return 0;
}

sub cp {
  my $c1 = shift; my $c2 = shift;
  print "cp $c1 $c2\n";
  my $res = copy $c1, $c2;
  if( ! $res ) {
    print "Error, $!\n";
  }
  return $res;
}

sub mv {
  my $c1 = shift; my $c2 = shift;
#  print "mv $c1 $c2\n";
  my $res = move "$c1", "$c2";
  if( ! $res ) {
    print "Error, $!\n";
  }
  return $res;
}

sub unzip {
  my $pkg = shift;
  if( $USE_NATIVE_ZIP ) {
    cmd "unzip -q -o $pkg";
  }
  else {
    my $unzip_cmd = File::Spec->catdir("$CUR_DIR", "unzip");
    chmod 0755, "$unzip_cmd";
    cmd "$unzip_cmd -q -o $pkg";
  }
}

sub sav_tmp {
  my $SAV = shift;
  my $time_ext = shift;
    if( -f "$SAV" ) {
      print "saving $SAV\n";
      mv "$SAV", "$SAV-$time_ext.ref";
  }
}


sub rest_tmp {
  my $SAV = shift;
  my $time_ext = shift;
    if( -f "$SAV-$time_ext.ref" ) {
     print "restoring $SAV\n";
     unlink "$SAV";
     mv "$SAV-$time_ext.ref", "$SAV";
  }
}

$SERVER_ROOT = $ARGV[0];

$DIR64BITS = 0;

if($IS_WINDOWS) {
  $CUR_DIR = `chdir`; chomp $CUR_DIR;
}
else {
  $CUR_DIR = `pwd`; chomp $CUR_DIR;
  $PLATFORM = `uname`; chomp $PLATFORM;
  if( "$PLATFORM" eq "SunOS" ) {
    $BINDIR_64 = File::Spec->catfile("$SERVER_ROOT", "bin", "slapd", "server", "64");
    $LIBDIR_64 = File::Spec->catfile("$SERVER_ROOT", "lib","64");
    $NSSLAPD_64 = File::Spec->catfile("$BINDIR_64","ns-slapd");
    # check if we are in 32 or 64 bits
    if(-x $NSSLAPD_64) {
      $DIR64BITS = 1;
    }
  }
  elsif ("$PLATFORM" eq "HP-UX") {
    $BINDIR_64 = File::Spec->catfile("$SERVER_ROOT", "bin", "slapd", "server", "pa20_64");
    $LIBDIR_64 = File::Spec->catfile("$SERVER_ROOT", "lib","pa20_64");
    $NSSLAPD_64 = File::Spec->catfile("$BINDIR_64","ns-slapd");
    # check if we are in 32 or 64 bits
    if(-x $NSSLAPD_64) {
      $DIR64BITS = 1;
    }
  }
  else {
    $NSSLAPD_64 = "";
  }    
}

my @upgrade_time = localtime(time);
my $time_ext = sprintf("%d%02d%02d%02d%02d", 
		       $upgrade_time[5]+1900, $upgrade_time[4], $upgrade_time[3],
		       $upgrade_time[2], $upgrade_time[1]);

my $CREDS_FILE = File::Spec->catfile("$CUR_DIR", "creds");
if($IS_WINDOWS) {
  if ( "$ARGV[1]" eq "-f" ) {
    cp "$ARGV[2]" , "creds";
  }
  else {
    open(CREDS, ">creds") || die "Could not create : creds, $!";
    print CREDS "Admin Id: $ARGV[1]\n";
    print CREDS "Admin Password: $ARGV[2]\n";
    close CREDS;
  }
}

# Keep trace of presence of a slap- directory
# (which means there's at least one DS installed in 
# the server root.
my $DS_installed = 0;

# We need first to stop all instances of the server
opendir(SERVERDIR, "$SERVER_ROOT") || die "Could not open directory : $SERVER_ROOT, $!";
@instance_dirs = grep { /^slapd-/ } readdir SERVERDIR;
for (@instance_dirs) {
  my $stop_slapd_dir = File::Spec->catfile("$SERVER_ROOT", $_);
  if( -d $stop_slapd_dir) {
    $DS_installed = 1;
    change_dir $stop_slapd_dir || die "Could not change dir to $stop_slapd_dir";
    print "Stopping instance : $_\n";
    my $stop_slapd = File::Spec->catfile(File::Spec->curdir(), "stop-slapd");
    cmd_noerr "$stop_slapd";
  }
}

# And to stop the admin server
#my $stop_admin = File::Spec->catfile("$SERVER_ROOT", "stop-admin");
#print "Stopping the admin server...\n";
#$stop_admin = "\"" . $stop_admin . "\"" if $IS_WINDOWS;
change_dir $SERVER_ROOT;
$stop_admin = File::Spec->catfile(File::Spec->curdir(), "stop-admin");
cmd_noerr "$stop_admin";

change_dir $CUR_DIR;

if($DS_installed) {

  ($dspkg_file, $dspkg_path, $d_suf) = fileparse("$DS_PACKAGE", ".gz", ".zip");

  if( "$d_suf" eq ".gz" ) {
    # Might have already been gunzip'ed
    if( -f "$DS_PACKAGE" ) {
      cmd "gunzip $DS_PACKAGE";
    }
    cp "$dspkg_file", "$SERVER_ROOT";
    change_dir $SERVER_ROOT;

    open( TAR, "tar tf $dspkg_file |") || die "tar tf $dspkg_file : $!";
    while( <TAR> ) {
      chomp;
      if( -f "$_" ) {
	mv "$_", "$_-$time_ext.ref";
      }
    }
    close TAR;
    cmd "tar xf $dspkg_file";
    unlink File::Spec->catfile("$SERVER_ROOT", "$dspkg_file");
  }
  elsif ( "$d_suf" eq ".zip" ) {
    cp "$DS_PACKAGE", "$SERVER_ROOT";
    change_dir $SERVER_ROOT;
    unzip "$DS_PACKAGE";
    unlink File::Spec->catfile("$SERVER_ROOT", "$DS_PACKAGE");
  }
  else {
    print "Don't know how to handle this type of file : $DS_PACKAGE\n";
    exit 1;
  }
}

# Remove 64 bits if the install was initially 32 bits
if( (!$IS_WINDOWS) && (! $DIR64BITS) ) {
  if( -d $BINDIR_64 ) {
    print "Removing 64 bits support\n";
    rmtree $BINDIR_64;
    rmtree $LIBDIR_64;
  }
}

change_dir $CUR_DIR;

cp "nsbase.zip", "$SERVER_ROOT";
cp "nsclient.zip", "$SERVER_ROOT";
cp "nsjre.zip", "$SERVER_ROOT";
cp "nsadmin.zip", "$SERVER_ROOT";
cp "nsadminclient.zip", "$SERVER_ROOT";

if($IS_WINDOWS) {
  $SYSTEM_DIR = $ENV{SystemRoot};
  $nss_d = File::Spec->catfile("$SERVER_ROOT",bin,https,bin);

  $SYSTEM_DIR = File::Spec->catfile($SYSTEM_DIR, "SYSTEM32");
  cp "nsbasesys.zip", "$SYSTEM_DIR";
  if( -d $nss_d ) {
  cp "nsbasesys.zip", "$nss_d";
  }
}

change_dir $SERVER_ROOT;

my $shared = File::Spec->catfile("$SERVER_ROOT","shared");
my $config = File::Spec->catfile("$shared","config");
my $certmap = File::Spec->catfile("$config","certmap.conf");
sav_tmp "$certmap", "$time_ext";

my $userdb = File::Spec->catfile("$SERVER_ROOT","userdb");
my $ucertmap = File::Spec->catfile("$userdb","certmap.conf");
sav_tmp "$ucertmap","$time_ext";

unzip "nsbase.zip";
unzip "nsclient.zip";
unzip "nsjre.zip";
unzip "nsadmin.zip";
unzip "nsadminclient.zip";
unlink "nsbase.zip";
unlink "nsclient.zip";
unlink "nsjre.zip";
unlink "nsadmin.zip";
unlink "nsadminclient.zip";

rest_tmp "$certmap", "$time_ext";
rest_tmp "$ucertmap", "$time_ext";

if($IS_WINDOWS) {
  change_dir $SYSTEM_DIR;
  unzip "nsbasesys.zip";
  unlink "nsbasesys.zip";
# 5.2rtm has delivered nss on 2 places on windows, so we have to replace it in the 2 places
  if ( -d $nss_d ) {
    change_dir $nss_d;
    unzip "nsbasesys.zip";
    unlink "nsbasesys.zip";
  }
}

sleep(5);

# Now restart the servers
# Do this befor sync'ing since the
# CDS might be one of the(se) servers.
if($DS_installed) {
  for (@instance_dirs) {
    my $start_dir = File::Spec->catfile("$SERVER_ROOT","$_");
    if( -d $start_dir) {
      print "cd $start_dir\n";
      change_dir $start_dir;
      my $start_slapd = File::Spec->catfile(File::Spec->curdir(), "start-slapd");
      print "Starting instance : $_\n";
      cmd "$start_slapd";
    }
  }
  
  print "Please wait 20 seconds...\n";
  sleep(20);
}

my $new_dir = File::Spec->catdir("$SERVER_ROOT", "bin", "admin");
change_dir $new_dir;

my $sync_admin = File::Spec->catfile(File::Spec->curdir(), "sync-admin");
$sync_admin = $sync_admin . " upgrade -r \"$SERVER_ROOT\"";
print "Upgrading the Administration Server...\n";
my $res = cmd_noerr $sync_admin;
if( $res ) {
  print "Warning, sync-admin upgrade returned with error, the upgrade might have already been done ?\n";
}

my $sync_admin_cds = File::Spec->catfile(File::Spec->curdir(), "sync-admin-cds");
$sync_admin_cds = $sync_admin_cds . " -r \"$SERVER_ROOT\"";
# -v 5.2_Patch_2 -j ds522.jar -n \"Sun Java(TM) System Directory Server\" -b $BUILD_NUMBER";
if($IS_WINDOWS) {
  $sync_admin_cds .= " -f $CREDS_FILE";
}
print "Updating the Configuration Directory Server for the Admin Server...\n";
$res = cmd_noerr $sync_admin_cds;
if( $res ) {
  print "Warning, sync-admin-cds returned with error\n";
}

# Sync the DS.
# Need to do this only if there's at least one
# Directory server configured in SERVER ROOT.
if($DS_installed) {
  $new_dir = File::Spec->catdir("$SERVER_ROOT", "shared", "bin");
  change_dir $new_dir;
  my $sync_product_cds = File::Spec->catfile(File::Spec->curdir(), "sync-product-cds");
  my $isie_file = File::Spec->catfile("$SERVER_ROOT","admin-serv", "config", "adm.conf");
  open(ISIE, "$isie_file") || die "$isie_file: $!";
  my ($isie) = grep { /^isie:/i } <ISIE>;
  chop $isie;
  $isie =~ s/^[^,]+,(.+)/cn=Sun ONE Directory Server,$1/;

  $sync_product_cds = $sync_product_cds . 
    " -r \"$SERVER_ROOT\" -i \"$isie\" -j ds522.jar -v 5.2_Patch_2 -n \"Sun Java(TM) System Directory Server\" -b $BUILD_NUMBER";
  if($IS_WINDOWS) {
    $sync_product_cds .= " -f $CREDS_FILE";
  }
  print "Updating the Configuration Directory Server for the directory server instances\n";
  $res = cmd_noerr $sync_product_cds;
  if( $res ) {
    print "Warning, sync-product-cds returned with error\n";
  }
}

# And start the admin server
#my $start_admin = File::Spec->catfile("$SERVER_ROOT", "start-admin");
#$start_admin = "\"" . $start_admin . "\"" if $IS_WINDOWS;
#cmd $start_admin;

print "Starting the admin server...\n";
change_dir $SERVER_ROOT;
my $start_admin = File::Spec->catfile(File::Spec->curdir(), "start-admin");
cmd_noerr "$start_admin";

unlink "$CREDS_FILE";

print "\n\nDone\n\n";
