/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.diskpartition;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt8;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider.MethodProvider;
import com.sun.wbem.provider20.Authorizable;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.query.NonJoinExp;
import com.sun.wbem.query.QueryExp;
import com.sun.wbem.query.SelectExp;
import com.sun.wbem.query.SelectList;
import com.sun.wbem.query.WQLParser;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.diskdrive.DiskData;
import com.sun.wbem.solarisprovider.diskdrive.SliceData;
import com.sun.wbem.solarisprovider.diskdrive.SolarisDisksNative;
import com.sun.wbem.utility.common.CommonTools;
import com.sun.wbem.utility.common.ProcLauncher;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class Solaris_DiskPartition
implements InstanceProvider,
MethodProvider,
Authorizable {
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;
    private static String FMTHARD = new String("/usr/sbin/fmthard");
    private static String MKFS = new String("/usr/sbin/newfs");
    private static String DATA_SWITCH = new String("-d");
    private static String FILE_SWITCH = new String("-s");
    private static String DUMMY_SLICE = new String("s2");
    private static String NAME_SWITCH = new String("-n");
    private static String DATA_SEP = new String(":");
    private static String POUND = new String("#");
    private static String SPACE = new String(" ");
    private static String RAW_PATH = new String("/dev/rdsk/");
    private static String BLOCK_PATH = new String("/dev/dsk/");
    private static String MNT_TAB = new String("/etc/mnttab");
    public static final String DISK_WRITE_RIGHT = "solaris.admin.diskmgr.write";

    static {
        System.loadLibrary("solprov");
    }

    private String buildFmtFile(Vector vector) {
        try {
            String string = null;
            File file = new File("/tmp");
            File file2 = File.createTempFile("wbem", "fmt", file);
            if (file2.isFile() && file2.canWrite()) {
                string = file2.getAbsolutePath();
                FileWriter fileWriter = new FileWriter(string);
                int n = 0;
                while (vector != null && n < vector.size()) {
                    fileWriter.write(vector.elementAt(n).toString());
                    fileWriter.flush();
                    fileWriter.write(SPACE);
                    fileWriter.flush();
                    fileWriter.write(vector.elementAt(n + 1).toString());
                    fileWriter.flush();
                    fileWriter.write(SPACE);
                    fileWriter.flush();
                    fileWriter.write(this.convertFlag(vector.elementAt(n + 2).toString()));
                    fileWriter.flush();
                    fileWriter.write(SPACE);
                    fileWriter.flush();
                    fileWriter.write(vector.elementAt(n + 3).toString());
                    fileWriter.flush();
                    fileWriter.write(SPACE);
                    fileWriter.flush();
                    fileWriter.write(vector.elementAt(n + 4).toString());
                    fileWriter.flush();
                    fileWriter.write("\n");
                    fileWriter.flush();
                    n += 5;
                }
                fileWriter.close();
            }
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void cleanup() throws CIMException {
    }

    private CIMValue containsFileSystem(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = String.valueOf(BLOCK_PATH) + string;
        CIMValue cIMValue = CIMValue.FALSE;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(MNT_TAB));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() == 0 || !string2.startsWith(string4)) continue;
                cIMValue = CIMValue.TRUE;
                break;
            }
            bufferedReader.close();
            return cIMValue;
        }
        catch (Exception exception) {
            return cIMValue;
        }
    }

    private String convertFlag(String string) {
        String string2 = "0";
        if (string.startsWith("0x")) {
            return string;
        }
        try {
            int n = Integer.parseInt(string);
            string2 = "0x" + Integer.toHexString(n);
        }
        catch (Exception exception) {
            return string2;
        }
        return string2;
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        try {
            Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
            String string = "";
            Vector vector2 = SolarisDisksNative.getDisks();
            if (vector2 == null) {
                this.provUtil.writeLog(2, "LM_9902", "LM_9903", null, null, null, null);
            }
            int n = 0;
            while (vector2 != null && n < vector2.size()) {
                DiskData diskData = (DiskData)vector2.elementAt(n);
                string = diskData.getDiskName();
                Vector vector3 = diskData.getVSlices();
                if (vector3 != null) {
                    SliceData sliceData = (SliceData)vector3.elementAt(0);
                    String string2 = new String("");
                    int n2 = 0;
                    while (vector3 != null && n2 < vector3.size()) {
                        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                        sliceData = (SliceData)vector3.elementAt(n2);
                        string2 = String.valueOf(string) + "s" + String.valueOf(sliceData.getPartition());
                        cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)string2));
                        cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                        cIMObjectPath2.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                        cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_DiskPartition"));
                        vector.addElement(cIMObjectPath2);
                        ++n2;
                    }
                }
                ++n;
            }
            return vector;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_9904", "LM_9905", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        try {
            String string = "";
            Vector<CIMInstance> vector = new Vector<CIMInstance>();
            Vector vector2 = SolarisDisksNative.getDisks();
            if (vector2 == null) {
                this.provUtil.writeLog(2, "LM_9902", "LM_9903", null, null, null, null);
            }
            int n = 0;
            while (vector2 != null && n < vector2.size()) {
                DiskData diskData = (DiskData)vector2.elementAt(n);
                string = diskData.getDiskName();
                Vector vector3 = diskData.getVSlices();
                if (vector3 != null) {
                    SliceData sliceData = (SliceData)vector3.elementAt(0);
                    String string2 = new String("");
                    int n2 = 0;
                    while (vector3 != null && n2 < vector3.size()) {
                        CIMInstance cIMInstance = cIMClass.newInstance();
                        sliceData = (SliceData)vector3.elementAt(n2);
                        string2 = String.valueOf(string) + "s" + String.valueOf(sliceData.getPartition());
                        cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                        cIMInstance.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                        cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_DiskPartition"));
                        cIMInstance.setProperty("DeviceID", new CIMValue((Object)string2));
                        cIMInstance.setProperty("StartCylinder", new CIMValue((Object)new UnsignedInt32((long)sliceData.getStartCylinder())));
                        cIMInstance.setProperty("EndCylinder", new CIMValue((Object)new UnsignedInt32((long)sliceData.getEndCylinder())));
                        cIMInstance.setProperty("TotalCylinders", new CIMValue((Object)new UnsignedInt32((long)sliceData.getTotalCylinder())));
                        cIMInstance.setProperty("Blocks", new CIMValue((Object)new UnsignedInt32((long)sliceData.getNumSectors())));
                        cIMInstance.setProperty("Tag", new CIMValue((Object)new UnsignedInt8(sliceData.getTag())));
                        cIMInstance.setProperty("Flag", new CIMValue((Object)new UnsignedInt8(sliceData.getFlag())));
                        cIMInstance.setProperty("DiskID", new CIMValue((Object)string));
                        cIMInstance.setProperty("ValidFileSystem", this.containsFileSystem(string2));
                        vector.addElement(cIMInstance);
                        ++n2;
                    }
                }
                ++n;
            }
            return vector;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_9904", "LM_9905", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        WQLParser wQLParser = new WQLParser((InputStream)byteArrayInputStream);
        Vector<CIMElement> vector = new Vector<CIMElement>();
        try {
            SelectExp selectExp = (SelectExp)wQLParser.querySpecification();
            SelectList selectList = selectExp.getSelectList();
            NonJoinExp nonJoinExp = (NonJoinExp)selectExp.getFromClause();
            QueryExp queryExp = selectExp.getWhereClause();
            Vector vector2 = new Vector();
            vector2 = this.enumInstances(cIMObjectPath, false, cIMClass, true);
            int n2 = 0;
            while (n2 < vector2.size()) {
                if (queryExp == null || queryExp.apply((CIMElement)((CIMInstance)vector2.elementAt(n2)))) {
                    vector.addElement(selectList.apply((CIMElement)((CIMInstance)vector2.elementAt(n2))));
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        return vector;
    }

    private CIMValue formatHard(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        this.provUtil.checkRights(DISK_WRITE_RIGHT, cIMObjectPath);
        String string = null;
        try {
            String string2 = new String();
            String string3 = null;
            string = this.getKeyValue(cIMObjectPath, "deviceid");
            if (string.equalsIgnoreCase("")) {
                this.provUtil.writeLog(2, "LM_9910", "LM_9911", null, null, null, null);
                return CIMValue.FALSE;
            }
            int n = -1;
            n = string.indexOf(115);
            if (n == -1) {
                this.provUtil.writeLog(2, "LM_9910", "LM_9911", null, null, null, null);
                return CIMValue.FALSE;
            }
            string3 = string.substring(0, n);
            string3 = string3.concat(DUMMY_SLICE);
            string2 = string2.concat(FMTHARD);
            string2 = string2.concat(SPACE);
            string2 = string2.concat(FILE_SWITCH);
            string2 = string2.concat(SPACE);
            String string4 = this.buildFmtFile(vector);
            if (string4 == null) {
                return CIMValue.FALSE;
            }
            string2 = string2.concat(string4);
            string2 = string2.concat(SPACE);
            string2 = string2.concat(RAW_PATH);
            string2 = string2.concat(string3);
            Vector vector2 = CommonTools.CMN_exec((String)string2, (boolean)true);
            String[] stringArray = (String[])vector2.elementAt(1);
            if (stringArray.length != 0) {
                this.provUtil.writeLog(2, "LM_9912", "LM_9913", string.substring(0, n), "2", null, null);
                return CIMValue.FALSE;
            }
            this.provUtil.writeLog(0, "LM_9914", "LM_9915", string.substring(0, n), "2", null, null);
            return CIMValue.TRUE;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_9916", "LM_9917", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            return CIMValue.TRUE;
        }
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        try {
            Vector vector;
            String string = "";
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                vector = (CIMProperty)enumeration.nextElement();
                if (!vector.getName().equalsIgnoreCase("deviceid")) continue;
                string = (String)vector.getValue().getValue();
            }
            vector = SolarisDisksNative.getDisks();
            DiskData diskData = (DiskData)vector.elementAt(0);
            if (diskData == null) {
                this.provUtil.writeLog(2, "LM_9902", "LM_9903", null, null, null, null);
            }
            String string2 = "";
            int n = 0;
            while (vector != null && n < vector.size()) {
                diskData = (DiskData)vector.elementAt(n);
                string2 = diskData.getDiskName();
                if (string.startsWith(string2)) break;
                ++n;
            }
            Vector vector2 = diskData.getVSlices();
            SliceData sliceData = (SliceData)vector2.elementAt(0);
            String string3 = new String("");
            int n2 = 0;
            while (vector2 != null && n2 < vector2.size()) {
                sliceData = (SliceData)vector2.elementAt(n2);
                string3 = String.valueOf(string2) + "s" + String.valueOf(sliceData.getPartition());
                if (string.equalsIgnoreCase(string3)) break;
                ++n2;
            }
            CIMInstance cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMInstance.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_DiskPartition"));
            cIMInstance.setProperty("DeviceID", new CIMValue((Object)string3));
            cIMInstance.setProperty("Blocks", new CIMValue((Object)new UnsignedInt32((long)sliceData.getNumSectors())));
            cIMInstance.setProperty("StartCylinder", new CIMValue((Object)new UnsignedInt32((long)sliceData.getStartCylinder())));
            cIMInstance.setProperty("EndCylinder", new CIMValue((Object)new UnsignedInt32((long)sliceData.getEndCylinder())));
            cIMInstance.setProperty("TotalCylinders", new CIMValue((Object)new UnsignedInt32((long)sliceData.getTotalCylinder())));
            cIMInstance.setProperty("Tag", new CIMValue((Object)new UnsignedInt8(sliceData.getTag())));
            cIMInstance.setProperty("Flag", new CIMValue((Object)new UnsignedInt8(sliceData.getFlag())));
            cIMInstance.setProperty("DiskID", new CIMValue((Object)string2));
            cIMInstance.setProperty("ValidFileSystem", this.containsFileSystem(string3));
            return cIMInstance;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_9900", "LM_9901", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            return null;
        }
    }

    private String getKeyValue(CIMObjectPath cIMObjectPath, String string) {
        String string2 = "";
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase(string)) continue;
            string2 = (String)cIMProperty.getValue().getValue();
        }
        return string2;
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.provUtil = new ProviderUtility(cIMOMHandle, "Disk Manager");
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        try {
            if (string.equalsIgnoreCase("CreatePartitions")) {
                return this.formatHard(vector, cIMObjectPath);
            }
            if (string.equalsIgnoreCase("CreateFileSystem")) {
                return this.makeFS(cIMObjectPath);
            }
            this.provUtil.writeLog(1, "LM_9906", "LM_9907", string, null, null, null);
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_9908", "LM_9909", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            return null;
        }
        return null;
    }

    private CIMValue makeFS(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = "";
        String string2 = MKFS;
        this.provUtil.checkRights(DISK_WRITE_RIGHT, cIMObjectPath);
        try {
            Object object;
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                object = (CIMProperty)enumeration.nextElement();
                if (!object.getName().equalsIgnoreCase("deviceid")) continue;
                string = (String)object.getValue().getValue();
            }
            if (string.equalsIgnoreCase("")) {
                this.provUtil.writeLog(2, "LM_9918", "LM_9919", null, null, null, null);
                return CIMValue.FALSE;
            }
            string.trim();
            string2 = string2.concat(" " + RAW_PATH + string);
            object = new StringTokenizer(string2, " ");
            ((StringTokenizer)object).nextToken();
            int n = ((StringTokenizer)object).countTokens();
            String[] stringArray = new String[n + 1];
            String[] stringArray2 = new String[1];
            stringArray[0] = MKFS;
            try {
                int n2 = 1;
                while (n2 <= n) {
                    stringArray[n2] = ((StringTokenizer)object).nextToken();
                    ++n2;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                return CIMValue.FALSE;
            }
            ProcLauncher procLauncher = new ProcLauncher(MKFS, "root", stringArray, stringArray2, false);
            int n3 = procLauncher.getStatus();
            if (n3 != 0) {
                this.provUtil.writeLog(2, "LM_9924", "LM_9925", null, null, null, null);
                return CIMValue.FALSE;
            }
            this.provUtil.writeLog(0, "LM_9922", "LM_9923", string, null, null, null);
            return CIMValue.TRUE;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_9924", "LM_9925", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            return CIMValue.TRUE;
        }
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            Vector vector = new Vector();
            CIMValue cIMValue = cIMInstance.getProperty("deviceID").getValue();
            String string = (String)cIMValue.getValue();
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            if (string.equalsIgnoreCase("")) {
                this.provUtil.writeLog(2, "LM_9910", "LM_9911", null, null, null, null);
                return;
            }
            string.trim();
            n = Integer.parseInt(string.substring(string.length() - 1));
            if (n < 0) {
                this.provUtil.writeLog(2, "LM_9910", "LM_9911", null, null, null, null);
                return;
            }
            CIMValue cIMValue2 = cIMInstance.getProperty("tag").getValue();
            n2 = ((UnsignedInt8)cIMValue2.getValue()).intValue();
            cIMValue2 = cIMInstance.getProperty("flag").getValue();
            n3 = ((UnsignedInt8)cIMValue2.getValue()).intValue();
            cIMValue2 = cIMInstance.getProperty("startcylinder").getValue();
            n4 = ((UnsignedInt32)cIMValue2.getValue()).intValue();
            cIMValue2 = cIMInstance.getProperty("blocks").getValue();
            n5 = ((UnsignedInt32)cIMValue2.getValue()).intValue();
            Vector vector2 = SolarisDisksNative.getDisks();
            DiskData diskData = (DiskData)vector2.elementAt(0);
            if (diskData == null) {
                this.provUtil.writeLog(2, "LM_9902", "LM_9903", null, null, null, null);
            }
            String string2 = "";
            int n6 = 0;
            while (vector2 != null && n6 < vector2.size()) {
                diskData = (DiskData)vector2.elementAt(n6);
                string2 = diskData.getDiskName();
                if (string.startsWith(string2)) break;
                ++n6;
            }
            n4 = diskData.cylinderToSector(n4);
            String string3 = new String(String.valueOf(n) + DATA_SEP + n2 + DATA_SEP + this.convertFlag(Integer.toString(n3)) + DATA_SEP + n4 + DATA_SEP + n5 + DATA_SEP);
            String string4 = new String();
            string4 = string4.concat(FMTHARD);
            string4 = string4.concat(SPACE);
            string4 = string4.concat(DATA_SWITCH);
            string4 = string4.concat(SPACE);
            string4 = string4.concat(string3);
            string4 = string4.concat(SPACE);
            string4 = string4.concat(RAW_PATH);
            string4 = string4.concat(string);
            Vector vector3 = CommonTools.CMN_exec((String)string4, (boolean)true);
            String[] stringArray = (String[])vector3.elementAt(1);
            if (stringArray.length != 0) {
                this.provUtil.writeLog(2, "LM_9912", "LM_9913", string2, Integer.toString(n), null, null);
                return;
            }
            this.provUtil.writeLog(0, "LM_9914", "LM_9915", string2, Integer.toString(n), null, null);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

