/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.common;

import com.sun.audit.AuditEvent;
import com.sun.audit.AuditEvent_uauth;
import com.sun.audit.AuditSession;
import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.cim.CIMSecurityException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.client.ProviderCIMOMHandle;
import com.sun.wbem.client.audit.WbemAuditSession;
import com.sun.wbem.utility.authorization.AuthorizationUtility;
import com.sun.wbem.utility.directorytable.DirectoryTableSetup;
import com.sun.wbem.utility.log.LogUtil;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;

public class ProviderUtility {
    public static final String MGMT_DOMAIN_KEY = "SystemName";
    public static final String MGMT_TYPE_KEY = "SystemCreationClassName";
    public static final String FILE_SCOPE_TYPE = "file";
    public static final String NIS_SCOPE_TYPE = "nis";
    public static final String NISPLUS_SCOPE_TYPE = "nisplus";
    public static final String LDAP_SCOPE_TYPE = "ldap";
    public static final String DNS_SCOPE_TYPE = "dns";
    public static final String DFLT_SCOPE_TYPE = "file";
    public static final String FILES_SCOPE = "files";
    private static final String GUEST = "guest";
    private static final String[] MGMT_CLASS_TABLE = new String[]{"Solaris_SystemAdminDomain", "Solaris_NisAdminDomain", "Solaris_NisplusAdminDomain", "Solaris_LdapAdminDomain", "Solaris_DnsAdminDomain"};
    private static final String[] MGMT_TYPE_TABLE = new String[]{"file", "nis", "nisplus", "ldap", "dns"};
    private ProviderCIMOMHandle cimomhandle = null;
    private String providerName = null;
    private LogUtil logUtil = null;
    private String hostname = null;
    private Vector mgmtScopes = null;
    private DirectoryTableSetup dirtbl = null;
    private String GMT_TIMEZONE = "GMT";

    public ProviderUtility(CIMOMHandle cIMOMHandle, String string) throws CIMException {
        this.cimomhandle = (ProviderCIMOMHandle)cIMOMHandle;
        this.providerName = string;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)this.cimomhandle);
    }

    public String checkAuthenticated() throws CIMException {
        String string = this.getClientUserName();
        if (string == null) {
            this.logUtil.writeLog(this.providerName, "LM_1001", "LM_1010", null, "", false, 1, 2);
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
        if (string.equals(GUEST)) {
            this.logUtil.writeLog(this.providerName, "LM_1001", "LM_1011", null, "", false, 1, 1);
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
        return string;
    }

    public void checkRights(String string, CIMObjectPath cIMObjectPath) throws CIMException {
        String string2 = this.checkAuthenticated();
        if (!AuthorizationUtility.checkAuthName((String)string2, (String)string)) {
            String[] stringArray = new String[]{string2};
            this.logUtil.writeLog(this.providerName, "LM_1001", "LM_1012", stringArray, "", false, 1, 1);
            this.unAuthorizedAudit(cIMObjectPath, string);
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
    }

    private String convertDateToString(Date date) {
        String string = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMyyyy");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.GMT_TIMEZONE));
        simpleDateFormat.setLenient(false);
        try {
            string = simpleDateFormat.format(date);
        }
        catch (Exception exception) {}
        return string;
    }

    public UnsignedInt32 convertIntToCIMUnsignedInt(int n) {
        try {
            return new UnsignedInt32(Integer.toString(n));
        }
        catch (Exception exception) {
            return new UnsignedInt32("0");
        }
    }

    public UnsignedInt16 convertShortToCIMUnsignedInt16(short s) {
        try {
            return new UnsignedInt16(Short.toString(s));
        }
        catch (Exception exception) {
            return new UnsignedInt16("0");
        }
    }

    public String decryptPassword(String string) {
        return this.cimomhandle.decryptData(string);
    }

    public String formatAuditToken(CIMInstance cIMInstance) {
        String string = "";
        Vector vector = cIMInstance.getProperties();
        Enumeration enumeration = vector.elements();
        block8: while (enumeration.hasMoreElements()) {
            CIMValue cIMValue;
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (cIMProperty == null || (cIMValue = cIMProperty.getValue()) == null) continue;
            int n = CIMDataType.findType((Object)cIMValue.getValue());
            if (cIMProperty.getName().equals("loginPassword")) continue;
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 13: {
                    Object object = cIMValue.getValue();
                    if (object == null || object.equals("")) continue block8;
                    string = string.concat(cIMProperty.getName());
                    string = string.concat("=");
                    string = string.concat(object.toString());
                    string = string.concat(";");
                    break;
                }
                case 9: {
                    boolean bl = (Boolean)cIMValue.getValue();
                    String string2 = "0";
                    string2 = !bl ? "0" : "1";
                    string = string.concat(cIMProperty.getName());
                    string = string.concat("=");
                    string = string.concat(string2);
                    string = string.concat(";");
                    break;
                }
                case 12: {
                    CIMDateTime cIMDateTime = (CIMDateTime)cIMValue.getValue();
                    if (cIMDateTime == null) break;
                    Cloneable cloneable = cIMDateTime.getCalendar();
                    Object object = ((Calendar)cloneable).getTime();
                    Object object2 = this.convertDateToString((Date)object);
                    string = string.concat(cIMProperty.getName());
                    string = string.concat("=");
                    string = string.concat((String)object2);
                    string = string.concat(";");
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 24: 
                case 25: 
                case 27: {
                    String string3;
                    Cloneable cloneable = (Vector)cIMValue.getValue();
                    Object object = "";
                    int n2 = 0;
                    while (n2 < ((Vector)cloneable).size()) {
                        string3 = ((Vector)cloneable).elementAt(n2);
                        if (string3 != null && !string3.equals("")) {
                            object = ((String)object).concat(string3.toString());
                            object = ((String)object).concat(",");
                        }
                        ++n2;
                    }
                    if (((String)object).equals("")) break;
                    string = string.concat(cIMProperty.getName());
                    string = string.concat("=");
                    n2 = ((String)object).length();
                    string = string.concat(((String)object).substring(0, n2 - 1));
                    string = string.concat(";");
                    break;
                }
                case 23: {
                    Object object2 = (Vector)cIMValue.getValue();
                    String string3 = "";
                    int n3 = 0;
                    while (n3 < ((Vector)object2).size()) {
                        boolean bl = (Boolean)((Vector)object2).elementAt(n3);
                        String string4 = "0";
                        string4 = !bl ? "0" : "1";
                        string3 = string3.concat(string4);
                        string3 = string3.concat(",");
                        ++n3;
                    }
                    if (string3.equals("")) break;
                    string = string.concat(cIMProperty.getName());
                    string = string.concat("=");
                    n3 = string3.length();
                    string = string.concat(string3.substring(0, n3 - 1));
                    string = string.concat(";");
                    break;
                }
                case 26: {
                    Vector vector2 = (Vector)cIMValue.getValue();
                    String string5 = "";
                    int n4 = 0;
                    while (n4 < vector2.size()) {
                        CIMDateTime cIMDateTime = (CIMDateTime)vector2.elementAt(n4);
                        if (cIMDateTime != null) {
                            Calendar calendar = cIMDateTime.getCalendar();
                            Date date = calendar.getTime();
                            String string6 = this.convertDateToString(date);
                            string5 = string5.concat(string6);
                            string5 = string5.concat(",");
                        }
                        ++n4;
                    }
                    if (string5.equals("")) break;
                    string = string.concat(cIMProperty.getName());
                    string = string.concat("=");
                    n4 = string5.length();
                    string = string.concat(string5.substring(0, n4 - 1));
                    string = string.concat(";");
                    break;
                }
            }
        }
        return string;
    }

    public WbemAuditSession getAuditSession() {
        return this.cimomhandle.getCurrentAuditSession();
    }

    public ProviderCIMOMHandle getCimomHandle() {
        return this.cimomhandle;
    }

    public String getClientSensitivityLabel() {
        String string = this.cimomhandle.getCurrentSensitivityLabel();
        return string;
    }

    public String getClientUserName() {
        String string = this.cimomhandle.getCurrentRole();
        if (string == null || string.trim().length() == 0) {
            string = this.cimomhandle.getCurrentUser();
        }
        return string;
    }

    public String getDefaultScope() {
        String string = this.getServerHostName();
        String string2 = "file:/" + string + "/" + string;
        return string2;
    }

    public String getMgmtScope(CIMInstance cIMInstance) throws CIMException {
        String string = null;
        String string2 = null;
        if (cIMInstance != null) {
            CIMValue cIMValue;
            CIMProperty cIMProperty = cIMInstance.getProperty(MGMT_DOMAIN_KEY);
            if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                string = (String)cIMValue.getValue();
            }
            if ((cIMProperty = cIMInstance.getProperty(MGMT_TYPE_KEY)) != null && (cIMValue = cIMProperty.getValue()) != null) {
                string2 = (String)cIMValue.getValue();
            }
        }
        return this.getMgmtScope(string2, string);
    }

    public String getMgmtScope(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = null;
        String string2 = null;
        Vector vector = null;
        if (cIMObjectPath != null) {
            vector = cIMObjectPath.getKeys();
        }
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                CIMValue cIMValue;
                CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n);
                if (cIMProperty.getName().equalsIgnoreCase(MGMT_DOMAIN_KEY) && (cIMValue = cIMProperty.getValue()) != null) {
                    string = (String)cIMValue.getValue();
                }
                if (cIMProperty.getName().equalsIgnoreCase(MGMT_TYPE_KEY) && (cIMValue = cIMProperty.getValue()) != null) {
                    string2 = (String)cIMValue.getValue();
                }
                ++n;
            }
        }
        return this.getMgmtScope(string2, string);
    }

    public String getMgmtScope(String string, String string2) throws CIMException {
        int n;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        boolean bl = false;
        if (string == null && string2 == null) {
            return this.getDefaultScope();
        }
        string3 = this.getScopeTypeFromClass(string);
        if (string3 == null) {
            string7 = this.writeLog(2, "LM_2410", "LM_2414", string, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string7);
        }
        if (string3.equals("file")) {
            bl = true;
        }
        string5 = this.getServerHostName();
        if (string2 == null || string2.trim().length() == 0) {
            if (bl) {
                return this.getDefaultScope();
            }
            string7 = this.writeLog(2, "LM_2410", "LM_2413", string3, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string7);
        }
        string4 = string2;
        if (bl && (n = string2.indexOf(46)) > 0) {
            string4 = string2.substring(0, n);
        }
        string6 = String.valueOf(string3) + ":/" + string5 + "/" + string4;
        if (this.dirtbl == null) {
            this.dirtbl = new DirectoryTableSetup();
        }
        if (!this.dirtbl.isValidScope(string6)) {
            string7 = this.writeLog(2, "LM_2410", "LM_2411", string6, string5, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string7);
        }
        return string6;
    }

    public String getScopeClassFromType(String string) {
        String string2 = "";
        int n = 0;
        while (n < MGMT_TYPE_TABLE.length) {
            if (string.equals(MGMT_TYPE_TABLE[n])) {
                string2 = MGMT_CLASS_TABLE[n];
                break;
            }
            ++n;
        }
        return string2;
    }

    public String getScopeClassType(String string) {
        int n;
        String string2;
        if (string == null || string.trim().length() == 0) {
            string2 = "file";
        }
        string2 = (n = string.indexOf(58)) < 1 ? "file" : string.substring(0, n);
        return this.getScopeClassFromType(string2);
    }

    public String getScopeDomainName(String string) {
        int n;
        if (string != null && string.trim().length() > 0 && (n = string.lastIndexOf(47)) > 0 && n < string.length()) {
            return string.substring(n + 1);
        }
        if (string.startsWith("file")) {
            return this.getServerHostName();
        }
        return "";
    }

    private Vector getScopeList() {
        Vector vector = null;
        try {
            DirectoryTableSetup directoryTableSetup = new DirectoryTableSetup();
            vector = directoryTableSetup.getScopes(2);
        }
        catch (Exception exception) {
            vector = new Vector(0);
        }
        return vector;
    }

    public String getScopeType(String string) {
        int n;
        if (string != null && string.trim().length() > 0 && (n = string.indexOf(58)) > 0) {
            return string.substring(0, n);
        }
        return "";
    }

    public String getScopeTypeFromClass(String string) {
        String string2 = null;
        if (string != null) {
            int n = 0;
            while (n < MGMT_CLASS_TABLE.length) {
                if (string.equals(MGMT_CLASS_TABLE[n])) {
                    string2 = MGMT_TYPE_TABLE[n];
                    break;
                }
                ++n;
            }
        }
        return string2;
    }

    public String getServerHostName() {
        if (this.hostname == null) {
            try {
                this.hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                this.hostname = "??";
            }
            int n = this.hostname.indexOf(46);
            if (n > 0) {
                this.hostname = this.hostname.substring(0, n);
            }
        }
        return this.hostname;
    }

    public boolean isClientRole() {
        boolean bl = false;
        String string = this.cimomhandle.getCurrentRole();
        if (string != null && string.trim().length() > 0) {
            bl = true;
        }
        return bl;
    }

    public void setDomainScopeTokens(ProviderUtility providerUtility, String string, AuditEvent auditEvent) {
        String string2 = null;
        string2 = providerUtility.getScopeType(string);
        if (!string2.equalsIgnoreCase("file")) {
            auditEvent.domain(providerUtility.getScopeDomainName(string));
        } else {
            string2 = FILES_SCOPE;
        }
        auditEvent.name_service(string2);
    }

    public boolean testRights(String string, CIMObjectPath cIMObjectPath) {
        boolean bl = false;
        String string2 = this.getClientUserName();
        if (string2 != null && !string2.equals(GUEST)) {
            return AuthorizationUtility.checkAuthName((String)string2, (String)string);
        }
        return false;
    }

    public void unAuthorizedAudit(CIMObjectPath cIMObjectPath, String string) {
        WbemAuditSession wbemAuditSession = null;
        wbemAuditSession = this.getAuditSession();
        if (wbemAuditSession == null) {
            return;
        }
        AuditSession auditSession = null;
        try {
            auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
        }
        catch (Exception exception) {
            auditSession = null;
        }
        if (auditSession != null) {
            AuditEvent_uauth auditEvent_uauth = new AuditEvent_uauth(auditSession);
            if (cIMObjectPath != null) {
                auditEvent_uauth.objectname(cIMObjectPath.getObjectName());
            } else {
                auditEvent_uauth.objectname(null);
            }
            auditEvent_uauth.auth_used(string);
            auditEvent_uauth.putEvent(-1, 0);
        }
    }

    public String writeLog(int n, Exception exception) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        if (n == 2) {
            bl = true;
        }
        try {
            string2 = exception.getLocalizedMessage();
            String[] stringArray = new String[]{string2};
            string = this.logUtil.writeLog(this.providerName, "LM_2001", "LM_2100", stringArray, null, bl, 0, n);
        }
        catch (Exception exception2) {}
        if (string == null) {
            string = string2;
        }
        return string;
    }

    public String writeLog(int n, String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = null;
        boolean bl = false;
        if (n == 2) {
            bl = true;
        }
        try {
            String[] stringArray = new String[]{string3, string4, string5, string6};
            string7 = this.logUtil.writeLog(this.providerName, string, string2, stringArray, "", bl, 0, n);
        }
        catch (Exception exception) {}
        return string7;
    }
}

