/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.process;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.cim.CIMSecurityException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider.MethodProvider;
import com.sun.wbem.provider20.Authorizable;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.query.NonJoinExp;
import com.sun.wbem.query.QueryExp;
import com.sun.wbem.query.SelectExp;
import com.sun.wbem.query.SelectList;
import com.sun.wbem.query.WQLParser;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.process.ProcessData;
import com.sun.wbem.solarisprovider.process.ProcessManager;
import com.sun.wbem.solarisprovider.process.ProcessProviderException;
import com.sun.wbem.utility.log.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class Solaris_Process
implements InstanceProvider,
MethodProvider,
Authorizable {
    public static final String PROCESS_ADMIN_RIGHTS = "solaris.admin.procmgr.admin";
    public static final String PROCESS_USER_RIGHTS = "solaris.admin.procmgr.user";
    public static final String PROVIDERNAME = "Process Provider";
    private static CIMOMHandle cimomHandle = null;
    private static ProviderUtility provUtil = null;
    private LogUtil logUtil = null;
    private ProcessManager procMgr = null;

    static {
        System.loadLibrary("solprov");
    }

    native String GetOSName();

    native long GetParentPID(String var1);

    native String GetProcessArgs(String var1);

    public static native String GetProcessEnv(String var0);

    native String GetProcessName(String var1);

    public static native String GetProcessOwner(String var0);

    native int GetProcessPriority(String var1);

    native int GetProcessSize(String var1);

    native long GetProcessStart(String var1);

    native int GetProcessState(String var1);

    native long GetUsrSysTime(String var1);

    public static native int GeteUid();

    public static native int GetpwName(String var0);

    native int KillProcess(String var1);

    public static native int SeteUid(int var0);

    private CIMObjectPath buildCIMObjectPath(String string) {
        CIMObjectPath cIMObjectPath = new CIMObjectPath();
        cIMObjectPath.setObjectName("Solaris_Process");
        cIMObjectPath.addKey("Handle", new CIMValue((Object)string));
        return cIMObjectPath;
    }

    private void checkAuthorizationAndOwnership(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = "";
        if (!provUtil.testRights(PROCESS_ADMIN_RIGHTS, cIMObjectPath)) {
            int n;
            string = provUtil.getClientUserName();
            String string2 = null;
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                if (!cIMProperty.getName().equalsIgnoreCase("Handle")) continue;
                string2 = (String)cIMProperty.getValue().getValue();
            }
            if (string2 == null) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            if (!string.equals(this.procMgr.getProcessOwner(n))) {
                this.procMgr.writeLog(1, null, null, (Exception)new CIMSecurityException("CIM_ERR_ACCESS_DENIED"));
                throw new CIMException("CIM_ERR_ACCESS_DENIED");
            }
        }
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            String[] stringArray = new String[]{"Create Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10616", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {}
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        block6: {
            try {
                this.checkAuthorizationAndOwnership(cIMObjectPath);
            }
            catch (CIMException cIMException) {
                String[] stringArray = new String[]{"Delete Instance"};
                this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10613", stringArray, null, false, 0, 2);
                throw new CIMException("CIM_ERR_ACCESS_DENIED");
            }
            try {
                String string = null;
                Enumeration enumeration = cIMObjectPath.getKeys().elements();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                    if (!cIMProperty.getName().equalsIgnoreCase("Handle")) continue;
                    string = (String)cIMProperty.getValue().getValue();
                }
                int n = Integer.parseInt(string);
                int n2 = this.procMgr.killProcess(n);
                if (n2 == 0) {
                    String[] stringArray = new String[]{string};
                    this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10606", stringArray, null, false, 0, 0);
                    break block6;
                }
                String[] stringArray = new String[]{string};
                String string2 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10605", stringArray, null, false, 0, 2);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
            }
            catch (Exception exception) {
                String string = this.procMgr.writeLog(2, null, null, exception);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
            }
        }
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        Vector vector2 = null;
        String string = null;
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"enumInstances"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10613", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            vector2 = this.procMgr.getAllProcesses();
            if (vector2 == null) {
                return null;
            }
            string = this.procMgr.getOSName();
            if (string == null) {
                string = "SunOS";
            }
            int n = 0;
            while (n < vector2.size()) {
                CIMObjectPath cIMObjectPath2 = null;
                cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey("CSCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                try {
                    cIMObjectPath2.addKey("CSName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (UnknownHostException unknownHostException) {
                    unknownHostException.printStackTrace();
                    throw new CIMException("CIM_ERR_FAILED", (Object)unknownHostException);
                }
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_Process"));
                cIMObjectPath2.addKey("OSCreationClassName", new CIMValue((Object)"Solaris_OperatingSystem"));
                cIMObjectPath2.addKey("Handle", new CIMValue((Object)((ProcessData)vector2.elementAt(n)).getPID()));
                cIMObjectPath2.addKey("OSName", new CIMValue((Object)string));
                vector.addElement(cIMObjectPath2);
                ++n;
            }
            return vector;
        }
        catch (Exception exception) {
            String string2 = this.procMgr.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        Vector vector2 = null;
        String string = null;
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"enumInstances"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10613", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            vector2 = this.procMgr.getAllProcesses();
            if (vector2 == null) {
                return null;
            }
            string = this.procMgr.getOSName();
            if (string == null) {
                string = "SunOS";
            }
            int n = 0;
            while (n < vector2.size()) {
                CIMInstance cIMInstance = cIMClass.newInstance();
                String string2 = null;
                ProcessData processData = null;
                processData = (ProcessData)vector2.elementAt(n);
                string2 = processData.getPID();
                if (processData != null) {
                    cIMInstance.setProperty("Handle", new CIMValue((Object)string2));
                    cIMInstance.setProperty("ProcessOwner", new CIMValue((Object)processData.getPUSER()));
                    cIMInstance.setProperty("ProcessExecutable", new CIMValue((Object)processData.getPNAME()));
                    cIMInstance.setProperty("ProcessMemoryAddr", new CIMValue((Object)processData.getPADDR()));
                    cIMInstance.setProperty("ParentHandle", new CIMValue((Object)processData.getPPID()));
                    cIMInstance.setProperty("GroupHandle", new CIMValue((Object)processData.getPGID()));
                    cIMInstance.setProperty("ProcessUserPriority", new CIMValue((Object)processData.getPPRI()));
                    cIMInstance.setProperty("PercentCPUTime", new CIMValue((Object)processData.getPCPU()));
                    cIMInstance.setProperty("PercentMemorySize", new CIMValue((Object)processData.getPMEM()));
                    try {
                        cIMInstance.setProperty("ProcessVMSize", new CIMValue((Object)new UnsignedInt64(new BigInteger(processData.getPVSZ()))));
                    }
                    catch (NumberFormatException numberFormatException) {
                        cIMInstance.setProperty("ProcessVMSize", new CIMValue((Object)new UnsignedInt64(new BigInteger("0"))));
                    }
                    try {
                        cIMInstance.setProperty("ProcessResidentSetSize", new CIMValue((Object)new UnsignedInt64(new BigInteger(processData.getPRSS()))));
                    }
                    catch (NumberFormatException numberFormatException) {
                        cIMInstance.setProperty("ProcessResidentSetSize", new CIMValue((Object)new UnsignedInt64(new BigInteger("0"))));
                    }
                    cIMInstance.setProperty("ProcessControllingTerminal", new CIMValue((Object)processData.getPTTY()));
                    cIMInstance.setProperty("SystemSchedulingPriority", new CIMValue((Object)processData.getPNICE()));
                    cIMInstance.setProperty("ProcessSchedulingClass", new CIMValue((Object)processData.getPCLASS()));
                    cIMInstance.setProperty("ProcessStartTime", new CIMValue((Object)processData.getPSTIME()));
                    cIMInstance.setProperty("CumulativeExecutionTime", new CIMValue((Object)processData.getPTIME()));
                    cIMInstance.setProperty("ProcessStateString", new CIMValue((Object)processData.getPSTATE()));
                    cIMInstance.setProperty("BoundProcessorNumber", new CIMValue((Object)processData.getPPSR()));
                    cIMInstance.setProperty("ProcessWaitingAddr", new CIMValue((Object)processData.getPWCHAN()));
                    cIMInstance.setProperty("ExecutingCommand", new CIMValue((Object)processData.getPCMD()));
                    if (!bl2) {
                        cIMInstance.setProperty("CSCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                        cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_Process"));
                        cIMInstance.setProperty("OSCreationClassName", new CIMValue((Object)"Solaris_OperatingSystem"));
                        try {
                            cIMInstance.setProperty("CSName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                        }
                        catch (UnknownHostException unknownHostException) {}
                        cIMInstance.setProperty("OSName", new CIMValue((Object)string));
                        try {
                            cIMInstance.setProperty("Priority", new CIMValue((Object)new UnsignedInt32((long)this.GetProcessPriority(string2))));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        try {
                            cIMInstance.setProperty("WorkingSetSize", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString(this.GetProcessSize(string2))))));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        cIMInstance.setProperty("Name", new CIMValue((Object)this.GetProcessName(string2)));
                        cIMInstance.setProperty("Description", new CIMValue((Object)this.GetProcessArgs(string2)));
                        cIMInstance.setProperty("Caption", new CIMValue((Object)this.GetProcessArgs(string2)));
                        try {
                            cIMInstance.setProperty("ExecutionState", new CIMValue((Object)new UnsignedInt16(this.GetProcessState(string2))));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        cIMInstance.setProperty("Status", new CIMValue((Object)this.getStatus(string2)));
                        cIMInstance.setProperty("ParentHandle", new CIMValue((Object)Integer.toString((int)this.GetParentPID(string2))));
                        try {
                            cIMInstance.setProperty("UserKernelModeTime", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString((int)this.GetUsrSysTime(string2))))));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        cIMInstance.setProperty("UserModeTime", new CIMValue((Object)new UnsignedInt64(new BigInteger("0"))));
                        cIMInstance.setProperty("KernelModeTime", new CIMValue((Object)new UnsignedInt64(new BigInteger("0"))));
                        Date date = new Date(1000L * this.GetProcessStart(string2));
                        cIMInstance.setProperty("CreationDate", new CIMValue((Object)new CIMDateTime(date)));
                        cIMInstance.setProperty("InstallDate", new CIMValue((Object)new CIMDateTime(date)));
                    }
                    vector.addElement(cIMInstance);
                }
                ++n;
            }
            return vector;
        }
        catch (Exception exception) {
            String string3 = this.procMgr.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
        }
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"execQuery"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10613", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        WQLParser wQLParser = new WQLParser((InputStream)byteArrayInputStream);
        Vector<CIMElement> vector = new Vector<CIMElement>();
        try {
            SelectExp selectExp = (SelectExp)wQLParser.querySpecification();
            SelectList selectList = selectExp.getSelectList();
            NonJoinExp nonJoinExp = (NonJoinExp)selectExp.getFromClause();
            QueryExp queryExp = selectExp.getWhereClause();
            Vector vector2 = new Vector();
            vector2 = this.enumInstances(cIMObjectPath, false, cIMClass, true);
            int n2 = 0;
            while (n2 < vector2.size()) {
                if (queryExp == null || queryExp.apply((CIMElement)((CIMInstance)vector2.elementAt(n2)))) {
                    vector.addElement(selectList.apply((CIMElement)((CIMInstance)vector2.elementAt(n2))));
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{string};
            String string2 = this.procMgr.writeLog(2, "LM_10640", stringArray, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return vector;
    }

    protected static CIMOMHandle getCimomHandle() {
        return cimomHandle;
    }

    private Date getDate(String string) {
        Date date = null;
        DateFormat dateFormat = DateFormat.getTimeInstance(3);
        try {
            date = dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return date;
    }

    public Integer getExtendedProperty(String string, String string2, Vector vector) throws CIMException {
        Integer n;
        try {
            CIMObjectPath cIMObjectPath;
            if (string2.equals("") || string2 == null) {
                cIMObjectPath = this.buildCIMObjectPath(string2);
                if (!provUtil.testRights(PROCESS_USER_RIGHTS, cIMObjectPath) && !provUtil.testRights(PROCESS_ADMIN_RIGHTS, cIMObjectPath)) {
                    String[] stringArray = new String[]{"getExtendedProperty"};
                    this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10613", stringArray, null, false, 0, 2);
                    throw new CIMException("CIM_ERR_ACCESS_DENIED");
                }
                provUtil.checkAuthenticated();
            } else {
                cIMObjectPath = this.buildCIMObjectPath(string2);
                this.checkAuthorizationAndOwnership(cIMObjectPath);
            }
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"getExtendedProperty"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10613", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            Vector vector2 = this.procMgr.getExtendedProperty(string, string2);
            if (vector2 == null) {
                n = new Integer(-1);
            } else {
                vector.addElement(new CIMValue((Object)vector2));
                n = new Integer(0);
            }
        }
        catch (ProcessProviderException processProviderException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)processProviderException.getLocalizedMessage());
        }
        catch (Exception exception) {
            String string3 = this.procMgr.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
        }
        return n;
    }

    private String getHandle(CIMObjectPath cIMObjectPath) {
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase("Handle")) continue;
            String string = (String)cIMProperty.getValue().getValue();
            return string;
        }
        return "-1";
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        ProcessData processData = null;
        String string = null;
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"getInstance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10613", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            CIMInstance cIMInstance;
            String string2 = null;
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration != null && enumeration.hasMoreElements()) {
                cIMInstance = (CIMInstance)enumeration.nextElement();
                if (!cIMInstance.getName().equalsIgnoreCase("Handle")) continue;
                string2 = (String)cIMInstance.getValue().getValue();
            }
            processData = this.procMgr.getProcessData(string2);
            if (processData == null) {
                cIMInstance = new CIMInstance[]{"getInstance"};
                this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10607", (String[])cIMInstance, null, false, 0, 2);
                return null;
            }
            string = this.procMgr.getOSName();
            if (string == null) {
                string = "SunOS";
            }
            cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty("Handle", new CIMValue((Object)string2));
            cIMInstance.setProperty("ProcessOwner", new CIMValue((Object)processData.getPUSER()));
            cIMInstance.setProperty("ProcessExecutable", new CIMValue((Object)processData.getPNAME()));
            cIMInstance.setProperty("ProcessMemoryAddr", new CIMValue((Object)processData.getPADDR()));
            cIMInstance.setProperty("ParentHandle", new CIMValue((Object)processData.getPPID()));
            cIMInstance.setProperty("GroupHandle", new CIMValue((Object)processData.getPGID()));
            cIMInstance.setProperty("ProcessUserPriority", new CIMValue((Object)processData.getPPRI()));
            cIMInstance.setProperty("PercentCPUTime", new CIMValue((Object)processData.getPCPU()));
            cIMInstance.setProperty("PercentMemorySize", new CIMValue((Object)processData.getPMEM()));
            try {
                cIMInstance.setProperty("ProcessVMSize", new CIMValue((Object)new UnsignedInt64(new BigInteger(processData.getPVSZ()))));
            }
            catch (NumberFormatException numberFormatException) {
                cIMInstance.setProperty("ProcessVMSize", new CIMValue((Object)new UnsignedInt64(new BigInteger("0"))));
            }
            try {
                cIMInstance.setProperty("ProcessResidentSetSize", new CIMValue((Object)new UnsignedInt64(new BigInteger(processData.getPRSS()))));
            }
            catch (NumberFormatException numberFormatException) {
                cIMInstance.setProperty("ProcessResidentSetSize", new CIMValue((Object)new UnsignedInt64(new BigInteger("0"))));
            }
            cIMInstance.setProperty("ProcessControllingTerminal", new CIMValue((Object)processData.getPTTY()));
            cIMInstance.setProperty("SystemSchedulingPriority", new CIMValue((Object)processData.getPNICE()));
            cIMInstance.setProperty("ProcessSchedulingClass", new CIMValue((Object)processData.getPCLASS()));
            cIMInstance.setProperty("ProcessStartTime", new CIMValue((Object)processData.getPSTIME()));
            cIMInstance.setProperty("CumulativeExecutionTime", new CIMValue((Object)processData.getPTIME()));
            cIMInstance.setProperty("ProcessStateString", new CIMValue((Object)processData.getPSTATE()));
            cIMInstance.setProperty("BoundProcessorNumber", new CIMValue((Object)processData.getPPSR()));
            cIMInstance.setProperty("ProcessWaitingAddr", new CIMValue((Object)processData.getPWCHAN()));
            cIMInstance.setProperty("ExecutingCommand", new CIMValue((Object)processData.getPCMD()));
            if (bl) {
                return cIMInstance;
            }
            cIMInstance.setProperty("CSCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_Process"));
            cIMInstance.setProperty("OSCreationClassName", new CIMValue((Object)"Solaris_OperatingSystem"));
            try {
                cIMInstance.setProperty("CSName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (UnknownHostException unknownHostException) {}
            cIMInstance.setProperty("OSName", new CIMValue((Object)string));
            try {
                cIMInstance.setProperty("Priority", new CIMValue((Object)new UnsignedInt32((long)this.GetProcessPriority(string2))));
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                cIMInstance.setProperty("WorkingSetSize", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString(this.GetProcessSize(string2))))));
            }
            catch (NumberFormatException numberFormatException) {}
            cIMInstance.setProperty("Name", new CIMValue((Object)this.GetProcessName(string2)));
            cIMInstance.setProperty("Description", new CIMValue((Object)this.GetProcessArgs(string2)));
            cIMInstance.setProperty("Caption", new CIMValue((Object)this.GetProcessArgs(string2)));
            try {
                cIMInstance.setProperty("ExecutionState", new CIMValue((Object)new UnsignedInt16(this.GetProcessState(string2))));
            }
            catch (NumberFormatException numberFormatException) {}
            cIMInstance.setProperty("Status", new CIMValue((Object)this.getStatus(string2)));
            cIMInstance.setProperty("ParentHandle", new CIMValue((Object)Integer.toString((int)this.GetParentPID(string2))));
            try {
                cIMInstance.setProperty("UserKernelModeTime", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString((int)this.GetUsrSysTime(string2))))));
            }
            catch (NumberFormatException numberFormatException) {}
            cIMInstance.setProperty("UserModeTime", new CIMValue((Object)new UnsignedInt64(new BigInteger("0"))));
            cIMInstance.setProperty("KernelModeTime", new CIMValue((Object)new UnsignedInt64(new BigInteger("0"))));
            Date date = new Date(1000L * this.GetProcessStart(string2));
            cIMInstance.setProperty("CreationDate", new CIMValue((Object)new CIMDateTime(date)));
            cIMInstance.setProperty("InstallDate", new CIMValue((Object)new CIMDateTime(date)));
            return cIMInstance;
        }
        catch (Exception exception) {
            String string3 = this.procMgr.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
        }
    }

    protected static ProviderUtility getProviderUtil() {
        return provUtil;
    }

    private String getStatus(String string) {
        int n = this.GetProcessState(string);
        switch (n) {
            case 3: {
                return "Unknown";
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                return "OK";
            }
        }
        return "Unknown";
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        cimomHandle = cIMOMHandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cIMOMHandle);
        try {
            provUtil = new ProviderUtility(cimomHandle, PROVIDERNAME);
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        this.procMgr = new ProcessManager(cimomHandle, provUtil, this.logUtil);
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        if (string.equalsIgnoreCase("suspendProcess")) {
            if (!this.objectPathHasKey(cIMObjectPath)) {
                int n = (Integer)((CIMValue)vector.elementAt(0)).getValue();
                String string2 = String.valueOf(n);
                cIMObjectPath.addKey("Handle", new CIMValue((Object)string2));
            }
            try {
                this.checkAuthorizationAndOwnership(cIMObjectPath);
            }
            catch (CIMException cIMException) {
                String[] stringArray = new String[]{"suspend process"};
                this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10613", stringArray, null, false, 0, 2);
                throw new CIMException("CIM_ERR_ACCESS_DENIED");
            }
            return new CIMValue((Object)this.suspendProcess((Integer)((CIMValue)vector.elementAt(0)).getValue()));
        }
        if (string.equalsIgnoreCase("resumeprocess")) {
            if (!this.objectPathHasKey(cIMObjectPath)) {
                int n = (Integer)((CIMValue)vector.elementAt(0)).getValue();
                String string3 = String.valueOf(n);
                cIMObjectPath.addKey("Handle", new CIMValue((Object)string3));
            }
            try {
                this.checkAuthorizationAndOwnership(cIMObjectPath);
            }
            catch (CIMException cIMException) {
                String[] stringArray = new String[]{"Resume process"};
                this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10613", stringArray, null, false, 0, 2);
                throw new CIMException("CIM_ERR_ACCESS_DENIED");
            }
            return new CIMValue((Object)this.resumeProcess((Integer)((CIMValue)vector.elementAt(0)).getValue()));
        }
        if (string.equalsIgnoreCase("startNewProcByUid")) {
            Object[] objectArray;
            try {
                provUtil.checkAuthenticated();
            }
            catch (CIMException cIMException) {
                String[] stringArray = new String[]{"Start New Process"};
                this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10613", stringArray, null, false, 0, 2);
                throw new CIMException("CIM_ERR_ACCESS_DENIED");
            }
            Vector vector3 = (Vector)((CIMValue)vector.elementAt(2)).getValue();
            if (vector3 != null && vector3.size() != 0) {
                objectArray = new String[vector3.size()];
                try {
                    vector3.copyInto(objectArray);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    objectArray = null;
                }
            } else {
                objectArray = null;
            }
            return new CIMValue((Object)this.startNewProcByUid((String)((CIMValue)vector.elementAt(0)).getValue(), (String)((CIMValue)vector.elementAt(1)).getValue(), (String[])objectArray, (String)((CIMValue)vector.elementAt(3)).getValue()));
        }
        if (string.equalsIgnoreCase("getExtendedProperty")) {
            provUtil.checkAuthenticated();
            return new CIMValue((Object)this.getExtendedProperty((String)((CIMValue)vector.elementAt(0)).getValue(), (String)((CIMValue)vector.elementAt(1)).getValue(), vector2));
        }
        return null;
    }

    private boolean objectPathHasKey(CIMObjectPath cIMObjectPath) {
        String string = null;
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase("Handle")) continue;
            string = (String)cIMProperty.getValue().getValue();
        }
        return string != null;
    }

    public Integer resumeProcess(int n) throws CIMException {
        int n2;
        String string = String.valueOf(n);
        try {
            n2 = this.procMgr.resumeProcess(n);
            if (n2 == 0) {
                String[] stringArray = new String[]{string};
                this.logUtil.writeLog(PROVIDERNAME, "LM_10641", "LM_10604", stringArray, null, false, 0, 0);
            } else {
                String[] stringArray = new String[]{string};
                this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10603", stringArray, null, false, 0, 2);
            }
        }
        catch (Exception exception) {
            String string2 = this.procMgr.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return new Integer(n2);
    }

    public synchronized void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        block8: {
            Object object;
            if (!this.objectPathHasKey(cIMObjectPath)) {
                object = (String[])cIMInstance.getProperty("Handle").getValue().getValue();
                cIMObjectPath.addKey("Handle", new CIMValue(object));
            }
            if (!provUtil.testRights(PROCESS_ADMIN_RIGHTS, cIMObjectPath)) {
                object = new String[]{"Modify Instance"};
                this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10613", object, null, false, 0, 2);
                throw new CIMException("CIM_ERR_ACCESS_DENIED");
            }
            object = null;
            String string = null;
            ProcessData processData = null;
            String string2 = null;
            try {
                String[] stringArray;
                int n;
                object = (String)cIMInstance.getProperty("Handle").getValue().getValue();
                processData = this.procMgr.getProcessData((String)object);
                string = (String)cIMInstance.getProperty("ProcessUserPriority").getValue().getValue();
                string2 = (String)cIMInstance.getProperty("ProcessSchedulingClass").getValue().getValue();
                int n2 = Integer.parseInt(string);
                int n3 = Integer.parseInt((String)object);
                if (!string.equals(processData.getPPRI())) {
                    n = this.procMgr.setProcessUserPriority(n3, n2);
                    if (n == 0) {
                        stringArray = new String[]{"Process Priority"};
                        this.logUtil.writeLog(PROVIDERNAME, "LM_10641", "LM_10615", stringArray, null, false, 0, 0);
                    } else {
                        String[] stringArray2 = new String[]{"Process Priority"};
                        String string3 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10614", stringArray2, null, false, 0, 2);
                        throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
                    }
                }
                if (string2.equals(processData.getPCLASS())) break block8;
                n = this.procMgr.setProcessSchedClass(n3, string2);
                if (n == 0) {
                    stringArray = new String[]{"Process Scheduling Class"};
                    this.logUtil.writeLog(PROVIDERNAME, "LM_10641", "LM_10615", stringArray, null, false, 0, 0);
                    break block8;
                }
                stringArray = new String[]{"Process Scheduling Class"};
                String string4 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10614", stringArray, null, false, 0, 2);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{"Priority/Scheduling Class"};
                String string5 = this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10614", stringArray, null, false, 0, 2);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string5);
            }
        }
    }

    public Integer startNewProcByUid(String string, String string2, String[] stringArray, String string3) throws CIMException {
        try {
            this.procMgr.startNewProcByUid(string, string2, stringArray, string3);
        }
        catch (ProcessProviderException processProviderException) {
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)processProviderException.getLocalizedMessage());
        }
        catch (Exception exception) {
            String string4 = this.procMgr.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
        }
        return new Integer(0);
    }

    public Integer suspendProcess(int n) throws CIMException {
        int n2;
        String string = String.valueOf(n);
        try {
            n2 = this.procMgr.suspendProcess(n);
            if (n2 == 0) {
                String[] stringArray = new String[]{string};
                this.logUtil.writeLog(PROVIDERNAME, "LM_10641", "LM_10602", stringArray, null, false, 0, 0);
            } else {
                String[] stringArray = new String[]{string};
                this.logUtil.writeLog(PROVIDERNAME, "LM_10600", "LM_10601", stringArray, null, false, 0, 2);
            }
        }
        catch (CIMException cIMException) {
            String string2 = this.procMgr.writeLog(2, null, null, (Exception)((Object)cIMException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return new Integer(n2);
    }
}

