/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.osserver;

import com.sun.wbem.solarisprovider.osserver.DBTableException;
import com.sun.wbem.solarisprovider.osserver.HostObject;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.Vector;

public class HostTable {
    private String table = new String("hosts");
    private String ipAddrCol = "addr";
    private String hostNameCol = "cname";
    private String aliasesCol = "aliases";
    private String commentCol = "comment";
    private String scope;

    public HostTable(String string) {
        this.scope = string;
    }

    public void addHostEntry(HostObject hostObject) throws DBTableException, DirectoryTableException {
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        String string = hostObject.getHostName();
        String string2 = hostObject.getIPAddr();
        if (string == null || string.trim().length() == 0 || string2 == null || string2.trim().length() == 0 || !hostObject.isIPAddr(string2)) {
            throw new DBTableException("EXM_HOSTENTRY_BAD", string, string2);
        }
        try {
            directoryTable = this.openHostTable();
            directoryRow = this.checkHostEntry(directoryTable, hostObject, false);
            if (directoryRow != null) {
                HostObject hostObject2 = this.makeHostObject(directoryTable, directoryRow);
                directoryTable.close();
                if (hostObject2.equals(hostObject)) {
                    return;
                }
                throw new DBTableException("EXM_ADD_EXIST", this.table);
            }
            directoryRow = this.makeRow(directoryTable, hostObject);
            directoryTable.addRow(directoryRow);
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
    }

    private DirectoryRow checkHostEntry(DirectoryTable directoryTable, HostObject hostObject, boolean bl) throws DirectoryTableException {
        DirectoryRow directoryRow = null;
        String string = hostObject.getHostName();
        String string2 = hostObject.getIPAddr();
        if (!(string != null && string.trim().length() != 0 || string2 != null && string2.trim().length() != 0)) {
            return null;
        }
        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
        directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
        if (bl) {
            if (string != null && string.trim().length() != 0) {
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.hostNameCol), string);
            }
            if (string2 != null && string2.trim().length() != 0) {
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.ipAddrCol), string2);
            }
            directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
            return directoryRow;
        }
        if (string != null && string.trim().length() != 0) {
            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.hostNameCol), string);
            directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
            if (directoryRow != null) {
                return directoryRow;
            }
        }
        if (string2 != null && string2.trim().length() != 0) {
            directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.ipAddrCol), string2);
            directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
            if (directoryRow != null) {
                return directoryRow;
            }
        }
        return null;
    }

    public void deleteHostEntry(HostObject hostObject) throws DBTableException, DirectoryTableException {
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        String string = hostObject.getHostName();
        String string2 = hostObject.getIPAddr();
        if (!(string != null && string.trim().length() != 0 || string2 != null && string2.trim().length() != 0)) {
            throw new DBTableException("EXM_DEL_INV", this.table);
        }
        try {
            directoryTable = this.openHostTable();
            directoryRow = this.checkHostEntry(directoryTable, hostObject, true);
            if (directoryRow == null) {
                directoryTable.close();
                return;
            }
            directoryTable.deleteRow(directoryRow);
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
    }

    public void deleteHostEntry(String string) throws DBTableException, DirectoryTableException {
        HostObject hostObject = new HostObject(string);
        this.deleteHostEntry(hostObject);
    }

    public HostObject getHostEntry(HostObject hostObject) throws DirectoryTableException {
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        HostObject hostObject2 = null;
        try {
            directoryTable = this.openHostTable();
            directoryRow = this.checkHostEntry(directoryTable, hostObject, true);
            if (directoryRow != null) {
                hostObject2 = this.makeHostObject(directoryTable, directoryRow);
            }
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
        return hostObject2;
    }

    public HostObject getHostEntry(String string) throws DirectoryTableException {
        HostObject hostObject = new HostObject(string);
        return this.getHostEntry(hostObject);
    }

    public HostObject getHostEntryByAddr(String string) throws DirectoryTableException {
        HostObject hostObject = new HostObject(string, null, null, null);
        return this.getHostEntry(hostObject);
    }

    public HostObject getHostEntryByName(String string) throws DirectoryTableException {
        HostObject hostObject = new HostObject(null, string, null, null);
        return this.getHostEntry(hostObject);
    }

    private String getInput(String string) {
        System.out.print(string);
        try {
            byte[] byArray = new byte[100];
            char c = (char)System.in.read(byArray);
            if ((char)byArray[c - '\u0001'] == '\n') {
                byArray[c - '\u0001'] = 0;
            }
            String string2 = new String(byArray);
            return string2.trim();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            return new String("");
        }
    }

    public Vector list() throws DirectoryTableException {
        Vector<HostObject> vector = new Vector<HostObject>();
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        try {
            directoryTable = this.openHostTable();
            directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                vector.addElement(this.makeHostObject(directoryTable, directoryRow));
                directoryRow = directoryTable.getNextRow();
            }
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
        return vector;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        var1_1 = null;
        var2_2 = false;
        try {
            var1_1 = new HostTable("File://localhost");
            if (true) ** GOTO lbl44
        }
        catch (Exception var3_3) {
            System.out.println("Exception: " + var3_3);
            return;
        }
        do {
            System.out.println("1 - Add hosts entry");
            System.out.println("2 - Delete hosts entry");
            System.out.println("3 - Get hosts entry");
            System.out.println("4 - List hosts table");
            System.out.println("9 - Exit");
            System.out.print("Enter option: ");
            try {
                var3_4 = new byte[100];
                var4_6 = (char)System.in.read(var3_4);
                System.out.println("");
                if (var4_6 != '\u0002') {
                    var2_2 = true;
                    continue;
                }
                var5_7 = (char)var3_4[0];
                switch (var5_7) {
                    case '1': {
                        var1_1.testAdd();
                        break;
                    }
                    case '2': {
                        var1_1.testDelete();
                        break;
                    }
                    case '3': {
                        var1_1.testGet();
                        break;
                    }
                    case '4': {
                        var1_1.testList();
                        break;
                    }
                    default: {
                        var2_2 = true;
                        break;
                    }
                }
            }
            catch (Exception var3_5) {
                System.out.println("Exception: " + var3_5);
            }
            System.out.println("");
lbl44:
            // 3 sources

        } while (!var2_2);
    }

    private HostObject makeHostObject(DirectoryTable directoryTable, DirectoryRow directoryRow) throws DirectoryTableException {
        HostObject hostObject = null;
        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
        String string = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.ipAddrCol));
        String string2 = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.hostNameCol));
        String string3 = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.aliasesCol));
        String string4 = directoryRow.getColumn(tableDefinitions.getColumnNumber(this.commentCol));
        hostObject = new HostObject(string, string2, string3, string4);
        return hostObject;
    }

    private DirectoryRow makeRow(DirectoryTable directoryTable, HostObject hostObject) throws DirectoryTableException {
        TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
        DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
        String string = hostObject.getIPAddr();
        if (string != null && string.trim().length() != 0) {
            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.ipAddrCol), string);
        }
        if ((string = hostObject.getHostName()) != null && string.trim().length() != 0) {
            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.hostNameCol), string);
        }
        if ((string = hostObject.getAliases()) != null && string.trim().length() != 0) {
            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.aliasesCol), string);
        }
        if ((string = hostObject.getComment()) != null && string.trim().length() != 0) {
            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.commentCol), string);
        }
        return directoryRow;
    }

    public void modifyHostEntry(HostObject hostObject, HostObject hostObject2) throws DBTableException, DirectoryTableException {
        this.deleteHostEntry(hostObject);
        this.addHostEntry(hostObject2);
    }

    public void modifyHostEntry(String string, HostObject hostObject) throws DBTableException, DirectoryTableException {
        this.deleteHostEntry(string);
        this.addHostEntry(hostObject);
    }

    private DirectoryTable openHostTable() throws DirectoryTableException {
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
        directoryTable.open(this.table);
        return directoryTable;
    }

    private void testAdd() throws Exception {
        System.out.println("****Start testAdd****");
        String string = this.getInput("IP Address: ");
        String string2 = this.getInput("Host Name: ");
        String string3 = this.getInput("Aliases: ");
        String string4 = this.getInput("Comment: ");
        HostObject hostObject = new HostObject(string, string2, string3, string4);
        this.addHostEntry(hostObject);
        System.out.println("****End of test****");
    }

    private void testDelete() throws Exception {
        System.out.println("****Start testDelete****");
        System.out.println("(Only IP Address or Host Name required)");
        String string = this.getInput("IP Address: ");
        String string2 = this.getInput("Host Name: ");
        String string3 = this.getInput("Aliases: ");
        String string4 = this.getInput("Comment: ");
        HostObject hostObject = new HostObject(string, string2, string3, string4);
        this.deleteHostEntry(hostObject);
        System.out.println("****End of test****");
    }

    private void testGet() throws Exception {
        System.out.println("****Start testGet****");
        String string = this.getInput("IP Address or Host Name: ");
        HostObject hostObject = this.getHostEntry(string);
        System.out.println("    Got:\t" + hostObject);
        string = this.getInput("IP Address: ");
        hostObject = this.getHostEntryByAddr(string);
        System.out.println("    Got:\t" + hostObject);
        string = this.getInput("Host Name:");
        hostObject = this.getHostEntryByName(string);
        System.out.println("    Got:\t" + hostObject);
        System.out.println("****End of test****");
    }

    private void testList() throws Exception {
        System.out.println("****Start testList****");
        Vector vector = this.list();
        System.out.println("Host Table (" + vector.size() + " entries) :::");
        int n = 0;
        while (vector != null && n < vector.size()) {
            HostObject hostObject = (HostObject)vector.elementAt(n);
            System.out.println(hostObject);
            ++n;
        }
        System.out.println("****End of test****");
    }
}

