/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.util.snmp;

import com.sun.jade.device.fcswitch.util.snmp.FCFABRIC_ELEMENT_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.FIBRE_CHANNEL_FE_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.MibRepository;
import com.sun.jade.device.protocol.snmp.SNMP;
import com.sun.jade.device.protocol.snmp.SingleSnmpSession;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Properties;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpOidTable;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;
import javax.management.snmp.manager.SnmpParameters;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpSession;

public class SwitchWWNsnmp {
    private String ipno;
    private static int TIMEOUT = 30000;
    private static int MAX_TRIES = 3;
    private SnmpPeer agent = null;
    private MibRepository oidTable = null;
    private String wwn;
    private String wwnHex;
    private String fabricName;
    private String deviceCategory;
    private String snmpVendorId;
    private String snmpVendorIdPlus;
    private static final String WWN = "WWN";
    private static final String QLOGIC = "QLogic";
    private static final String BROCADE = "Brocade";
    private static final String MCDATA = "MCDATA";
    private static final String SUN = "Sun";
    private static final String FIBRE_CHANNEL_SWITCH = "Fibre Channel Switch";
    private static final String SANBOX_1GB = "SANbox";
    private static final String ZERO = "0";
    private static final String DOT = ".";
    private static final String _SNMP = "_SNMP";
    private static final String FA = "FA";
    private static final String FE = "FE";
    public static final String WWN_ZERO_EXTENSION = "0.0.0.0.0.0.0.0";
    private static final String SYSDESCR = "sysDescr";
    private static final String SYSOBJECTID = "sysObjectID";
    private static final String ENTERPRISE_OID_PREFIX = "1.3.6.1.4.1.";
    private static final String FC_ELEMENT_NAME = "fcElementName";
    private static final String FC_FE_ELEMENT_NAME = "fcFeElementName";
    private static final String FC_FABRIC_NAME = "fcFabricName";
    private static final String FC_FE_FABRIC_NAME = "fcFeFabricName";
    private static String[] deviceType = new String[]{"fcFeModuleDescr"};
    private static String[] wwnFAProps = new String[]{"fcFeElementName"};
    private static String[] wwnFEProps = new String[]{"fcElementName"};
    private static String[] fabricFAProps = new String[]{"fcFeFabricName"};
    private static String[] fabricFEProps = new String[]{"fcFabricName"};
    private static final String QLOGIC_ANCOR_ENTERPRISE_ID = "1663";
    private static final String BROCADE_ENTERPRISE_ID = "1588";
    private static final String MCDATA_ENTERPRISE_ID = "289";
    private static final String SUN_QLOGIC_ANCOR_ENTERPRISE_ID = "42.2.28.3.4.1.1";
    private static final String INRANGE_ENTERPRISE_ID = "824";
    private SNMP snmp = null;
    private static SnmpSession session = null;
    private static final String LOG_TAG = "WWN_SNMP";
    public static final String sccs_id = "@(#)SwitchWWNsnmp.java\t1.16 03/27/03 SMI";

    public SwitchWWNsnmp(String string) {
        this.ipno = string;
        this.snmp = new SNMP();
        this.oidTable = MibRepository.getMibStorage();
        session = SingleSnmpSession.getSnmpSession();
        this.init();
    }

    private void init() {
        String string = null;
        try {
            Properties properties = this.snmp.getBaseProperties(this.ipno);
            if (properties != null) {
                this.deviceCategory = (String)properties.get(SYSDESCR);
                string = (String)properties.get(SYSOBJECTID);
            }
        }
        catch (Exception exception) {
            Report.error.log((Object)(exception.getLocalizedMessage() + " for device " + this.ipno));
        }
        if (this.deviceCategory == null || string == null) {
            return;
        }
        this.snmpVendorId = this.extractEnterpriseID(string);
        this.snmpVendorIdPlus = this.extractEnterpriseIDPlus(string);
        if (QLOGIC_ANCOR_ENTERPRISE_ID.equalsIgnoreCase(this.snmpVendorId) || this.snmpVendorIdPlus.startsWith(SUN_QLOGIC_ANCOR_ENTERPRISE_ID)) {
            if (this.deviceCategory.startsWith(QLOGIC) || this.deviceCategory.startsWith(SANBOX_1GB) || this.deviceCategory.startsWith(SUN)) {
                this.oidTable.addOidTable(new FIBRE_CHANNEL_FE_MIBOidTable());
                this.setWWNString(FA);
                this.setFabricName(FA);
            } else if (this.deviceCategory.startsWith(FIBRE_CHANNEL_SWITCH)) {
                this.oidTable.addOidTable(new FCFABRIC_ELEMENT_MIBOidTable());
                this.setWWNString(FE);
                this.setFabricName(FE);
            }
        } else if (BROCADE_ENTERPRISE_ID.equalsIgnoreCase(this.snmpVendorId)) {
            this.oidTable.addOidTable(new FCFABRIC_ELEMENT_MIBOidTable());
            this.setWWNString(FE);
            this.setFabricName(FE);
            if (this.wwn == null) {
                this.oidTable.addOidTable(new FIBRE_CHANNEL_FE_MIBOidTable());
                this.setWWNString(FA);
                this.setFabricName(FA);
            }
        } else if (MCDATA_ENTERPRISE_ID.equalsIgnoreCase(this.snmpVendorId)) {
            this.oidTable.addOidTable(new FCFABRIC_ELEMENT_MIBOidTable());
            this.setWWNString(FE);
            this.setFabricName(FE);
        } else if (INRANGE_ENTERPRISE_ID.equalsIgnoreCase(this.snmpVendorId)) {
            this.oidTable.addOidTable(new FIBRE_CHANNEL_FE_MIBOidTable());
            this.setWWNString(FA);
            this.setFabricName(FA);
        } else {
            this.oidTable.addOidTable(new FCFABRIC_ELEMENT_MIBOidTable());
            this.setWWNString(FE);
            this.setFabricName(FE);
        }
    }

    private String extractEnterpriseID(String string) {
        if (string.startsWith("1.3.6.1.4.824")) {
            return INRANGE_ENTERPRISE_ID;
        }
        int n = ENTERPRISE_OID_PREFIX.length();
        String string2 = string.substring(n, string.length());
        int n2 = string2.indexOf(DOT);
        return string.substring(n, n2 + n);
    }

    private String extractEnterpriseIDPlus(String string) {
        int n = ENTERPRISE_OID_PREFIX.length();
        String string2 = string.substring(n, string.length());
        return string2;
    }

    private void setWWNString(String string) {
        if (FA.equalsIgnoreCase(string)) {
            HashMap hashMap = this.getProperties(WWN, wwnFAProps, ZERO);
            this.wwn = (String)hashMap.get("fcFeElementName_SNMP");
            this.wwnHex = (String)hashMap.get(FC_FE_ELEMENT_NAME);
        } else {
            HashMap hashMap = this.getProperties(WWN, wwnFEProps, ZERO);
            this.wwn = (String)hashMap.get("fcElementName_SNMP");
            this.wwnHex = (String)hashMap.get(FC_ELEMENT_NAME);
        }
    }

    private void setFabricName(String string) {
        if (FA.equalsIgnoreCase(string)) {
            HashMap hashMap = this.getProperties(string, fabricFAProps, ZERO);
            this.fabricName = (String)hashMap.get(FC_FE_FABRIC_NAME);
        } else {
            HashMap hashMap = this.getProperties(string, fabricFEProps, ZERO);
            this.fabricName = (String)hashMap.get(FC_FABRIC_NAME);
        }
    }

    private void initializePeer() {
        try {
            this.agent = SingleSnmpSession.newSnmpPeer((String)this.ipno);
        }
        catch (UnknownHostException unknownHostException) {
            Report.error.log((Throwable)unknownHostException, (Object)"host not found");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized HashMap getProperties(String string, String[] stringArray, String string2) {
        SnmpVarBindList snmpVarBindList;
        SnmpVarBindList snmpVarBindList2 = new HashMap();
        SnmpRequest snmpRequest = null;
        boolean bl = false;
        try {
            SnmpOid.setSnmpOidTable((SnmpOidTable)this.oidTable);
            this.initializePeer();
            SnmpParameters snmpParameters = new SnmpParameters("public", "private");
            this.agent.setSnmpParam(snmpParameters);
            session.setDefaultPeer(this.agent);
            snmpVarBindList = new SnmpVarBindList("SNMP.WWN");
            try {
                int n = 0;
                while (n < stringArray.length) {
                    snmpVarBindList.addVarBind(stringArray[n] + DOT + string2);
                    ++n;
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                Report.debug.log(LOG_TAG, (Object)snmpStatusException.getLocalizedMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Report.debug.log(LOG_TAG, (Object)illegalArgumentException.getLocalizedMessage());
            }
            int n = 0;
            while (n < MAX_TRIES) {
                snmpRequest = session.snmpGetRequest(this.agent, null, snmpVarBindList);
                bl = snmpRequest.waitForCompletion((long)TIMEOUT);
                if (bl) break;
                try {
                    this.wait(TIMEOUT);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n;
            }
            if (!bl) {
                SnmpVarBindList snmpVarBindList3 = snmpVarBindList2;
                return snmpVarBindList3;
            }
            int n2 = snmpRequest.getErrorStatus();
            if (n2 != 0) {
                if (snmpRequest.getErrorIndex() != 0) {
                    Report.error.log((Object)("Error status = " + SnmpRequest.snmpErrorToString((int)n2)));
                    Report.error.log((Object)("Error index = " + snmpRequest.getErrorIndex()));
                }
                SnmpVarBindList snmpVarBindList4 = snmpVarBindList2;
                return snmpVarBindList4;
            }
            SnmpVarBindList snmpVarBindList5 = snmpRequest.getResponseVarBindList();
            int n3 = snmpVarBindList5.getVarBindCount();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n4 = 0;
            while (n4 < n3) {
                SnmpVarBind snmpVarBind = snmpVarBindList5.getVarBindAt(n4);
                if (snmpVarBind != null && snmpVarBind.isValidValue()) {
                    String string3;
                    SnmpValue snmpValue = snmpVarBind.getSnmpValue();
                    long[] lArray = snmpValue.toOid().longValue();
                    int n5 = 0;
                    while (n5 < lArray.length) {
                        stringBuffer.append(lArray[n5] + DOT);
                        string3 = Long.toHexString(lArray[n5]);
                        if (string3.length() == 1) {
                            string3 = ZERO + string3;
                        }
                        stringBuffer2.append(string3);
                        ++n5;
                    }
                    string3 = stringBuffer2.toString();
                    String string4 = stringBuffer.append(WWN_ZERO_EXTENSION).toString();
                    snmpVarBindList2.put(stringArray[n4] + _SNMP, string4);
                    snmpVarBindList2.put(stringArray[n4], string3);
                }
                ++n4;
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            Report.error.log((Throwable)snmpStatusException, (Object)"SNMP error");
            snmpVarBindList = snmpVarBindList2;
            return snmpVarBindList;
        }
        finally {
            if (snmpRequest != null) {
                snmpRequest = null;
            }
            if (this.agent != null) {
                this.agent = null;
            }
        }
        return snmpVarBindList2;
    }

    public String getFabricName() {
        return this.fabricName;
    }

    public String getWWNString() {
        if (this.wwnHex == null) {
            this.init();
        }
        return this.wwnHex;
    }

    public String getVendorSNMPId() {
        if ("42".equalsIgnoreCase(this.snmpVendorId)) {
            return this.snmpVendorIdPlus;
        }
        return this.snmpVendorId;
    }

    public String getVendorSNMPIdPlus() {
        return this.snmpVendorIdPlus;
    }

    public String getWWNSnmp() {
        return this.wwn;
    }

    public String getDeviceType() {
        return this.deviceCategory;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("usage <switch-ip-addresss>");
            System.exit(1);
        }
        int n = 0;
        while (n < stringArray.length) {
            SwitchWWNsnmp switchWWNsnmp = new SwitchWWNsnmp(stringArray[n]);
            String string = null;
            String string2 = null;
            string = switchWWNsnmp.getWWNString();
            string2 = switchWWNsnmp.getWWNSnmp();
            if (string == null) {
                System.out.println("No data returned");
                System.exit(0);
            }
            System.out.println(" WWN of Switch: " + string);
            System.out.println(" Fabric Name of Switch : " + switchWWNsnmp.getFabricName());
            System.out.println(" SNMP WWN of Switch: " + string2);
            System.out.println(" Device Category : " + switchWWNsnmp.getDeviceType());
            System.out.println(" SNMP WWN of Switch (via Static Method): " + SwitchWWNsnmp.hexToSnmpWWN(string));
            ++n;
        }
    }

    public static String hexToSnmpWWN(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 2;
        int n3 = string.length();
        try {
            if (n3 == 16) {
                int n4 = 0;
                while (n4 < 8) {
                    String string2 = string.substring(n, n + n2);
                    if (n4 != 7) {
                        stringBuffer.append(Integer.parseInt(string2, 16) + DOT);
                    } else {
                        stringBuffer.append(Integer.parseInt(string2, 16));
                    }
                    n += n2;
                    ++n4;
                }
            } else {
                Report.warning.log((Object)("WWN of invalid length. " + string));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static class Test
    extends UnitTest {
        public void testSwitchWWN() {
            this.assertEquals(SwitchWWNsnmp.hexToSnmpWWN("100000c0dd00b7da"), "16.0.0.192.221.0.183.218");
        }

        public void testSwitchWWNsnmp(String string) {
            SwitchWWNsnmp switchWWNsnmp = new SwitchWWNsnmp(string);
            String string2 = null;
            String string3 = null;
            string2 = switchWWNsnmp.getWWNString();
            string3 = switchWWNsnmp.getWWNSnmp();
            String string4 = switchWWNsnmp.getVendorSNMPId();
            this.assertNotNull(string2);
            this.assertNotNull(string3);
            this.assertEquals(switchWWNsnmp.getDeviceType(), "Brocade Switch");
            this.assertEquals(string4, SwitchWWNsnmp.BROCADE_ENTERPRISE_ID);
        }

        public static void main(String[] stringArray) {
            new Test().testSwitchWWNsnmp(stringArray[0]);
        }
    }
}

