/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.util.snmp;

import com.sun.jade.device.fcswitch.util.snmp.FCFABRIC_ELEMENT_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.FCMGMT_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.MibRepository;
import com.sun.jade.device.protocol.snmp.SingleSnmpSession;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.jdmk.snmp.SnmpOidTableSupport;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpOidRecord;
import javax.management.snmp.SnmpOidTable;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpString;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;
import javax.management.snmp.manager.SnmpParameters;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpRequestHandler;
import javax.management.snmp.manager.SnmpSession;

public class SNMPWalk {
    private static int TEN = 10;
    private static int ZERO = 0;
    private static int WAIT_TIMEOUT = 60000;
    private String wwn;
    private SnmpPeer agent = null;
    private SnmpOidTableSupport currentMib = null;
    private String ipno;
    private static final String LOG_TAG = "snmpwalk";
    private static MibRepository oidTable = null;
    private static SnmpSession session = null;
    public static final String sccs_id = "@(#)SNMPWalk.java\t1.12 05/02/03 SMI";

    public SNMPWalk(String string) {
        this(string, new FCMGMT_MIBOidTable());
        session = SingleSnmpSession.getAsyncSnmpSession();
    }

    public SNMPWalk(String string, SnmpOidTableSupport snmpOidTableSupport) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.ipno = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.currentMib = snmpOidTableSupport;
        oidTable = MibRepository.getMibStorage();
        oidTable.addOidTable(snmpOidTableSupport);
        session = SingleSnmpSession.getAsyncSnmpSession();
    }

    private void initializePeer() {
        try {
            this.agent = SingleSnmpSession.newSnmpPeer((String)this.ipno);
        }
        catch (UnknownHostException unknownHostException) {
            Report.error.log((Throwable)unknownHostException, (Object)"host not found");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snmpWalk(HashMap hashMap, String string, String string2) {
        SnmpRequest snmpRequest = null;
        boolean bl = false;
        AsyncRspHandler asyncRspHandler = null;
        try {
            SnmpOid.setSnmpOidTable((SnmpOidTable)oidTable);
            this.initializePeer();
            SnmpParameters snmpParameters = new SnmpParameters("public", "private");
            this.agent.setSnmpParam(snmpParameters);
            session.setDefaultPeer(this.agent);
            SnmpVarBindList snmpVarBindList = new SnmpVarBindList("SNMP.System_Properties");
            try {
                snmpVarBindList.addVarBind(string);
            }
            catch (SnmpStatusException snmpStatusException) {
                Report.debug.log(LOG_TAG, (Object)snmpStatusException.getLocalizedMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Report.debug.log(LOG_TAG, (Object)illegalArgumentException.getLocalizedMessage());
            }
            SnmpOid snmpOid = null;
            try {
                snmpOid = new SnmpOid(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    SnmpOidRecord snmpOidRecord = oidTable.resolveVarName(string2);
                    snmpOid = new SnmpOid(snmpOidRecord.getName());
                }
                catch (SnmpStatusException snmpStatusException) {
                    oidTable.addOidTable(this.currentMib);
                    SnmpOidRecord snmpOidRecord = oidTable.resolveVarName(string2);
                    snmpOid = new SnmpOid(snmpOidRecord.getName());
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    oidTable.addOidTable(this.currentMib);
                    SnmpOidRecord snmpOidRecord = oidTable.resolveVarName(string2);
                    snmpOid = new SnmpOid(snmpOidRecord.getName());
                }
                catch (Exception exception) {
                    Report.warning.log(LOG_TAG, (Object)exception.getLocalizedMessage());
                }
            }
            if (snmpOid == null) {
                return;
            }
            asyncRspHandler = new AsyncRspHandler(hashMap, snmpOid);
            snmpRequest = session.snmpWalkUntilRequest(this.agent, (SnmpRequestHandler)asyncRspHandler, snmpVarBindList, snmpOid);
            asyncRspHandler.setRequest(snmpRequest);
            asyncRspHandler.waitForRequest();
        }
        catch (SnmpStatusException snmpStatusException) {
            Report.debug.log(LOG_TAG, (Object)snmpStatusException.getLocalizedMessage());
            return;
        }
        finally {
            if (snmpRequest != null) {
                snmpRequest = null;
            }
            if (asyncRspHandler != null) {
                asyncRspHandler.setFinished();
                asyncRspHandler = null;
            }
            if (this.agent != null) {
                this.agent = null;
            }
        }
    }

    public HashMap getProperties(String string, String string2) {
        HashMap hashMap = new HashMap();
        this.snmpWalk(hashMap, string, string2);
        return hashMap;
    }

    public HashMap filterProperties(HashMap hashMap, String string) {
        HashMap hashMap2 = new HashMap();
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            hashMap2.put(string2, hashMap.get(string2));
        }
        return hashMap2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        Object var1_1 = null;
        if (stringArray.length != 4) {
            System.out.println("usage:java SNMPWalk <switch-ip-addresss> <startProperty> <endProperty> <nooftimestoWalk>");
            System.out.println("Example: java com.sun.jade.device.fcswitch.util.snmp.SNMPWalk 172.20.67.101 connUnitLinkPortWwnX connUnitLinkNodeIdY 1");
            System.exit(1);
        }
        try {
            try {
                int n = 0;
                n = Integer.parseInt(stringArray[3]);
                int n2 = 0;
                block4: while (n2 < n) {
                    SNMPWalk sNMPWalk = new SNMPWalk(stringArray[0]);
                    HashMap hashMap = null;
                    hashMap = sNMPWalk.getProperties(stringArray[1], stringArray[2]);
                    if (hashMap == null) {
                        System.out.println("No data returned");
                        System.exit(0);
                    }
                    Iterator iterator = hashMap.keySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            ++n2;
                            continue block4;
                        }
                        String string = (String)iterator.next();
                        String string2 = (String)hashMap.get(string);
                        System.out.println("Attribute Name: " + string + "\t Attribute Value: " + string2);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var10_11 = null;
                SingleSnmpSession.destroyAsyncSnmpSession();
                return;
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            SingleSnmpSession.destroyAsyncSnmpSession();
            throw throwable;
        }
        SingleSnmpSession.destroyAsyncSnmpSession();
    }

    public static class Test
    extends UnitTest {
        public static void main(String[] stringArray) {
            new Test().testSNMP_Walk(stringArray[0]);
            new Test().testSNMP_Walk_withDiffMIBS(stringArray[0]);
            new Test().testUnderDiffScenerios(stringArray[0]);
        }

        public void testSNMP_Walk(String string) {
            SNMPWalk sNMPWalk = new SNMPWalk(string);
            HashMap hashMap = null;
            hashMap = sNMPWalk.getProperties("connUnitLinkPortWwnX", "connUnitLinkNodeIdY");
            this.assertNotNull(hashMap);
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = (String)hashMap.get(string2);
                this.assertNotNull(string2);
            }
        }

        public void testSNMP_Walk_withDiffMIBS(String string) {
            String string2;
            String string3;
            SNMPWalk sNMPWalk = new SNMPWalk(string, new FCMGMT_MIBOidTable());
            HashMap hashMap = null;
            hashMap = sNMPWalk.getProperties("connUnitLinkPortWwnX", "connUnitLinkNodeIdY");
            this.assertNotNull(hashMap);
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                string2 = (String)hashMap.get(string3);
                System.out.println("Token Name " + string3 + "\tToken Value " + string2);
                this.assertNotNull(string3);
            }
            sNMPWalk = new SNMPWalk(string, new FCFABRIC_ELEMENT_MIBOidTable());
            hashMap = null;
            hashMap = sNMPWalk.getProperties("fcFeFabricName", "fcFeModuleCapacity");
            this.assertNotNull(hashMap);
            iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                string2 = (String)hashMap.get(string3);
                System.out.println("Token Name " + string3 + "\tToken Value " + string2);
                this.assertNotNull(string3);
            }
        }

        public void testUnderDiffScenerios(String string) {
            SNMPWalk sNMPWalk = new SNMPWalk(string, new FCMGMT_MIBOidTable());
            HashMap hashMap = null;
            hashMap = sNMPWalk.getProperties("abc", "connUnitLinkNodeIdY");
            this.assertCondition(hashMap.size() == 0);
            hashMap = sNMPWalk.getProperties("abc", "efg");
            this.assertCondition(hashMap.size() == 0);
            hashMap = sNMPWalk.getProperties("connUnitLinkNodeIdY", "efg");
            this.assertCondition(hashMap.size() == 0);
            hashMap = sNMPWalk.getProperties("connUnitLinkNodeIdY", "connUnitId");
            this.assertCondition(hashMap.size() == 0);
        }
    }

    private class AsyncRspHandler
    implements SnmpRequestHandler {
        private SnmpRequest curRequest;
        private HashMap resultStore = null;
        private boolean isFinished;
        private SnmpOid endOid;
        private String endName;

        public AsyncRspHandler(HashMap hashMap, SnmpOid snmpOid) {
            this.resultStore = hashMap;
            this.endOid = snmpOid;
            this.endName = snmpOid.toString();
        }

        public HashMap getResult() {
            return this.resultStore;
        }

        public void setRequest(SnmpRequest snmpRequest) {
            this.curRequest = snmpRequest;
        }

        public synchronized void waitForRequest() {
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this.isFinished);
        }

        public synchronized boolean isFinished() {
            return this.isFinished;
        }

        public synchronized void setFinished() {
            this.isFinished = true;
            this.notifyAll();
        }

        private synchronized boolean checkDone() {
            SnmpVarBindList snmpVarBindList = this.curRequest.getResponseVarBindList();
            SnmpOid snmpOid = snmpVarBindList.getVarBindAt(ZERO).getOid();
            String string = snmpOid.toString();
            if (this.compareOid(snmpOid, this.endOid) <= 0) {
                this.setFinished();
                return true;
            }
            return false;
        }

        private int compareOid(SnmpOid snmpOid, SnmpOid snmpOid2) {
            return snmpOid2.compareTo(snmpOid);
        }

        public void processSnmpPollData(SnmpRequest snmpRequest, int n, int n2, SnmpVarBindList snmpVarBindList) {
            SnmpVarBindList snmpVarBindList2;
            SnmpVarBind snmpVarBind;
            Object var5_5 = null;
            if (snmpRequest.getRequestStatus() == 128 && (snmpVarBind = (snmpVarBindList2 = snmpRequest.getResponseVarBindList()).getVarBindAt(ZERO)) != null && snmpVarBind.isValidValue()) {
                SnmpValue snmpValue = snmpVarBind.getSnmpValue();
                if (snmpValue instanceof SnmpString) {
                    long[] lArray = snmpValue.toOid().longValue();
                    StringBuffer stringBuffer = new StringBuffer();
                    int n3 = 0;
                    while (n3 <= lArray.length - 1) {
                        String string = Long.toHexString(lArray[n3]);
                        if (string.length() == 1) {
                            string = "0" + string;
                        }
                        stringBuffer.append(string);
                        ++n3;
                    }
                    this.resultStore.put(snmpVarBind.getOid().toString(), stringBuffer.toString());
                } else {
                    this.resultStore.put(snmpVarBind.getOid().toString(), snmpVarBind.getStringValue());
                }
            }
            if (n != 0) {
                this.setFinished();
            }
            this.checkDone();
        }

        public void processSnmpPollTimeout(SnmpRequest snmpRequest) {
            Report.error.log((Object)("Request timed out: " + snmpRequest.toString()));
            if (snmpRequest.getRequestStatus() == 128) {
                SnmpVarBindList snmpVarBindList = snmpRequest.getResponseVarBindList();
            }
            this.setFinished();
        }

        public void processSnmpInternalError(SnmpRequest snmpRequest, String string) {
            Report.error.log((Object)("Session error: " + snmpRequest.toString()));
            Report.error.log((Object)("Error is: " + string));
            if (snmpRequest != null) {
                snmpRequest = null;
            }
            this.setFinished();
        }
    }
}

