/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.util.snmp;

import com.sun.jade.device.fcswitch.util.snmp.FCMGMT_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.Generic_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.SwitchWWNsnmp;
import com.sun.jade.util.unittest.UnitTest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class FA_Mibsnmp
extends Generic_Mibsnmp {
    private String wwn;
    private String ipno;
    private static final String DOT = ".";
    private static final String ZERO = "0";
    private static final String LOG_TAG = "FA_MIB";
    private static String[] portProps = new String[]{"connUnitPortIndex", "connUnitPortType", "connUnitPortState", "connUnitPortStatus", "connUnitPortWwn", "connUnitPortSpeed", "connUnitPortNodeWwn", "connUnitPortHWState"};
    private static String[] revisionProps = new String[]{"connUnitRevsDescription", "connUnitRevsRevId", "connUnitRevsIndex", "connUnitRevsUnitId"};
    private static String[] portstatProps = new String[]{"connUnitPortStatCountLinkFailures", "connUnitPortStatCountInvalidCRC", "connUnitPortStatCountInvalidTxWords", "connUnitPortStatCountPrimitiveSequenceProtocolErrors", "connUnitPortStatCountLossofSignal", "connUnitPortStatCountLossofSynchronization", "connUnitPortStatCountFramesTooLong", "connUnitPortStatCountFramesTruncated"};
    private static String[] connectivityUnitProps = new String[]{"systemURL", "uNumber"};
    private static String[] connectivityProps = new String[]{"connUnitNumports", "connUnitState", "connUnitStatus", "connUnitSn", "connUnitNumSensors", "connUnitNumRevs", "connUnitNumZones", "connUnitPrincipal"};
    private static String[] sensorProps = new String[]{"connUnitSensorType", "connUnitSensorInfo", "connUnitSensorStatus", "connUnitSensorName", "connUnitSensorIndex", "connUnitSensorUnitId", "connUnitSensorCharacteristic", "connUnitSensorMessage"};
    private static String[] linkProps = new String[]{"connUnitLinkPortWwnY"};
    private static String[] domainID = new String[]{"connUnitDomainId"};
    public static final String sccs_id = "@(#)FA_Mibsnmp.java\t1.7 08/29/02 SMI";

    public FA_Mibsnmp(String string) {
        super(string);
        this.ipno = string;
        this.addOidTable(new FCMGMT_MIBOidTable());
        SwitchWWNsnmp switchWWNsnmp = new SwitchWWNsnmp(this.ipno);
        this.wwn = switchWWNsnmp.getWWNSnmp();
    }

    public FA_Mibsnmp(Properties properties) {
        super(properties.getProperty("ip") == null ? properties.getProperty("remoteIP") : properties.getProperty("ip"));
        this.addOidTable(new FCMGMT_MIBOidTable());
        this.ipno = properties.getProperty("ip");
        if (this.ipno == null) {
            this.ipno = properties.getProperty("remoteIP");
        }
        this.wwn = properties.getProperty("wwnSnmp");
    }

    public HashMap getPortProps(int n) {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, portProps, this.wwn + DOT + n, "Hex");
        return hashMap;
    }

    public HashMap getPortStatProps(int n) {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, portstatProps, this.wwn + DOT + n);
        return hashMap;
    }

    public HashMap getConnectivityUnitProps() {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, connectivityUnitProps, ZERO);
        return hashMap;
    }

    public HashMap getConnectivityProps() {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, connectivityProps, this.wwn);
        return hashMap;
    }

    public HashMap getRevisionProps(int n) {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, revisionProps, this.wwn + DOT + n);
        return hashMap;
    }

    public HashMap getSensorProps(int n) {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, sensorProps, this.wwn + DOT + n);
        return hashMap;
    }

    public HashMap getLinkProps(String string) {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, linkProps, this.wwn + DOT + string, "Hex");
        return hashMap;
    }

    public String getDomainID() {
        String string;
        block2: {
            HashMap hashMap = new HashMap();
            string = null;
            this.getProperties(hashMap, domainID, this.wwn, "Hex");
            String string2 = (String)hashMap.get("connUnitDomainId");
            if (string2 == null) break block2;
            try {
                int n = string2.length();
                string = string2.substring(n - 2, n);
                int n2 = Integer.parseInt(string, 16);
                string = n2 + "";
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public static void main(String[] stringArray) {
        String string;
        Object object;
        Object var1_1 = null;
        if (stringArray.length < 2) {
            System.out.println("usage <switch-ip-addresss> <type> [index]");
            System.exit(1);
        }
        FA_Mibsnmp fA_Mibsnmp = new FA_Mibsnmp(stringArray[0]);
        String string2 = stringArray[1];
        int n = 0;
        if (stringArray.length > 2) {
            n = Integer.parseInt(stringArray[2]);
        }
        HashMap hashMap = null;
        if ("port".equals(string2)) {
            hashMap = fA_Mibsnmp.getPortProps(n);
        } else if ("connectivity".equals(string2)) {
            hashMap = fA_Mibsnmp.getConnectivityProps();
        } else if ("portstat".equals(string2)) {
            hashMap = fA_Mibsnmp.getPortStatProps(n);
        } else if ("sensor".equals(string2)) {
            hashMap = fA_Mibsnmp.getSensorProps(n);
        } else if ("connectivityUnit".equals(string2)) {
            hashMap = fA_Mibsnmp.getConnectivityUnitProps();
        } else if ("revision".equals(string2)) {
            hashMap = fA_Mibsnmp.getRevisionProps(n);
        } else if ("link".equals(string2)) {
            hashMap = fA_Mibsnmp.getLinkProps("1");
        } else if ("domainID".equals(string2)) {
            System.out.println("Domain Id " + fA_Mibsnmp.getDomainID());
            System.exit(0);
        } else if ("unitTest".equals(string2)) {
            int n2 = 1;
            while (n2 <= 8) {
                hashMap = fA_Mibsnmp.getPortProps(1);
                object = hashMap.keySet().iterator();
                System.out.println("FOR PORT " + n2);
                while (object.hasNext()) {
                    string = (String)object.next();
                    String string3 = (String)hashMap.get(string);
                    System.out.println("Attribute Name: " + string + "\t Attribute Value: " + string3);
                }
                ++n2;
            }
            System.exit(0);
        } else {
            System.out.println("bad type=" + string2);
            System.out.println("[port|connectivity|portstat|connectivityUnit|revision|sensor|link|domainID|unitTest]");
            System.exit(0);
        }
        if (hashMap == null) {
            System.out.println("No data returned");
            System.exit(0);
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            string = (String)hashMap.get(object);
            System.out.println("Attribute Name: " + (String)object + "\t Attribute Value: " + string);
        }
    }

    public static class Test
    extends UnitTest {
        public void testFA_MIB(String string) {
            FA_Mibsnmp fA_Mibsnmp = new FA_Mibsnmp(string);
            HashMap hashMap = fA_Mibsnmp.getConnectivityProps();
            this.assertEquals((String)hashMap.get("connUnitProduct"), "SANbox2-16");
            this.assertNotNull((String)hashMap.get("connUnitNumports"));
        }

        public static void main(String[] stringArray) {
            new Test().testFA_MIB(stringArray[0]);
        }
    }
}

