/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.service;

import com.sun.jade.device.fcswitch.fibrealliance.service.SwitchEnhancedPropertyHelper;
import com.sun.jade.device.fcswitch.fibrealliance.service.SwitchModel;
import com.sun.jade.device.fcswitch.fibrealliance.service.SwitchOOBProbe;
import com.sun.jade.device.fcswitch.util.snmp.FCMGMT_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.SNMPWalk;
import com.sun.jade.device.fcswitch.util.snmp.SW_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.SwitchWWNsnmp;
import com.sun.jade.util.unittest.UnitTest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class SwitchProbeDeepHelper {
    private String snmpWWN;
    private String wwn;
    private String ip;
    private String switchType;
    private String snmpVendorId;
    private String fabricName;
    private static final String SNMP = "snmp.";
    private static final String NAME = "name";
    private static final String SWITCH = "switch";
    private static final String QLC_FILTER = "1.3.6.1.3.94.1.6.1.1.";
    private static final String BRCD_FILTER = "1.3.6.1.4.1.1588.2.1.1.1.2.10.1.4.";
    public static final String sccs_id = "@(#)SwitchProbeDeep.java\t1.6 03/27/03 SMI";

    protected SwitchProbeDeepHelper(String string, String string2, String string3, String string4, String string5, String string6) {
        this.ip = string;
        this.snmpWWN = string3;
        this.switchType = string5;
        this.snmpVendorId = string4;
        this.wwn = string2;
        this.fabricName = string6;
    }

    public SwitchProbeDeepHelper(String string) {
        this.ip = string;
        SwitchWWNsnmp switchWWNsnmp = new SwitchWWNsnmp(string);
        this.wwn = switchWWNsnmp.getWWNString();
        this.snmpWWN = switchWWNsnmp.getWWNSnmp();
        this.switchType = switchWWNsnmp.getDeviceType();
        this.snmpVendorId = switchWWNsnmp.getVendorSNMPId();
        this.fabricName = switchWWNsnmp.getFabricName();
    }

    public Collection doDeepProbe() {
        ArrayList arrayList = new ArrayList();
        if ("1663".startsWith(this.snmpVendorId) || this.snmpVendorId.startsWith("42.2.28.3.4.1.1")) {
            this.qlogicDeepProbeHelper(arrayList);
        } else if ("1588".startsWith(this.snmpVendorId)) {
            this.brocadeDeepProbeHelper(arrayList);
        } else if ("289".startsWith(this.snmpVendorId)) {
            Properties properties = new Properties();
            properties.setProperty("snmp.ip", this.ip);
            properties.setProperty("timeout", "1000");
            properties.setProperty("snmp.ipno", this.ip);
            SwitchOOBProbe switchOOBProbe = new SwitchOOBProbe(properties);
            return switchOOBProbe.probe(properties).getDevices();
        }
        return arrayList;
    }

    private void qlogicDeepProbeHelper(ArrayList arrayList) {
        HashMap hashMap = new HashMap();
        SNMPWalk sNMPWalk = new SNMPWalk(this.ip, new FCMGMT_MIBOidTable());
        hashMap = sNMPWalk.getProperties("connUnitId", "connUnitGlobalId");
        hashMap = sNMPWalk.filterProperties(hashMap, QLC_FILTER);
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Properties properties = new Properties();
            String string2 = QLC_FILTER + this.snmpWWN;
            Map.Entry entry = iterator.next();
            String string3 = (String)entry.getValue();
            properties.setProperty("snmpEnterpriseID", "1663");
            if (string3 != null) {
                if (string3.length() > 16) {
                    string3 = string3.substring(0, 16);
                }
                if (string2.equalsIgnoreCase((String)entry.getKey())) {
                    properties.setProperty("ip", this.ip);
                    properties.setProperty("logicalName", this.ip);
                } else {
                    properties.setProperty("remoteIP", this.ip);
                    properties.setProperty("remoteDiscovery", "Yes");
                    properties.setProperty("logicalName", string3);
                }
                properties.setProperty(NAME, string3);
                properties.put("wwn", string3);
                string = SwitchWWNsnmp.hexToSnmpWWN(string3);
                string = string + "." + "0.0.0.0.0.0.0.0";
                if (this.fabricName != null) {
                    properties.put("FabricName", this.fabricName);
                }
                properties.put("wwnSnmp", string);
            }
            properties.setProperty("type", SWITCH);
            string = SwitchModel.getSwitchModel(this.snmpVendorId, this.switchType);
            SwitchEnhancedPropertyHelper.getExtraSwitchProperties(properties, string);
            arrayList.add(properties);
        }
    }

    private void brocadeDeepProbeHelper(ArrayList arrayList) {
        HashMap hashMap = new HashMap();
        SNMPWalk sNMPWalk = new SNMPWalk(this.ip, new SW_MIBOidTable());
        hashMap = sNMPWalk.getProperties("swFabricMemEIP", "swFabricMemFCIP");
        hashMap = sNMPWalk.filterProperties(hashMap, BRCD_FILTER);
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            SwitchOOBProbe switchOOBProbe = new SwitchOOBProbe(new Properties());
            Map.Entry entry = iterator.next();
            String string = (String)entry.getValue();
            Properties properties = new Properties();
            try {
                object = InetAddress.getByName(string);
                properties.setProperty("snmp.ipno", ((InetAddress)object).getHostAddress());
                properties.setProperty("snmp.ip", ((InetAddress)object).getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                properties.setProperty("snmp.ip", string);
                properties.setProperty("snmp.ipno", string);
            }
            properties.setProperty("timeout", "1000");
            object = switchOOBProbe.probe(properties).getDevices().iterator();
            while (object.hasNext()) {
                Properties properties2 = (Properties)object.next();
                arrayList.add(properties2);
            }
        }
    }

    public static void main(String[] stringArray) {
        SwitchProbeDeepHelper switchProbeDeepHelper = new SwitchProbeDeepHelper(stringArray[0]);
        Iterator iterator = switchProbeDeepHelper.doDeepProbe().iterator();
        while (iterator.hasNext()) {
            Properties properties = (Properties)iterator.next();
            properties.list(System.out);
        }
        System.exit(0);
    }

    public static class Test
    extends UnitTest {
        public void testSwProbeDeep() {
            SwitchProbeDeepHelper switchProbeDeepHelper = new SwitchProbeDeepHelper("1", "2", "3", "4", "5", "6");
            this.assertNotNull(switchProbeDeepHelper);
            Collection collection = switchProbeDeepHelper.doDeepProbe();
            this.assertCondition(collection.size() == 0);
        }

        public void testSwitchProbeDeep(String string) {
            SwitchProbeDeepHelper switchProbeDeepHelper = new SwitchProbeDeepHelper(string);
            Collection collection = switchProbeDeepHelper.doDeepProbe();
            this.assertEquals(new Integer(collection.size()), new Integer(2));
        }

        public static void main(String[] stringArray) {
            new Test().testSwitchProbeDeep(stringArray[0]);
        }
    }
}

