/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.service;

import com.sun.jade.device.fcswitch.fibrealliance.service.SwitchEnhancedPropertyHelper;
import com.sun.jade.device.fcswitch.fibrealliance.service.SwitchModel;
import com.sun.jade.device.fcswitch.fibrealliance.service.SwitchProbeDeepHelper;
import com.sun.jade.device.fcswitch.util.snmp.SwitchWWNsnmp;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.Probe;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.ProbeResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.SNMPProbe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class SwitchOOBProbe
implements Probe {
    private boolean deepProbe;
    private SwitchWWNsnmp switchWWN;
    private String wwn;
    private String snmpWWN;
    private String switchType;
    private String snmpVendorId;
    private static final String SNMP = "snmp.";
    private static final String DEEP = "deep";
    private static final String TRUE = "true";
    private static final String SYSTEM_NAME = "sysName";
    private static final String NAME = "name";
    private static final String SWITCH = "switch";
    private Properties probeProps;
    public static final String sccs_id = "@(#)SwitchOOBProbe.java\t1.12 12/01/03 SMI";

    public SwitchOOBProbe(Properties properties) {
        this.probeProps = properties;
    }

    public ProbeResult probe(Properties properties) {
        ArrayList arrayList = new ArrayList();
        String string = properties.getProperty("snmp.ip");
        String string2 = properties.getProperty("snmp.ipno");
        this.switchWWN = new SwitchWWNsnmp(string);
        this.wwn = this.switchWWN.getWWNString();
        this.snmpWWN = this.switchWWN.getWWNSnmp();
        this.switchType = this.switchWWN.getDeviceType();
        this.snmpVendorId = this.switchWWN.getVendorSNMPId();
        String string3 = this.switchWWN.getFabricName();
        if (this.snmpVendorId == null) {
            return new ProbeResult(this.probeProps, arrayList);
        }
        String string4 = properties.getProperty(DEEP);
        if (string4 != null && TRUE.equalsIgnoreCase(string4)) {
            this.deepProbe = true;
        }
        if (this.deepProbe) {
            SwitchProbeDeepHelper switchProbeDeepHelper = new SwitchProbeDeepHelper(string, this.wwn, this.snmpWWN, this.snmpVendorId, this.switchType, string3);
            arrayList = (ArrayList)switchProbeDeepHelper.doDeepProbe();
            return new ProbeResult(this.probeProps, (Collection)arrayList);
        }
        if ("1663".startsWith(this.snmpVendorId) || "1588".startsWith(this.snmpVendorId) || "289".startsWith(this.snmpVendorId) || "824".startsWith(this.snmpVendorId) || this.snmpVendorId.startsWith("42.2.28.3.4.1.1")) {
            Properties properties2 = new Properties();
            if (string != null) {
                properties2.setProperty("ip", string);
            }
            if (string2 != null) {
                properties2.setProperty("ipno", string2);
            }
            String string5 = properties.getProperty("snmp.sysName");
            properties2.setProperty("logicalName", string);
            properties2.setProperty("snmpEnterpriseID", this.snmpVendorId);
            if (this.wwn != null) {
                properties2.setProperty(NAME, this.wwn);
                properties2.put("wwn", this.wwn);
                properties2.put("wwnSnmp", this.switchWWN.getWWNSnmp());
            }
            if (string3 != null) {
                properties2.put("FabricName", string3);
            }
            properties2.setProperty("type", SWITCH);
            String string6 = SwitchModel.getSwitchModel(this.snmpVendorId, this.switchType);
            SwitchEnhancedPropertyHelper.getExtraSwitchProperties(properties2, string6);
            arrayList.add(properties2);
        }
        return new ProbeResult(this.probeProps, (Collection)arrayList);
    }

    public String getName() {
        return SWITCH;
    }

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        String string = stringArray[0];
        Properties properties2 = new Properties();
        properties2.setProperty("ip", string);
        properties2.setProperty("timeout", "1000");
        properties2.setProperty("ipno", string);
        if (stringArray.length == 2 && DEEP.equalsIgnoreCase(stringArray[1].trim())) {
            properties2.setProperty(DEEP, TRUE);
        }
        SNMPProbe sNMPProbe = new SNMPProbe();
        ProbeResult probeResult = sNMPProbe.probe(properties2);
        Properties properties3 = probeResult.getProbeProperties();
        SwitchOOBProbe switchOOBProbe = new SwitchOOBProbe(properties2);
        ProbeResult probeResult2 = switchOOBProbe.probe(properties2);
        Iterator iterator = probeResult2.getDevices().iterator();
        while (iterator.hasNext()) {
            Properties properties4 = (Properties)iterator.next();
            properties4.list(System.out);
        }
        System.exit(0);
    }

    public static class Test
    extends UnitTest {
        public void testSwProbe() {
            Properties properties = new Properties();
            SwitchOOBProbe switchOOBProbe = new SwitchOOBProbe(properties);
            this.assertEquals(switchOOBProbe.getName(), SwitchOOBProbe.SWITCH);
        }

        public void testSwitchProbe(String string) {
            Properties properties = new Properties();
            Properties properties2 = new Properties();
            properties2.setProperty("ip", string);
            properties2.setProperty("timeout", "1000");
            properties2.setProperty("ipno", string);
            SNMPProbe sNMPProbe = new SNMPProbe();
            ProbeResult probeResult = sNMPProbe.probe(properties2);
            Properties properties3 = probeResult.getProbeProperties();
            SwitchOOBProbe switchOOBProbe = new SwitchOOBProbe(properties2);
            ProbeResult probeResult2 = switchOOBProbe.probe(properties2);
            Iterator iterator = probeResult2.getDevices().iterator();
            while (iterator.hasNext()) {
                Properties properties4 = (Properties)iterator.next();
                this.assertEquals(properties4.getProperty("VENDOR"), "Sun");
                this.assertEquals(properties4.getProperty("ip"), string);
                this.assertEquals(properties4.getProperty("snmpEnterpriseID"), "1663");
            }
        }

        public static void main(String[] stringArray) {
            new Test().testSwitchProbe(stringArray[0]);
        }
    }
}

