/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.io;

import com.sun.jade.device.fcswitch.fibrealliance.io.AbstractSwitchDeviceReport;
import com.sun.jade.device.fcswitch.util.snmp.CIMStateStatusHelper;
import com.sun.jade.device.fcswitch.util.snmp.EF_6000_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.FE_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.FIBRE_CHANNEL_MGMT_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.McData_FA_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.PortSpeedHelper;
import com.sun.jade.device.fcswitch.util.snmp.PrincipalSwitchHelper;
import com.sun.jade.device.fcswitch.util.snmp.SNMPPortType;
import com.sun.jade.device.fcswitch.util.snmp.SNMPToCIM_State_Status;
import com.sun.jade.device.fcswitch.util.snmp.SNMPToString_State_Status;
import com.sun.jade.device.fcswitch.util.snmp.SNMPWalk;
import com.sun.jade.device.fcswitch.util.snmp.SwitchWWNsnmp;
import com.sun.jade.device.fcswitch.util.zones.ZoneInfo;
import com.sun.jade.device.fcswitch.util.zones.Zones;
import com.sun.jade.device.protocol.snmp.SingleSnmpSession;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.device.component.zoning.api.ZoningHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class McDataDeviceReport
extends AbstractSwitchDeviceReport {
    private Properties props;
    private static final String CIM_VERSION = "CIM 2.5";
    private String ip;
    private String wwn;
    private HashMap systemProps = null;
    private HashMap portStatProps = null;
    private HashMap portResult = null;
    private HashMap fa_sensorProps = null;
    private HashMap fa_systemProps = null;
    private HashMap fa_portStatus = null;
    private HashMap fe_portPhysical = null;
    private HashMap ef_revisionProps = null;
    private int portCount;
    private int moduleCount;
    private FE_Mibsnmp femibsnmp;
    private McData_FA_Mibsnmp mcdatamibsnmp;
    private EF_6000_Mibsnmp efmibsnmp;
    private static final String IP = "ip";
    private static final String WWN = "wwn";
    private static final String SYSTEM_VIEW = "SystemView";
    private static final String PORT_COUNT_ERROR_MESSAGE = "Error in getting Port Count";
    private static final String LOG_TAG = "McData_Device_Report";
    private static final String NUMBER_OF_MODULES = "fcFeModuleCapacity";
    private static final String PORTS_PER_MODULE = "fcFeModuleFxPortCapacity";
    private static final String DEFAULT_PORT_TYPE = "1";
    private static final String oidRec = "1.3.6.1.2.1.8888.1.1.8.1.3";
    private static final String SENSOR_COUNT_ERROR_MESSAGE = "Error getting the number of sensors.";
    private static final String SNMP_WWN = "wwnSnmp";
    private static final int TEN = 10;
    private static final String DOT = ".";
    private int noOfZones;
    private int noOfSensors;
    private static final String SENSOR_TYPE_FAN = "4";
    private static final String SENSOR_TYPE_POWER = "5";
    private Zones[] zones = null;
    private ZoningHelper zoneHelper;
    public static final String sccs_id = "@(#)McDataDeviceReport.java\t1.41 03/29/04 SMI";

    public McDataDeviceReport(Properties properties) {
        this(properties, null);
    }

    public McDataDeviceReport(Properties properties, ZoningHelper zoningHelper) {
        super(properties, zoningHelper);
        this.zoneHelper = zoningHelper;
        this.props = properties;
        this.ip = properties.getProperty(IP);
        this.wwn = properties.getProperty(WWN);
        try {
            this.portCount = Integer.parseInt(properties.getProperty("NumberOfPorts"));
            this.noOfSensors = Integer.parseInt(properties.getProperty("NumberOfSensors"));
        }
        catch (Exception exception) {
            this.portCount = 0;
            this.noOfSensors = 0;
        }
        this.mcdatamibsnmp = new McData_FA_Mibsnmp(this.props);
        this.efmibsnmp = new EF_6000_Mibsnmp(this.ip);
    }

    public synchronized String generateReport() {
        Object object;
        DeviceClass deviceClass = null;
        DeviceClass deviceClass2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        DeviceClass deviceClass3 = null;
        DeviceClass deviceClass4 = null;
        DeviceClass deviceClass5 = null;
        DeviceClass deviceClass6 = this.getReport();
        DeviceClass deviceClass7 = deviceClass6.newSubInstance();
        deviceClass7.setClassName("model");
        deviceClass7.setProperty("schema", CIM_VERSION);
        deviceClass7.setProperty("view", "system");
        deviceClass7.setProperty("type", "switch");
        deviceClass7.setProperty("prefix", "StorAdeSwitch");
        deviceClass7.setProperty("package", "com.sun.jade.cim.bean");
        Report.debug.log(LOG_TAG, (Object)("Filter 1.3.6.1.2.1.8888.1.1.8.1.3." + this.props.getProperty(SNMP_WWN)));
        this.discoverConnectedDevice("1.3.6.1.2.1.8888.1.1.8.1.3." + this.props.getProperty(SNMP_WWN));
        this.fa_systemProps = this.mcdatamibsnmp.getConnectivityProps();
        this.ef_revisionProps = this.efmibsnmp.getRevisionProps();
        DeviceClass deviceClass8 = deviceClass7.newSubInstance();
        deviceClass8.setClassName(SYSTEM_VIEW);
        if (this.portCount == 0) {
            this.portCount = this.getNumberOfPorts();
        }
        DeviceClass deviceClass9 = deviceClass8.newSubInstance();
        this.populateSwitchSystem(this.mcdatamibsnmp, deviceClass9);
        DeviceClass deviceClass10 = deviceClass9.newSubInstance();
        this.populatePhysicalPackage(this.efmibsnmp, deviceClass10);
        DeviceClass deviceClass11 = deviceClass9.newSubInstance();
        this.populateChassisDevice(this.mcdatamibsnmp, deviceClass11);
        if (this.portCount == 0) {
            return this.getReportError(new IllegalStateException(PORT_COUNT_ERROR_MESSAGE));
        }
        int n = 1;
        while (n <= this.portCount) {
            this.portStatProps = this.efmibsnmp.getPortProps(n + "");
            this.fa_portStatus = this.mcdatamibsnmp.getPortProps(n);
            deviceClass2 = deviceClass9.newSubInstance();
            this.populateFibrePort(this.efmibsnmp, deviceClass2, n);
            deviceClass = deviceClass2.newSubInstance();
            this.populateFibreCounters(this.efmibsnmp, deviceClass, n);
            deviceClass4 = deviceClass2.newSubInstance();
            this.populateProtocolEndPoint(this.mcdatamibsnmp, deviceClass4, n);
            object = this.portResult.entrySet();
            Iterator iterator = object.iterator();
            String string = null;
            int n2 = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string2 = (String)entry.getValue();
                try {
                    n2 = Integer.parseInt(string2, 10);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                if (n2 + 1 != n) continue;
                this.populateLogicalNetwork(deviceClass4, deviceClass3);
                deviceClass5 = deviceClass4.newSubInstance();
                string = (String)entry.getKey();
                int n3 = string.lastIndexOf(DOT);
                string = string.substring(n3);
                HashMap hashMap = this.mcdatamibsnmp.getMcDataLinkProps(string);
                String string3 = (String)hashMap.get("fcConnUnitLinkPortWwnY");
                if (string3 != null) {
                    string3 = string3.substring(0, 16);
                }
                deviceClass5.setClassName("ProtocolEndpoint");
                deviceClass5.setProperty("Name", string3);
                deviceClass5.setProperty("NameFormat", "WWN");
                deviceClass5.setProperty("ProtocolType", "18");
            }
            ++n;
        }
        try {
            this.addZoneData(deviceClass9, deviceClass7);
        }
        catch (Exception exception) {
            object = null;
            object = ZoneInfo.getMcDataZones(this.ip);
            this.addZoneData(deviceClass9, deviceClass7, (Object[])object);
        }
        return deviceClass6.toXML();
    }

    protected void populateFibrePort(EF_6000_Mibsnmp eF_6000_Mibsnmp, DeviceClass deviceClass, int n) {
        String string = null;
        deviceClass.setClassName("FibrePort");
        deviceClass.setProperty("SystemName", this.wwn);
        deviceClass.setProperty("REF", "" + (n - 1));
        deviceClass.setProperty("DeviceID", "" + (n - 1));
        string = this.getPortWWN(n);
        string = string == null ? "" : string;
        deviceClass.setProperty("Name", string);
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_FibrePort");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStateString((String)this.fa_portStatus.get("fcConnUnitPortState"))));
        deviceClass.setProperty("Availability", CIMStateStatusHelper.convertToCIMAvailability(SNMPToCIM_State_Status.getOperationalStateString((String)this.fa_portStatus.get("fcConnUnitPortState"))));
        deviceClass.setProperty("PowerManagementSupported", "false");
        string = (String)this.portStatProps.get("ef6000PortSigLosses");
        deviceClass.setProperty("LossOfSignalCounter", string == null ? "0" : string);
        string = (String)this.portStatProps.get("ef6000PortSyncLosses");
        deviceClass.setProperty("LossOfSyncCounter", string == null ? "0" : string);
        string = (String)this.portStatProps.get("ef6000PortCrcs");
        deviceClass.setProperty("CRCErrors", string == null ? "0" : string);
        string = (String)this.portStatProps.get("ef6000PortInvalidTxWords");
        deviceClass.setProperty("InvalidTransmissionWords", string == null ? "0" : string);
        deviceClass.setProperty("FramesTooShort", "0");
        deviceClass.setProperty("FramesTooLong", "0");
        string = (String)this.fa_portStatus.get("fcConnUnitPortType");
        deviceClass.setProperty("Type", string == null ? SNMPPortType.getPortTypeString(DEFAULT_PORT_TYPE) : SNMPPortType.getPortTypeString(string));
        deviceClass.setProperty("Description", string == null ? SNMPPortType.getPortTypeString(DEFAULT_PORT_TYPE) : SNMPPortType.getPortTypeString(string));
        string = (String)this.fa_portStatus.get("fcConnUnitPortSpeed");
        try {
            int n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            string = "0";
        }
        deviceClass.setProperty("Speed", string == null ? "0" : string);
        deviceClass.setProperty("PortOperatingSpeed", PortSpeedHelper.getPortSpeed(string));
        deviceClass.setProperty("OperatingStatus", SNMPToString_State_Status.getOperationalStateString((String)this.fa_portStatus.get("fcConnUnitPortState")));
        deviceClass.setProperty("AdministrativeStatus", SNMPToString_State_Status.getOperationalStatusString_FE((String)this.portStatProps.get("ef6000PortAdmStatus")));
    }

    protected void populateFibreCounters(EF_6000_Mibsnmp eF_6000_Mibsnmp, DeviceClass deviceClass, int n) {
        String string = null;
        deviceClass.setClassName("DeviceStatisticalInformation");
        deviceClass.setProperty("SystemName", this.wwn);
        deviceClass.setProperty("DeviceCreationClassName", "StorAdeSwitch_FibrePort");
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_FibrePortEventCounters");
        deviceClass.setProperty("DeviceID", "" + (n - 1));
        string = this.getPortWWN(n);
        string = string == null ? "" : string;
        deviceClass.setProperty("Name", string);
        string = (String)this.portStatProps.get("ef6000PortLinkFailures");
        if ("NULL".equalsIgnoreCase(string.trim())) {
            string = "0";
        }
        deviceClass.setProperty("LinkFails", string == null ? "0" : string);
        string = (String)this.portStatProps.get("ef6000PortProtocolErrors");
        if ("NULL".equalsIgnoreCase(string.trim())) {
            string = "0";
        }
        deviceClass.setProperty("Prim_Seq_Errs", string == null ? "0" : string);
    }

    protected void populateSwitchSystem(McData_FA_Mibsnmp mcData_FA_Mibsnmp, DeviceClass deviceClass) {
        deviceClass.setClassName("UnitaryComputerSystem");
        deviceClass.setProperty("Name", this.wwn);
        deviceClass.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStatusString((String)this.fa_systemProps.get("fcConnUnitStatus"))));
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        String string = this.props.getProperty("ipno");
        deviceClass.setProperty("OtherIdentifyingInfo", string == null ? this.ip : string);
        deviceClass.setProperty("IdentifyingDescriptions", "IPAddress");
        string = (String)this.ef_revisionProps.get("ef6000SysFirmwareVersion");
        deviceClass.setProperty("Flash", string == null ? "-" : string);
        deviceClass.setProperty("HW", "-");
        deviceClass.setProperty("MAC", "-");
        deviceClass.setProperty("PROM", "-");
        deviceClass.setProperty("PortCount", "" + this.getNumberOfPorts());
        deviceClass.setProperty("WWN", this.wwn);
        deviceClass.setProperty("ZoneTotal", this.noOfZones + "");
        string = (String)this.fa_systemProps.get("fcConnUnitPrincipal");
        if (string != null) {
            string = PrincipalSwitchHelper.get_FA_PrincipalSwitchAttr(string);
        }
        deviceClass.setProperty("PrincipalSwitch", string == null ? "Unknown" : string);
    }

    protected void populatePhysicalPackage(EF_6000_Mibsnmp eF_6000_Mibsnmp, DeviceClass deviceClass) {
        String string = null;
        deviceClass.setClassName("PhysicalPackage");
        deviceClass.setProperty("Tag", this.wwn);
        string = this.props.getProperty("DeviceDisplayModel");
        deviceClass.setProperty("Name", string == null ? "McData" : string);
        deviceClass.setProperty("Manufacturer", string == null ? "McData Enterprise Director FC Switch" : string);
        string = (String)this.ef_revisionProps.get("ef6000SysSerialNum");
        deviceClass.setProperty("SerialNumber", string == null ? "-" : string);
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_PhysicalPackage");
        deviceClass.setProperty("Removable", "true");
        deviceClass.setProperty("Replaceable", "true");
        deviceClass.setProperty("HotSwappable", "true");
    }

    protected void populateChassisDevice(McData_FA_Mibsnmp mcData_FA_Mibsnmp, DeviceClass deviceClass) {
        String string = null;
        deviceClass.setClassName("LogicalDevice");
        deviceClass.setProperty("SystemName", this.wwn);
        deviceClass.setProperty("DeviceID", "Chassis");
        deviceClass.setProperty("Name", "chassis");
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_ChassisDevice");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStatusString((String)this.fa_systemProps.get("fcConnUnitStatus"))));
        deviceClass.setProperty("Availability", CIMStateStatusHelper.convertToCIMAvailability(SNMPToCIM_State_Status.getOperationalStateString((String)this.fa_systemProps.get("fcConnUnitState"))));
        deviceClass.setProperty("Description", "McData Switch Chassis");
        deviceClass.setProperty("PowerManagementSupported", "false");
        string = mcData_FA_Mibsnmp.getSystemUpTimeString();
        deviceClass.setProperty("PowerOnTime", string == null ? "-" : string);
        deviceClass.setProperty("PowerOnSeconds", mcData_FA_Mibsnmp.getSystemUpTime() + "");
        if (this.noOfSensors == 0) {
            this.noOfSensors = this.getNumberOfSensors();
        }
        Report.debug.log(LOG_TAG, (Object)("Number of Sensors " + this.noOfSensors));
        int n = 1;
        while (n <= this.noOfSensors) {
            DeviceClass deviceClass2;
            this.fa_sensorProps = mcData_FA_Mibsnmp.getSensorProps(n);
            String string2 = (String)this.fa_sensorProps.get("fcConnUnitSensorType");
            if (SENSOR_TYPE_FAN.equalsIgnoreCase(string2)) {
                deviceClass2 = deviceClass.newSubInstance();
                deviceClass2.setClassName("Fan");
                deviceClass2.setProperty("SystemName", this.wwn);
                deviceClass2.setProperty("DeviceID", (String)this.fa_sensorProps.get("fcConnUnitSensorName"));
                deviceClass2.setProperty("Name", (String)this.fa_sensorProps.get("fcConnUnitSensorName"));
                deviceClass2.setProperty("CreationClassName", "CIM_Fan");
                deviceClass2.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
                deviceClass2.setProperty("Status", SNMPToCIM_State_Status.getOperationalStatusString((String)this.fa_sensorProps.get("fcConnUnitSensorStatus")));
            }
            if (SENSOR_TYPE_POWER.equalsIgnoreCase(string2)) {
                deviceClass2 = deviceClass.newSubInstance();
                deviceClass2.setClassName("PowerSupply");
                deviceClass2.setProperty("SystemName", this.wwn);
                deviceClass2.setProperty("DeviceID", (String)this.fa_sensorProps.get("fcConnUnitSensorName"));
                deviceClass2.setProperty("Name", (String)this.fa_sensorProps.get("fcConnUnitSensorName"));
                deviceClass2.setProperty("CreationClassName", "CIM_UninterruptiblePowerSupply");
                deviceClass2.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
                deviceClass2.setProperty("Status", SNMPToCIM_State_Status.getOperationalStatusString((String)this.fa_sensorProps.get("fcConnUnitSensorStatus")));
            }
            ++n;
        }
    }

    protected void populateLogicalNetwork(DeviceClass deviceClass, DeviceClass deviceClass2) {
        String string = this.props.getProperty("FabricName");
        deviceClass2 = deviceClass.newSubInstance();
        deviceClass2.setClassName("LogicalNetwork");
        deviceClass2.setProperty("Name", string);
        deviceClass2.setProperty("NetworkType", "18");
    }

    protected void populateProtocolEndPoint(McData_FA_Mibsnmp mcData_FA_Mibsnmp, DeviceClass deviceClass, int n) {
        String string = null;
        deviceClass.setClassName("ProtocolEndpoint");
        string = this.getPortWWN(n);
        string = string.substring(0, 16);
        deviceClass.setProperty("CreationClassName", "CIM_ProtocolEndpoint");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("SystemName", this.getWWN());
        deviceClass.setProperty("Name", string == null ? "" : string);
        deviceClass.setProperty("NameFormat", "WWN");
        deviceClass.setProperty("ProtocolType", "18");
    }

    protected DeviceClass getReport() {
        DeviceClass deviceClass = new DeviceClass();
        deviceClass.setClassName("report");
        deviceClass.setProperty("ReturnCode", "OK");
        return deviceClass;
    }

    protected String getReportError(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<report ReturnCode='FAILURE'>\n");
        stringBuffer.append("<exception Reason='Lost Comm'>");
        stringBuffer.append(exception.toString());
        stringBuffer.append("</exception>\n");
        stringBuffer.append("</report>\n");
        return stringBuffer.toString();
    }

    protected void discoverConnectedDevice(String string) {
        SNMPWalk sNMPWalk = new SNMPWalk(this.ip, new FIBRE_CHANNEL_MGMT_MIBOidTable());
        HashMap hashMap = new HashMap();
        hashMap = sNMPWalk.getProperties("fcConnUnitLinkPortNumberX", "fcConnUnitLinkPortWwnX");
        this.portResult = sNMPWalk.filterProperties(hashMap, string);
        Report.debug.log(LOG_TAG, (Object)("CONNECTED PORTS" + this.portResult));
    }

    private int getNumberOfSensors() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.fa_systemProps.get("fcConnUnitNumSensors"));
        }
        catch (NumberFormatException numberFormatException) {
            Report.warning.log((Object)SENSOR_COUNT_ERROR_MESSAGE);
            return n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws Exception {
        Properties properties = new Properties();
        int n = 1;
        if (stringArray.length < 1) {
            System.out.println("Usage: java McDataDeviceReport <ipAddress> <noTimes>");
        }
        try {
            try {
                properties.put(IP, stringArray[0]);
                SwitchWWNsnmp switchWWNsnmp = new SwitchWWNsnmp(stringArray[0]);
                String string = switchWWNsnmp.getWWNString();
                String string2 = switchWWNsnmp.getWWNSnmp();
                String string3 = switchWWNsnmp.getFabricName();
                properties.put("FabricName", string3);
                properties.put(WWN, string);
                properties.put(SNMP_WWN, string2);
                try {
                    n = Integer.parseInt(stringArray[1]);
                }
                catch (Exception exception) {
                    n = 1;
                }
                int n2 = 0;
                while (n2 < n) {
                    if (n > 1) {
                        Thread.sleep(300000L);
                    }
                    McDataDeviceReport mcDataDeviceReport = new McDataDeviceReport(properties);
                    FileOutputStream fileOutputStream = new FileOutputStream(new File("/tmp/" + stringArray[0] + ".xml." + n2));
                    PrintStream printStream = new PrintStream(fileOutputStream);
                    printStream.println(mcDataDeviceReport.generateReport());
                    ++n2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var12_14 = null;
                SingleSnmpSession.destroySnmpSession();
                SingleSnmpSession.destroyAsyncSnmpSession();
                return;
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            SingleSnmpSession.destroySnmpSession();
            SingleSnmpSession.destroyAsyncSnmpSession();
            throw throwable;
        }
        SingleSnmpSession.destroySnmpSession();
        SingleSnmpSession.destroyAsyncSnmpSession();
    }

    protected String getPortWWN(int n) {
        String string = (String)this.fa_portStatus.get("fcConnUnitPortWwn");
        if (string == null) {
            String string2 = Integer.toHexString(n + 3);
            string = this.computePortWWN(string2);
        }
        try {
            if (string != null && string.length() > 16) {
                string = string.substring(0, 16);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return string;
    }

    private String computePortWWN(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.wwn);
        stringBuffer.setCharAt(0, '2');
        if (string.length() > 1) {
            stringBuffer.setCharAt(2, string.charAt(0));
            stringBuffer.setCharAt(3, string.charAt(1));
            return stringBuffer.toString();
        }
        stringBuffer.setCharAt(3, string.charAt(0));
        return stringBuffer.toString();
    }

    private int getNumberOfPorts() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.fa_systemProps.get("fcConnUnitNumPorts"));
        }
        catch (NumberFormatException numberFormatException) {
            Report.warning.log((Object)SENSOR_COUNT_ERROR_MESSAGE);
            return n;
        }
        return n;
    }

    public static class Test
    extends UnitTest {
        public void testMcDataReportGenerator(String string) {
            Properties properties = new Properties();
            properties.put(McDataDeviceReport.IP, string);
            SwitchWWNsnmp switchWWNsnmp = new SwitchWWNsnmp(string);
            String string2 = switchWWNsnmp.getWWNString();
            properties.put(McDataDeviceReport.WWN, string2);
            McDataDeviceReport mcDataDeviceReport = new McDataDeviceReport(properties);
            String string3 = new SwitchWWNsnmp(properties.getProperty(McDataDeviceReport.IP)).getWWNString();
            this.assertNotNull(string3);
            this.assertNotNull(mcDataDeviceReport.generateReport());
        }

        public static void main(String[] stringArray) {
            new Test().testMcDataReportGenerator(stringArray[0]);
        }
    }
}

