/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.io;

import com.sun.jade.device.fcswitch.util.zones.ZoneHelperZoneInfo;
import com.sun.jade.device.fcswitch.util.zones.ZoneSets;
import com.sun.jade.device.fcswitch.util.zones.Zones;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.log.Report;
import com.sun.netstorage.mgmt.esm.logic.device.component.zoning.api.ZoningHelper;
import java.util.Properties;

public abstract class AbstractSwitchDeviceReport
implements ReportGenerator {
    private Properties props;
    private ZoningHelper zoneHelper;
    private String wwn;
    private String password;
    private String ip;
    private static final String LOG_TAG = "Abstract_Switch_Device_Report";
    public static final String sccs_id = "@(#)AbstractSwitchDeviceReport.java 1.4     04/02/20 SMI";

    protected AbstractSwitchDeviceReport(Properties properties) {
        this.props = properties;
        this.wwn = properties.getProperty("wwn");
    }

    protected AbstractSwitchDeviceReport(Properties properties, ZoningHelper zoningHelper) {
        this.props = properties;
        this.zoneHelper = zoningHelper;
        this.wwn = properties.getProperty("wwn");
    }

    protected String getWWN() {
        return this.wwn;
    }

    protected Properties getProps() {
        return this.props;
    }

    protected String getFabricName() {
        String string = null;
        Properties properties = this.getProps();
        if (properties != null) {
            string = properties.getProperty("FabricName");
        }
        return string;
    }

    public abstract String generateReport();

    protected void addZoneData(DeviceClass deviceClass, DeviceClass deviceClass2) throws Exception {
        String string;
        ZoneSets[] zoneSetsArray = null;
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        if (this.zoneHelper == null) {
            new IllegalStateException("Null reference to zone helper ");
        }
        if ((string = this.getFabricName()) != null && !string.equalsIgnoreCase(this.getWWN())) {
            return;
        }
        ZoneHelperZoneInfo zoneHelperZoneInfo = new ZoneHelperZoneInfo(this.zoneHelper);
        objectArray2 = zoneHelperZoneInfo.getZoneSets();
        if (objectArray2 != null) {
            int n = objectArray2.length;
            if (n != 0) {
                Report.debug.log(LOG_TAG, (Object)("Number of Zone Sets " + n));
                zoneSetsArray = new ZoneSets[n];
                int n2 = 0;
                while (n2 < n) {
                    DeviceClass deviceClass3 = deviceClass.newSubInstance();
                    zoneSetsArray[n2] = (ZoneSets)objectArray2[n2];
                    this.populateZoneSet(deviceClass3, zoneSetsArray[n2]);
                    objectArray = zoneSetsArray[n2].getZones();
                    this.addZoneData(deviceClass3, deviceClass2, objectArray);
                    ++n2;
                }
            }
        } else {
            objectArray = zoneHelperZoneInfo.getZones();
            this.addZoneData(deviceClass, deviceClass2, objectArray);
        }
    }

    protected void addZoneData(DeviceClass deviceClass, DeviceClass deviceClass2, Object[] objectArray) {
        Zones[] zonesArray = null;
        int n = objectArray.length;
        Report.debug.log(LOG_TAG, (Object)("Number of Zones " + n));
        zonesArray = new Zones[n];
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                zonesArray[n2] = (Zones)objectArray[n2];
                DeviceClass deviceClass3 = deviceClass.newSubInstance();
                this.populateZones(deviceClass3, zonesArray[n2]);
                this.populateZoneMember(deviceClass2, zonesArray[n2]);
                ++n2;
            }
        }
    }

    protected void populateZones(DeviceClass deviceClass, Zones zones) {
        deviceClass.setClassName("Zone");
        deviceClass.setProperty("REF", zones.getZoneName().trim());
        deviceClass.setProperty("InstanceID", zones.getZoneName().trim());
        deviceClass.setProperty("ElementName", zones.getZoneName());
        deviceClass.setProperty("OtherZoneTypeDescription", zones.getZoneDescription());
        deviceClass.setProperty("Active", "true");
        deviceClass.setProperty("ProtocolType", "1");
    }

    protected void populateZoneMember(DeviceClass deviceClass, Zones zones) {
        Object[] objectArray = zones.getMemberList();
        if (objectArray.length > 0) {
            DeviceClass deviceClass2 = deviceClass.newSubInstance();
            deviceClass2.setClassName("ZoneMember");
            deviceClass2.setProperty("ZoneMemberType", "5");
            DeviceClass deviceClass3 = deviceClass2.newSubInstance();
            deviceClass3.setClassName("Collection");
            deviceClass3.setProperty("REF", zones.getZoneName().trim());
            int n = 0;
            while (n < objectArray.length) {
                String string = ((String)objectArray[n]).trim();
                if (string != null) {
                    DeviceClass deviceClass4 = deviceClass2.newSubInstance();
                    deviceClass4.setClassName("Member");
                    if (string.length() == 16) {
                        this.addWWNZoneMember(deviceClass4, string);
                    } else {
                        deviceClass4.setProperty("REF", string);
                    }
                }
                ++n;
            }
        }
    }

    private void addWWNZoneMember(DeviceClass deviceClass, String string) {
        deviceClass.setProperty("CreationClassName", "CIM_ProtocolEndpoint");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("SystemName", this.wwn);
        deviceClass.setProperty("Name", string);
        deviceClass.setProperty("NameFormat", "WWN");
        deviceClass.setProperty("ProtocolType", "18");
        deviceClass.setAlias("ProtocolEndPoint");
    }

    private DeviceClass populateZoneSet(DeviceClass deviceClass, ZoneSets zoneSets) {
        deviceClass.setClassName("ZoneSet");
        deviceClass.setProperty("REF", zoneSets.getZoneSetName().trim());
        deviceClass.setProperty("InstanceID", zoneSets.getZoneSetName().trim());
        deviceClass.setProperty("ElementName", zoneSets.getZoneSetName());
        if (zoneSets.isActive()) {
            deviceClass.setProperty("Active", "true");
        } else {
            deviceClass.setProperty("Active", "false");
        }
        return deviceClass;
    }
}

