/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.util.tracing;

import com.sun.netstorage.mgmt.component.trace.StackTrace;
import java.util.logging.Level;
import org.jini.project.component.TraceFacility;

public class ESMTracer {
    TraceFacility.TraceOut traceOut;

    public ESMTracer(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = this.getClass();
        }
        Package package_ = clazz.getPackage();
        this.traceOut = TraceFacility.Singleton.get().getTracer(package_);
    }

    public boolean isSevere() {
        return this.isLoggable(Level.SEVERE);
    }

    public boolean isWarning() {
        return this.isLoggable(Level.WARNING);
    }

    public boolean isInfo() {
        return this.isLoggable(Level.INFO);
    }

    public boolean isConfig() {
        return this.isLoggable(Level.CONFIG);
    }

    public boolean isFine() {
        return this.isLoggable(Level.FINE);
    }

    public boolean isFiner() {
        return this.isLoggable(Level.FINER);
    }

    public boolean isFinest() {
        return this.isLoggable(Level.FINEST);
    }

    public boolean isLoggable(Level level) {
        return true;
    }

    public void severeESM(Object object, String string) {
        if (this.isSevere()) {
            this.log(object, Level.SEVERE, string);
        }
    }

    public void warningESM(Object object, String string) {
        if (this.isWarning()) {
            this.log(object, Level.WARNING, string);
        }
    }

    public void infoESM(Object object, String string) {
        if (this.isInfo()) {
            this.log(object, Level.INFO, string);
        }
    }

    public void configESM(Object object, String string) {
        if (this.isConfig()) {
            this.log(object, Level.CONFIG, string);
        }
    }

    public void fineESM(Object object, String string) {
        if (this.isFine()) {
            this.log(object, Level.FINE, string);
        }
    }

    public void finerESM(Object object, String string) {
        if (this.isFiner()) {
            this.log(object, Level.FINER, string);
        }
    }

    public void finestESM(Object object, String string) {
        if (this.isFinest()) {
            this.log(object, Level.FINEST, string);
        }
    }

    public void exceptionESM(Object object, Level level, String string, Throwable throwable) {
        this.log(object, level, string, throwable);
    }

    public void entering(Object object) {
        if (this.isFiner()) {
            this.log(object, Level.FINER, "ENTRY");
        }
    }

    public void exiting(Object object) {
        if (this.isFiner()) {
            this.log(object, Level.FINER, "RETURN");
        }
    }

    private void log(Object object, Level level, String string) {
        String[] stringArray = this.getClassMethodNames(object);
        String string2 = " <" + stringArray[0] + ">";
        String string3 = " <" + stringArray[1] + ">";
        this.traceOut.trace(level, string2, string3, ":" + Thread.currentThread().getName() + ": " + string);
    }

    private void log(Object object, Level level, String string, Throwable throwable) {
        String[] stringArray = this.getClassMethodNames(object);
        String string2 = " <" + stringArray[0] + ">";
        String string3 = " <" + stringArray[1] + ">";
        String string4 = ",StackTrace=" + StackTrace.asString((Throwable)throwable);
        this.traceOut.trace(level, string2, string3, ":" + Thread.currentThread().getName() + ": " + string + string4);
    }

    private String[] getClassMethodNames(Object object) {
        String[] stringArray;
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        String string = null;
        string = object instanceof Class ? ((Class)object).getName() : object.getClass().getName();
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            stringArray = stackTraceElementArray[n2].getClassName();
            if (stringArray.equals(string)) {
                string2 = stackTraceElementArray[n2].getMethodName();
                break;
            }
            ++n2;
        }
        stringArray = new String[]{string, string2};
        return stringArray;
    }
}

