/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.util.result;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ESMResult
implements Serializable {
    public static final ESMResult SUCCESS = new ESMResult("S_SUCCESS", true);
    public static final ESMResult FAILED = new ESMResult("F_FAILED", true);
    public static final ESMResult NO_ESM_BASE = new ESMResult("W_NO_ESM_BASE", true);
    public static final ESMResult TRUE = new ESMResult("S_TRUE", true);
    public static final ESMResult FALSE = new ESMResult("S_FALSE", true);
    public static final char SEV_SUCCESS = 'S';
    public static final char SEV_INFORMATION = 'I';
    public static final char SEV_WARNING = 'W';
    public static final char SEV_FAILED = 'F';
    public static final char SEV_UNKNOWN = '?';
    private String key;
    private String bundle;
    private boolean useDefaultBundleInPackage = false;
    private boolean logged = false;
    private boolean immutable = false;
    private static final String DEFAULT_PACKAGE_PREFIX = "com.sun.netstorage.mgmt";
    static final String DEFAULT_BUNDLE_DIRECTORY = "resources";
    static final String DEFAULT_BUNDLE_ROOTNAME = "Status";

    public static char severity(String string) {
        ESMResult eSMResult = new ESMResult(string);
        return eSMResult.getSeverity();
    }

    public static String key(String string) {
        ESMResult eSMResult = new ESMResult(string);
        return eSMResult.getKey();
    }

    public static String bundleName(String string) {
        ESMResult eSMResult = new ESMResult(string);
        return eSMResult.getBundleName();
    }

    protected ESMResult() {
    }

    public ESMResult(String string, String string2) {
        this.bundle = new String(string);
        this.key = new String(string2);
        this.useDefaultBundleInPackage = false;
    }

    public ESMResult(String string, String string2, boolean bl) {
        this(string, string2);
        this.immutable = bl;
    }

    public ESMResult(String string, boolean bl) {
        this(string);
        this.immutable = bl;
    }

    public ESMResult(String string) {
        if (string == null) {
            return;
        }
        int n = string.indexOf(58);
        if (n != -1) {
            this.useDefaultBundleInPackage = false;
            if (n > 0) {
                this.bundle = string.substring(0, n);
            }
            if (n >= 0 && n + 1 < string.length()) {
                this.key = string.substring(n + 1);
            }
        } else {
            this.useDefaultBundleInPackage = true;
            int n2 = string.lastIndexOf(46) + 1;
            if (n2 < string.length()) {
                this.key = string.substring(n2);
            }
            if (n2 > 1) {
                this.bundle = string.substring(0, n2);
            }
        }
    }

    public String getKey() {
        if (this.key != null && this.key.length() != 0) {
            return this.key;
        }
        return this.getClass().getName();
    }

    public char getSeverity() {
        String string = this.getKey();
        if (string.length() > 1 && string.charAt(1) == '_') {
            return string.charAt(0);
        }
        return '?';
    }

    public String getBundleName() {
        StringBuffer stringBuffer = new StringBuffer(this.getBundlePackage());
        if (this.useDefaultBundleInPackage) {
            int n = stringBuffer.length() - 2;
            if (stringBuffer.charAt(n + 1) != '.') {
                stringBuffer.append(".");
                ++n;
            }
            int n2 = stringBuffer.lastIndexOf(".", n) + 1;
            String string = stringBuffer.substring(n2, n + 1);
            stringBuffer.append(DEFAULT_BUNDLE_DIRECTORY);
            stringBuffer.append(".");
            stringBuffer.append(string);
            stringBuffer.append(this.getBundleRootName());
        }
        return stringBuffer.toString();
    }

    public String getStatusString() {
        String string = this.getBundlePackage();
        if (string.startsWith(DEFAULT_PACKAGE_PREFIX)) {
            string = string.substring(DEFAULT_PACKAGE_PREFIX.length());
        }
        if (this.useDefaultBundleInPackage) {
            return new String(string + this.getKey());
        }
        return new String(string + ":" + this.getKey());
    }

    public String toString() {
        return this.getLocalizedMessage();
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault(), null, null);
    }

    public String getLocalizedMessage(Locale locale) {
        return this.getLocalizedMessage(locale, null, null);
    }

    protected String getLocalizedMessage(Object[] objectArray) {
        return this.getLocalizedMessage(Locale.getDefault(), objectArray, null);
    }

    protected String getLocalizedMessage(Locale locale, Object[] objectArray, String[] stringArray) {
        String string;
        block5: {
            ResourceBundle resourceBundle = null;
            string = null;
            String string2 = this.getKey();
            String string3 = this.getAlternateKey();
            try {
                resourceBundle = ResourceBundle.getBundle(this.getBundleName(), locale);
                string = string3 != null ? resourceBundle.getString(string3) : resourceBundle.getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                if (resourceBundle == null || string3 == null) break block5;
                try {
                    string = resourceBundle.getString(string2);
                }
                catch (MissingResourceException missingResourceException2) {
                    // empty catch block
                }
            }
        }
        if (string != null) {
            return MessageFormat.format(string, objectArray);
        }
        return this.getUnlocalizedMessage(objectArray, stringArray);
    }

    public String getDebugMessage() {
        return this.getDebugMessage(null, null);
    }

    public String getDebugMessage(Object[] objectArray, String[] stringArray) {
        return this.getLocalizedMessage(Locale.ENGLISH, objectArray, stringArray);
    }

    public String getUnlocalizedMessage(Object[] objectArray, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(this.getKey());
        stringBuffer.append(" - Bundle: " + this.getBundleName());
        if (objectArray != null && objectArray.length > 0) {
            stringBuffer.append(" - ");
            stringBuffer.append(this.dumpArguments(objectArray, stringArray));
        }
        return stringBuffer.toString();
    }

    public void setLogged() {
        if (this.immutable) {
            return;
        }
        this.logged = true;
    }

    public boolean getLogged() {
        return this.logged;
    }

    public boolean equals(Object object) {
        if (object instanceof ESMResult) {
            ESMResult eSMResult = (ESMResult)object;
            return this.getKey().equals(eSMResult.getKey()) && this.getBundleName().equals(eSMResult.getBundleName());
        }
        return false;
    }

    private String getBundlePackage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bundle != null && this.bundle.length() != 0) {
            if (this.bundle.startsWith(".")) {
                stringBuffer.append(DEFAULT_PACKAGE_PREFIX);
            }
            stringBuffer.append(this.bundle);
        } else {
            Package package_ = this.getClass().getPackage();
            if (package_ != null) {
                stringBuffer.append(package_.getName());
                stringBuffer.append(".");
                this.useDefaultBundleInPackage = true;
            } else {
                stringBuffer.append(DEFAULT_BUNDLE_DIRECTORY);
                stringBuffer.append(".");
                stringBuffer.append(DEFAULT_BUNDLE_ROOTNAME);
            }
        }
        return stringBuffer.toString();
    }

    private String dumpArguments(Object[] objectArray, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("Args: ");
        int n = 0;
        while (n < objectArray.length) {
            stringBuffer.append("[ ");
            if (stringArray != null && stringArray.length > n) {
                stringBuffer.append(stringArray[n]);
            } else {
                stringBuffer.append("arg " + n);
            }
            stringBuffer.append(" = ");
            if (objectArray[n] instanceof ESMResult) {
                stringBuffer.append(((ESMResult)objectArray[n]).getDebugMessage());
            } else {
                stringBuffer.append(objectArray[n]);
            }
            stringBuffer.append(" ]");
            ++n;
        }
        return stringBuffer.toString();
    }

    protected String getBundleRootName() {
        return DEFAULT_BUNDLE_ROOTNAME;
    }

    public String getAlternateKey() {
        return null;
    }

    public Object[] getArgs() {
        Object[] objectArray = new Object[]{};
        return objectArray;
    }
}

