/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.util.logging;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class AuditLogger
extends Logger
implements PropertyChangeListener {
    private static AuditLogger logger = null;
    private static FileHandler handler = null;
    private static String auditFilename = null;
    private static SimpleFormatter formatter = null;
    private static LogManager lm = null;
    public static final String DEFAULT_FILE_PATTERN = "%t/esm_audit%u.log";
    public static final int DEFAULT_FILE_COUNT = 5;
    public static final String LOGGER_NAME = "com.sun.netstorage.mgmt.util.logging.AuditLogger";
    public static final String AUDIT_FILE_NAME_PROP = "com.sun.netstorage.mgmt.util.logging.AuditLogger.FileHandler.pattern";
    public static final String AUDIT_LEVEL_PROP = "com.sun.netstorage.mgmt.util.logging.AuditLogger.level";
    public static final String AUDIT_FILE_LIMIT_PROP = "com.sun.netstorage.mgmt.util.logging.AuditLogger.FileHandler.limit";
    public static final String AUDIT_FILE_COUNT_PROP = "com.sun.netstorage.mgmt.util.logging.AuditLogger.FileHandler.count";
    public static final String AUDIT_FILE_APPEND_PROP = "com.sun.netstorage.mgmt.util.logging.AuditLogger.FileHandler.append";

    private AuditLogger() {
        super(LOGGER_NAME, null);
        this.setUseParentHandlers(false);
        lm = LogManager.getLogManager();
        String string = lm.getProperty(AUDIT_FILE_NAME_PROP);
        String string2 = lm.getProperty(AUDIT_FILE_LIMIT_PROP);
        String string3 = lm.getProperty(AUDIT_FILE_COUNT_PROP);
        String string4 = lm.getProperty(AUDIT_FILE_APPEND_PROP);
        String string5 = lm.getProperty(AUDIT_LEVEL_PROP);
        this.createFileHandler(string, string2, string3, string4);
        if (handler != null) {
            this.addHandler(handler);
        } else {
            System.err.println("ERROR: Configuring the AuditLogger");
        }
        lm.addLogger(this);
        this.checkSetLevel(string5);
    }

    public static synchronized AuditLogger getAuditLogger() {
        if (logger == null) {
            logger = new AuditLogger();
            lm.addPropertyChangeListener(logger);
        }
        return logger;
    }

    private void createFileHandler(String string, String string2, String string3, String string4) {
        Object var5_5 = null;
        boolean bl = false;
        boolean bl2 = false;
        auditFilename = "";
        if (string != null) {
            auditFilename = string.trim();
        }
        if (auditFilename.length() == 0) {
            auditFilename = DEFAULT_FILE_PATTERN;
        }
        if (string4 != null) {
            string4 = string4.trim();
            bl2 = true;
            Boolean bl3 = new Boolean(string4);
            bl = bl3;
        }
        int n = 0;
        try {
            if (string2 != null && (n = Integer.parseInt(string2)) < 0) {
                n = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n2 = 5;
        try {
            if (string3 != null && (n2 = Integer.parseInt(string3)) < 1) {
                n2 = 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            handler = bl2 ? new FileHandler(auditFilename, n, n2, bl) : new FileHandler(auditFilename, n, n2);
            handler.setLevel(Level.ALL);
            if (formatter == null) {
                formatter = new SimpleFormatter();
            }
            handler.setFormatter(formatter);
        }
        catch (Exception exception) {
            System.err.println("ERROR: Creating AuditLoggger FileHandler");
            exception.printStackTrace(System.err);
            handler = null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfig() {
        AuditLogger auditLogger = logger;
        synchronized (auditLogger) {
            try {
                LogManager logManager = LogManager.getLogManager();
                String string = logManager.getProperty(AUDIT_FILE_NAME_PROP);
                String string2 = logManager.getProperty(AUDIT_FILE_LIMIT_PROP);
                String string3 = logManager.getProperty(AUDIT_FILE_COUNT_PROP);
                String string4 = logManager.getProperty(AUDIT_FILE_APPEND_PROP);
                String string5 = logManager.getProperty(AUDIT_LEVEL_PROP);
                logger.createFileHandler(string, string2, string3, string4);
                Handler[] handlerArray = logger.getHandlers();
                logger.addHandler(handler);
                int n = 0;
                while (n < handlerArray.length) {
                    logger.removeHandler(handlerArray[n]);
                    ++n;
                }
                logger.checkSetLevel(string5);
            }
            catch (SecurityException securityException) {
                System.err.println("ERROR: SecurityException updating the tracing configuration.");
                securityException.printStackTrace(System.err);
            }
        }
    }

    private void checkSetLevel(String string) {
        try {
            Level level = Level.parse(string);
        }
        catch (Exception exception) {
            this.setLevel(Level.INFO);
        }
    }
}

