/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.rmi;

import java.lang.reflect.Array;
import java.lang.reflect.Method;

public final class MethodSignature {
    private MethodSignature() {
    }

    public static String methodToSignature(Method method) {
        return MethodSignature.methodToSignature(method.getReturnType(), method.getParameterTypes(), method.getName());
    }

    public static Method signatureToMethod(String string, Class clazz) throws NoSuchMethodException, ClassNotFoundException {
        return clazz.getMethod(MethodSignature.signatureToMethodName(string), MethodSignature.signatureToArgs(string));
    }

    private static String signatureToMethodName(String string) {
        return string.substring(0, string.indexOf(40));
    }

    private static Class[] signatureToArgs(String string) throws ClassNotFoundException {
        return MethodSignature.argumentSignatureToClasses(string.substring(string.indexOf(40) + 1, string.indexOf(41)));
    }

    private static String methodToSignature(Class clazz, Class[] classArray, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('(');
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(MethodSignature.getTypeDescriptor(classArray[n]));
            ++n;
        }
        stringBuffer.append(')');
        stringBuffer.append(MethodSignature.getTypeDescriptor(clazz));
        return stringBuffer.toString();
    }

    private static String getTypeDescriptor(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        while (clazz.isArray()) {
            stringBuffer.append('[');
            clazz = clazz.getComponentType();
        }
        if (clazz.equals(Byte.TYPE)) {
            stringBuffer.append('B');
        } else if (clazz.equals(Short.TYPE)) {
            stringBuffer.append('S');
        } else if (clazz.equals(Integer.TYPE)) {
            stringBuffer.append('I');
        } else if (clazz.equals(Long.TYPE)) {
            stringBuffer.append('J');
        } else if (clazz.equals(Float.TYPE)) {
            stringBuffer.append('F');
        } else if (clazz.equals(Double.TYPE)) {
            stringBuffer.append('D');
        } else if (clazz.equals(Character.TYPE)) {
            stringBuffer.append('C');
        } else if (clazz.equals(Boolean.TYPE)) {
            stringBuffer.append('Z');
        } else if (clazz.equals(Void.TYPE)) {
            stringBuffer.append('V');
        } else {
            stringBuffer.append("L");
            stringBuffer.append(clazz.getName());
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }

    private static Class[] argumentSignatureToClasses(String string) throws ClassNotFoundException {
        if (string == null || string.length() == 0) {
            return new Class[0];
        }
        Class[] classArray = new Class[string.length()];
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = 0;
            while (string.charAt(n2) == '[') {
                ++n3;
                ++n2;
            }
            switch (string.charAt(n2)) {
                case 'B': {
                    classArray[n] = Byte.TYPE;
                    break;
                }
                case 'C': {
                    classArray[n] = Character.TYPE;
                    break;
                }
                case 'S': {
                    classArray[n] = Short.TYPE;
                    break;
                }
                case 'I': {
                    classArray[n] = Integer.TYPE;
                    break;
                }
                case 'J': {
                    classArray[n] = Long.TYPE;
                    break;
                }
                case 'F': {
                    classArray[n] = Float.TYPE;
                    break;
                }
                case 'D': {
                    classArray[n] = Double.TYPE;
                    break;
                }
                case 'Z': {
                    classArray[n] = Boolean.TYPE;
                    break;
                }
                case 'L': {
                    String string2 = string.substring(n2 + 1, string.indexOf(59, n2));
                    classArray[n] = Class.forName(string2, true, Thread.currentThread().getContextClassLoader());
                    n2 += string2.length() + 1;
                }
            }
            if (n3 > 0) {
                classArray[n] = Array.newInstance(classArray[n], new int[n3]).getClass();
            }
            ++n2;
            ++n;
        }
        Class[] classArray2 = new Class[n];
        System.arraycopy(classArray, 0, classArray2, 0, classArray2.length);
        return classArray2;
    }
}

