/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.strings;

import com.sun.netstorage.mgmt.esm.util.l10n.properties.Name;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.strings.StringLengthException;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.strings.StringValueConstraint;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.strings.StringValueException;

public final class StringLength
extends StringValueConstraint {
    private static final String SCCS_ID = "@(#)StringLength.java 1.2   03/04/07 SMI";
    private final boolean myNullValid;
    private final int myMinLen;
    private final int myMaxLen;

    public StringLength(Name name, int n, boolean bl, int n2) {
        super(name);
        this.myMinLen = n;
        this.myNullValid = bl;
        this.myMaxLen = n2;
    }

    public StringLength(Name name, boolean bl, int n) {
        this(name, -1, bl, n);
    }

    public StringLength(Name name, int n, boolean bl) {
        this(name, n, bl, Integer.MAX_VALUE);
    }

    public boolean isNullValid(String string) {
        boolean bl = true;
        if (string == null && !this.myNullValid) {
            bl = false;
        }
        return bl;
    }

    private void validateNull(String string) throws StringValueException {
        if (!this.isNullValid(string)) {
            throw new StringValueException.IsNull(this);
        }
    }

    public int getMinLen() {
        return this.myMinLen;
    }

    private boolean isMinLenValid(String string) {
        boolean bl = true;
        if (string != null && string.length() < this.myMinLen) {
            bl = false;
        }
        return bl;
    }

    private void validateMinLen(String string) throws StringLengthException {
        if (!this.isMinLenValid(string)) {
            throw new StringLengthException.LessThanMin(this, string, this.myMinLen);
        }
    }

    public int getMaxLen() {
        return this.myMaxLen;
    }

    private boolean isMaxLenValid(String string) {
        boolean bl = true;
        if (string != null && string.length() > this.myMaxLen) {
            bl = false;
        }
        return bl;
    }

    private void validateMaxLen(String string) throws StringLengthException {
        if (!this.isMaxLenValid(string)) {
            throw new StringLengthException.GreaterThanMax(this, string, this.myMaxLen);
        }
    }

    public boolean isValueValid(String string) {
        return this.isNullValid(string) && this.isMinLenValid(string) && this.isMaxLenValid(string);
    }

    public void validateValue(String string) throws StringValueException {
        this.validateNull(string);
        this.validateMinLen(string);
        this.validateMaxLen(string);
    }
}

