/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.l10n.properties;

import com.sun.netstorage.mgmt.esm.util.l10n.properties.BasicValue;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class FormattableValue
extends BasicValue {
    private static final String SCCS_ID = "@(#)FormattableValue.java 1.2   03/04/07 SMI";
    private final Format myFormatter;

    private FormattableValue(Object object, Format format) {
        super(object);
        this.myFormatter = format;
    }

    public FormattableValue(Calendar calendar, DateFormat dateFormat) {
        this((Object)calendar, (Format)dateFormat);
    }

    public FormattableValue(Date date, DateFormat dateFormat) {
        this((Object)date, (Format)dateFormat);
    }

    public FormattableValue(Number number, NumberFormat numberFormat) {
        this((Object)number, (Format)numberFormat);
    }

    private String getFormattedValue(Locale locale, Calendar calendar) {
        Date date = calendar != null ? calendar.getTime() : null;
        return this.getFormattedValue(locale, date);
    }

    private String getFormattedValue(Locale locale, Date date) {
        Format format = this.myFormatter != null ? this.myFormatter : DateFormat.getDateTimeInstance(0, 0, locale);
        return format.format(date);
    }

    private String getFormattedValue(Locale locale, Number number) {
        Format format = this.myFormatter != null ? this.myFormatter : NumberFormat.getInstance(locale);
        return format.format(number);
    }

    public String getLocalizedValue(Locale locale) {
        Object object = this.getCanonicalValue();
        String string = null;
        if (object instanceof Calendar) {
            string = this.getFormattedValue(locale, (Calendar)object);
        } else if (object instanceof Date) {
            string = this.getFormattedValue(locale, (Date)object);
        } else if (object instanceof Number) {
            string = this.getFormattedValue(locale, (Number)object);
        }
        return string;
    }
}

