/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.l10n.doclet;

import com.sun.netstorage.mgmt.esm.util.l10n.doclet.ResourceWriter;

public abstract class JavaTypeWriter
extends ResourceWriter {
    public static final String JAVA_TYPE_FILE_SUFFIX = ".java";
    public static final String BUNDLE_NAME_CONSTANT = "RESOURCE_BUNDLE_NAME";
    public static final String DEFAULT_TRINKET_PREFIX = "KEY_";
    public static final String DEFAULT_RESOURCE_PREFIX = "RES_";
    public static final String DEFAULT_FORMATTER_PREFIX = "FMT_";
    public static final String COMMENT_BEGIN = "/**";
    public static final String COMMENT_CONT = " *";
    public static final String COMMENT_END = "**/";
    public static final String COMMENT_INDENT = "    ";
    private boolean myInterface = true;
    private boolean myFinal = false;
    private boolean myAbstract = false;

    public static String getBundleKeysInterface(String string) {
        return string + "Keys";
    }

    public JavaTypeWriter(String string, String string2, String string3) {
        super(string, string2, string3, JAVA_TYPE_FILE_SUFFIX, COMMENT_BEGIN, COMMENT_CONT, COMMENT_END, COMMENT_INDENT);
    }

    protected final void setInterface() {
        this.myInterface = true;
    }

    protected final void setClass() {
        this.myInterface = false;
    }

    protected final void setFinal() {
        this.myFinal = true;
    }

    protected final void setAbstract() {
        this.myAbstract = true;
    }

    protected abstract void printTypeJavadoc();

    protected abstract void printTypeBegin();

    protected final void see(String string) {
        this.printCommentContinue();
        this.getOutput().print(" @see ");
        this.getOutput().println(string);
    }

    protected final void see(String string, String string2) {
        this.printCommentContinue();
        this.getOutput().print(" @see <a href=\"");
        this.getOutput().print(string);
        this.getOutput().println("\">");
        this.printCommentContinue();
        this.getOutput().print("      ");
        this.getOutput().print(string2);
        this.getOutput().println("</a>");
    }

    protected void printPackage() {
        this.getOutput().print("package ");
        this.getOutput().print(this.getPackageName());
        this.getOutput().println(";");
        this.getOutput().println();
    }

    protected void printImports() {
    }

    protected void printTypeModifiers() {
        if (this.myFinal) {
            this.getOutput().print("final ");
        } else if (this.myAbstract) {
            this.getOutput().print("abstract ");
        }
    }

    protected String getTypeName() {
        return this.getBundleName();
    }

    protected void printTypeEnd() {
        this.printCloseBrace(0);
    }

    protected void printOpenBrace(int n) {
        if (n > 0) {
            this.printIndent(n);
        }
        this.getOutput().println('{');
    }

    protected void printCloseBrace(int n) {
        if (n > 0) {
            this.printIndent(n);
        }
        this.getOutput().println('}');
    }

    private void printTypeBegin(String string, boolean bl) {
        String string2 = bl ? "class" : "interface";
        this.printTypeModifiers();
        this.getOutput().println("public");
        this.getOutput().print(string2);
        this.getOutput().print(" ");
        this.getOutput().println(string);
    }

    private void printExtends(String string, boolean bl) {
        if (string != null) {
            this.getOutput().print("extends ");
            this.getOutput().println(string);
        }
    }

    private void printRealizes(String[] stringArray, boolean bl) {
        if (stringArray != null && stringArray.length > 0) {
            String string = bl ? "implements" : "extends";
            this.getOutput().print(string);
            this.getOutput().print(" ");
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    this.getOutput().print(", ");
                }
                this.getOutput().print(stringArray[n]);
                ++n;
            }
            this.getOutput().println();
        }
    }

    protected void printInterfaceBegin() {
        this.printInterfaceBegin(this.getTypeName());
    }

    protected void printInterfaceBegin(String string) {
        this.printInterfaceBegin(string, null);
    }

    protected void printInterfaceBegin(String string, String[] stringArray) {
        this.printTypeBegin(string, false);
        this.printRealizes(stringArray, false);
        this.printOpenBrace(0);
    }

    protected void printClassBegin() {
        this.printClassBegin(this.getTypeName(), null, null);
    }

    protected void printClassBegin(String string, String string2, String[] stringArray) {
        this.printTypeBegin(string, true);
        this.printExtends(string2, true);
        this.printRealizes(stringArray, true);
        this.printOpenBrace(0);
    }

    protected final String toTrinketConstant(String string) {
        return DEFAULT_TRINKET_PREFIX + this.toConstantIdentifier(string);
    }

    protected final String toResourceConstant(String string) {
        return DEFAULT_RESOURCE_PREFIX + this.toConstantIdentifier(string);
    }

    protected final String toFormatterConstant(String string) {
        return DEFAULT_FORMATTER_PREFIX + this.toConstantIdentifier(string);
    }

    protected final String toConstantIdentifier(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isUpperCase(c)) {
                if (bl) {
                    stringBuffer.append('_');
                }
                stringBuffer.append(c);
                bl = false;
            } else if (Character.isLowerCase(c)) {
                c = Character.toUpperCase(c);
                stringBuffer.append(c);
                bl = true;
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected final void printBundleNameConstant() {
        this.printIndent(1);
        this.printlnCommentBegin();
        this.printIndent(1);
        this.printCommentContinue();
        this.getOutput().println(" Defines the resource bundle name for this package.");
        this.printIndent(1);
        this.printlnCommentEnd();
        if (!this.myInterface) {
            this.printIndent(1);
            this.getOutput().println("static public final");
        }
        this.printIndent(1);
        this.getOutput().print("String ");
        this.getOutput().print(BUNDLE_NAME_CONSTANT);
        this.getOutput().print(" = ");
        this.getOutput().print(this.getBundleName());
        this.getOutput().println(".class.getName();");
    }

    protected final void printVersionConstant() {
        this.printIndent(1);
        this.printlnCommentBegin();
        this.printIndent(1);
        this.printCommentContinue();
        this.getOutput().println(" Version information.");
        this.printIndent(1);
        this.printlnCommentEnd();
        if (!this.myInterface) {
            this.printIndent(1);
            this.getOutput().println("static private final");
        }
        this.printIndent(1);
        this.getOutput().print("String SCCS_ID = \"");
        this.getOutput().print("%Z");
        this.getOutput().print("%%M");
        this.getOutput().print("% %I");
        this.getOutput().print("%   %E");
        this.getOutput().print("% SMI");
        this.getOutput().println("\";");
    }

    protected final void separateClassConstants() {
        this.printClassSectionSeparator("Class Constants");
    }

    protected final void separateClassAttributes() {
        this.printClassSectionSeparator("Class Attributes");
    }

    protected final void separateClassProperties() {
        this.printClassSectionSeparator("Class Properties");
    }

    protected final void separateClassProperty(String string) {
        this.printClassPropertySeparator(string + " Property");
    }

    protected final void separateClassOperations() {
        this.printClassSectionSeparator("Class Operations");
    }

    protected final void separateInstanceConstructors() {
        this.printInstanceSectionSeparator("Instance Constructors");
    }

    protected final void separateInstanceAttributes() {
        this.printInstanceSectionSeparator("Instance Attributes");
    }

    protected final void separateInstanceProperties() {
        this.printInstanceSectionSeparator("Instance Properties");
    }

    protected final void separateInstanceOperations() {
        this.printInstanceSectionSeparator("Instance Operations");
    }

    protected final void separateInstanceInterface(String string) {
        this.printInstanceSectionSeparator(string + " Interface");
    }

    protected final void separateInstanceOverrides(String string) {
        this.printInstanceSectionSeparator(string + " Overrides");
    }

    private void printClassSectionSeparator(String string) {
        this.printSeparator(string, false, false);
    }

    private void printClassPropertySeparator(String string) {
        this.printSeparator(string, false, true);
    }

    private void printInstanceSectionSeparator(String string) {
        this.printSeparator(string, true, false);
    }

    private void printInstancePropertySeparator(String string) {
        this.printSeparator(string, true, true);
    }

    private void printSeparator(String string, boolean bl, boolean bl2) {
        char c = bl ? (char)'-' : '=';
        char c2 = bl ? (char)'.' : ':';
        char c3 = bl2 ? c2 : c;
        int n = 10;
        int n2 = 4;
        int n3 = 27 - n2;
        int n4 = string.length();
        int n5 = 80 - n - n2 - n3 - n4;
        this.printIndent(1);
        this.getOutput().print("//");
        this.printDelim(c3, n3);
        this.getOutput().print("<< ");
        this.getOutput().print(string);
        this.getOutput().print(" >>");
        this.printDelim(c3, n5);
        this.getOutput().println("//");
    }

    private void printDelim(char c, int n) {
        int n2 = 0;
        while (n2 < n) {
            this.getOutput().print(c);
            ++n2;
        }
    }

    protected void header() {
        super.header();
        this.printPackage();
        this.printImports();
        this.printTypeJavadoc();
        this.printTypeBegin();
    }

    protected void footer() {
        this.printTypeEnd();
    }

    protected void section(String string) {
        this.setSection(string);
        this.getOutput().println();
        this.printClassSectionSeparator(string + " Resources");
        this.getOutput().println();
    }
}

