/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.l10n;

import com.sun.netstorage.mgmt.esm.util.l10n.Contract;
import com.sun.netstorage.mgmt.esm.util.l10n.Localizable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Resource
implements Localizable,
Serializable {
    private static final String SCCS_ID = "@(#)Resource.java 1.10   03/10/29 SMI";
    static final long serialVersionUID = 2174042368817074248L;
    private final String myResourceBundleName;
    private final String myMessageKey;
    private final String myLiteralText;

    public static Resource getConstant(String string) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException, ClassCastException {
        Contract.requires(string != null, "theConstantName != null");
        Resource resource = null;
        try {
            int n = string.lastIndexOf(".");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            Class<?> clazz = Class.forName(string2);
            Field field = clazz.getField(string3);
            resource = (Resource)field.get(null);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Error error) {}
        return resource;
    }

    private static final String getClassName(Class clazz) {
        Contract.requires(clazz != null, "theBundleInterface != null");
        return clazz.getName();
    }

    public Resource(String string, String string2, String string3) {
        Contract.requires(string != null, "theResourceBundleName != null");
        Contract.requires(string2 != null, "theMessageKey != null");
        Contract.requires(string3 != null, "theLiteralText != null");
        this.myResourceBundleName = string;
        this.myMessageKey = string2;
        this.myLiteralText = string3;
    }

    public Resource(Class clazz, String string, String string2) {
        this(Resource.getClassName(clazz), string, string2);
    }

    public final String getResourceBundleName() {
        return this.myResourceBundleName;
    }

    public final boolean hasResourceBundle(Locale locale) {
        return this.getResourceBundle(locale) != null;
    }

    public final PropertyResourceBundle getResourceBundle(Locale locale) {
        PropertyResourceBundle propertyResourceBundle = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            propertyResourceBundle = (PropertyResourceBundle)ResourceBundle.getBundle(this.myResourceBundleName, locale);
        }
        catch (MissingResourceException missingResourceException) {}
        return propertyResourceBundle;
    }

    public final PropertyResourceBundle getResourceBundle() {
        return this.getResourceBundle(Locale.getDefault());
    }

    public final PropertyResourceBundle getResourceBundleFallback() {
        return this.getResourceBundle(Locale.ENGLISH);
    }

    public final String getMessageKey() {
        return this.myMessageKey;
    }

    public final String getLiteralText() {
        return this.myLiteralText;
    }

    public String toString(Locale locale) {
        String string = this.getLocalizedText(locale);
        if (string == null) {
            string = this.getLiteralText();
        }
        Contract.ensures(string != null, "String != null");
        return string;
    }

    public final String getLocalizedText() {
        return this.getLocalizedText(Locale.getDefault());
    }

    public final String getLocalizedText(Locale locale) {
        String string;
        block3: {
            string = null;
            PropertyResourceBundle propertyResourceBundle = this.getResourceBundle(locale);
            if (propertyResourceBundle == null) {
                propertyResourceBundle = this.getResourceBundleFallback();
            }
            if (propertyResourceBundle == null) break block3;
            try {
                string = propertyResourceBundle.getString(this.myMessageKey);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return string;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            boolean bl2 = this.getResourceBundleName().equals(resource.getResourceBundleName());
            boolean bl3 = this.getMessageKey().equals(resource.getMessageKey());
            if (bl2 && bl3) {
                bl = true;
            }
        }
        return bl;
    }

    public int hashCode() {
        return this.getLiteralText().hashCode();
    }

    public String toString() {
        String string = this.getLocalizedText();
        if (string == null) {
            string = this.getLiteralText();
        }
        return string;
    }
}

