/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.javadoc.taglets;

import com.sun.javadoc.Tag;
import com.sun.netstorage.mgmt.esm.util.javadoc.taglets.AbstractTaglet;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;

public class ContractTaglet
extends AbstractTaglet {
    private static final String SCCS_ID = "@(#)ContractTaglet.java 1.6   03/09/22 SMI";
    public static final String SPECIFICATION_TITLE = "Specification";
    public static final String PRE_CONDITION_TITLE = "Pre-Condition";
    public static final String INVARIANT_CONDITION_TITLE = "Invariant";
    public static final String POST_CONDITION_TITLE = "Post-Condition";
    public static final String[][] CONDITION_TAGLETS = new String[][]{{"requires", "Pre-Condition"}, {"pre", "Pre-Condition"}, {"precondition", "Pre-Condition"}, {"guarantees", "Invariant"}, {"inv", "Invariant"}, {"invariant", "Invariant"}, {"ensures", "Post-Condition"}, {"post", "Post-Condition"}, {"postcondition", "Post-Condition"}};
    public static final String TITLE_COLOR_PROPERTY = "ContractTaglet.title.color";
    public static final String TITLE_COLOR_DEFAULT = "red";
    private final boolean mySpecification;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$util$dbc$DesignByContract;

    public static String getTitleColorProperty() {
        return System.getProperty(TITLE_COLOR_PROPERTY, TITLE_COLOR_DEFAULT);
    }

    public static void register(Map map) {
        AbstractTaglet.register(map, new ContractTaglet());
        int n = 0;
        while (n < CONDITION_TAGLETS.length) {
            String[] stringArray = CONDITION_TAGLETS[n];
            AbstractTaglet.register(map, new ContractTaglet(stringArray[0], stringArray[1]));
            ++n;
        }
    }

    private static Class getExceptionClass(Class clazz, String string) {
        Class clazz2 = class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = ContractTaglet.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException;
        try {
            Field field = clazz.getField(string);
            Object object = field.get(null);
            if (object instanceof Class) {
                clazz2 = (Class)object;
            }
        }
        catch (Exception exception) {}
        return clazz2;
    }

    public static Class getPreExceptionClass(Class clazz) {
        return ContractTaglet.getExceptionClass(clazz, "PRE_EXCEPTION");
    }

    public static Class getPostExceptionClass(Class clazz) {
        return ContractTaglet.getExceptionClass(clazz, "POST_EXCEPTION");
    }

    public static Class getInvExceptionClass(Class clazz) {
        return ContractTaglet.getExceptionClass(clazz, "INV_EXCEPTION");
    }

    protected ContractTaglet() {
        super("contract", SPECIFICATION_TITLE, false);
        this.mySpecification = true;
        this.setHeaderColor(ContractTaglet.getTitleColorProperty());
        this.getTagScopes().getPackageScope().setTagAllowed(true);
        this.getTagScopes().getTypeScope().setTagAllowed(true);
    }

    protected ContractTaglet(String string, String string2) {
        super(string, string2, false);
        this.mySpecification = false;
        this.setHeaderColor(ContractTaglet.getTitleColorProperty());
        this.getTagScopes().getConstructorScope().setTagAllowed(true);
        this.getTagScopes().getMethodScope().setTagAllowed(true);
    }

    private String markupSpecification(Tag tag) {
        Class clazz;
        StringBuffer stringBuffer = new StringBuffer();
        String string = tag.text();
        Class<?> clazz2 = null;
        Class clazz3 = clazz = class$com$sun$netstorage$mgmt$esm$util$dbc$DesignByContract == null ? (class$com$sun$netstorage$mgmt$esm$util$dbc$DesignByContract = ContractTaglet.class$("com.sun.netstorage.mgmt.esm.util.dbc.DesignByContract")) : class$com$sun$netstorage$mgmt$esm$util$dbc$DesignByContract;
        if (string.indexOf("DesignByContract") > -1) {
            clazz = class$com$sun$netstorage$mgmt$esm$util$dbc$DesignByContract == null ? (class$com$sun$netstorage$mgmt$esm$util$dbc$DesignByContract = ContractTaglet.class$("com.sun.netstorage.mgmt.esm.util.dbc.DesignByContract")) : class$com$sun$netstorage$mgmt$esm$util$dbc$DesignByContract;
        } else {
            try {
                String string2 = string.trim();
                clazz2 = Class.forName(string2);
                if (clazz2 != null) {
                    clazz = clazz2.getSuperclass();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = class$com$sun$netstorage$mgmt$esm$util$dbc$DesignByContract == null ? (class$com$sun$netstorage$mgmt$esm$util$dbc$DesignByContract = ContractTaglet.class$("com.sun.netstorage.mgmt.esm.util.dbc.DesignByContract")) : class$com$sun$netstorage$mgmt$esm$util$dbc$DesignByContract;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        stringBuffer.append("<em>Design by Contract</em> is specified for this type.\n");
        stringBuffer.append("The <b>Contract Summary</b> table describes the utility classes\n");
        stringBuffer.append("and the exception classes that are specified by the contract.\n");
        stringBuffer.append("<p>\n");
        stringBuffer.append("</dd>\n");
        stringBuffer.append("<dt>\n");
        stringBuffer.append("<a NAME=\"contract_summary\"><!-- --></a>\n");
        stringBuffer.append("<table border=1 cellpadding=3 cellspacing=0 width=100%>\n");
        stringBuffer.append("<tr BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n");
        stringBuffer.append("<td COLSPAN=2><font SIZE=\"+2\">\n");
        stringBuffer.append("<b>Contract Summary</b></font></td>\n");
        stringBuffer.append("</tr>\n");
        if (clazz2 != null) {
            int n = clazz2.getModifiers();
            String string3 = Modifier.isPublic(n) ? "Contract.html" : null;
            stringBuffer.append(this.markupSummaryRow(clazz2, string3, "Package contract utility class."));
        }
        stringBuffer.append(this.markupSummaryRow(clazz, null, "Base contract utility class."));
        stringBuffer.append(this.markupSummaryPre(clazz));
        stringBuffer.append(this.markupSummaryPost(clazz));
        stringBuffer.append(this.markupSummaryInv(clazz));
        stringBuffer.append("</table>\n");
        stringBuffer.append("&nbsp;\n");
        stringBuffer.append("</dt>\n");
        stringBuffer.append("<dd>");
        return stringBuffer.toString();
    }

    private String markupSummaryRow(Class clazz, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = clazz.getName();
        stringBuffer.append("<tr BGCOLOR=\"white\" CLASS=\"TableRowColor\">\n");
        stringBuffer.append("<td>\n");
        stringBuffer.append("<code>\n");
        if (string != null) {
            stringBuffer.append("<a HREF=\"");
            stringBuffer.append(string);
            stringBuffer.append("\">");
        }
        stringBuffer.append(string3);
        if (string != null) {
            stringBuffer.append("</a>");
        }
        stringBuffer.append("</code>\n");
        stringBuffer.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        stringBuffer.append(string2);
        stringBuffer.append("</td>\n");
        stringBuffer.append("</tr>\n");
        return stringBuffer.toString();
    }

    private String markupSummaryPre(Class clazz) {
        Class clazz2 = ContractTaglet.getPreExceptionClass(clazz);
        return this.markupSummaryRow(clazz2, null, this.markupSummaryText(PRE_CONDITION_TITLE));
    }

    private String markupSummaryPost(Class clazz) {
        Class clazz2 = ContractTaglet.getPostExceptionClass(clazz);
        return this.markupSummaryRow(clazz2, null, this.markupSummaryText(POST_CONDITION_TITLE));
    }

    private String markupSummaryInv(Class clazz) {
        Class clazz2 = ContractTaglet.getInvExceptionClass(clazz);
        return this.markupSummaryRow(clazz2, null, this.markupSummaryText("Invariant-Condition"));
    }

    private String markupSummaryText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Exception thrown for ");
        if (this.hasHeaderColor()) {
            stringBuffer.append("<font color=\"");
            stringBuffer.append(this.getHeaderColor());
            stringBuffer.append("\">");
        }
        stringBuffer.append("Contract ");
        stringBuffer.append(string);
        if (this.hasHeaderColor()) {
            stringBuffer.append("</font>");
        }
        stringBuffer.append(" violations.");
        return stringBuffer.toString();
    }

    public void buildHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Contract ");
        stringBuffer.append(this.getTitle());
        stringBuffer.append(":");
        this.setHeader(stringBuffer.toString());
    }

    protected String markupTags(Tag[] tagArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mySpecification) {
            if (tagArray != null && tagArray.length > 0) {
                Tag tag = tagArray[0];
                stringBuffer.append(this.markupSpecification(tag));
            }
        } else {
            stringBuffer.append("<code>");
            stringBuffer.append(super.markupTags(tagArray));
            stringBuffer.append("</code>");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

