/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.crypto.pbe;

import com.sun.netstorage.mgmt.esm.util.crypto.pbe.PBEException;
import com.sun.netstorage.mgmt.esm.util.crypto.pbe.PBERuntimeException;
import java.lang.reflect.Constructor;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public abstract class AbstractPBE {
    private static final String SCCS_ID = "@(#)AbstractPBE.java 1.5   03/04/07 SMI";
    public static final String PBE_PROVIDER = "com.sun.crypto.provider.SunJCE";
    private static final String PBE_ALGORITHM = "PBEWithMD5AndDES";
    private static final char[] PBE_PASS_PHRASE = (class$com$sun$netstorage$mgmt$esm$util$crypto$pbe$AbstractPBE == null ? (class$com$sun$netstorage$mgmt$esm$util$crypto$pbe$AbstractPBE = AbstractPBE.class$("com.sun.netstorage.mgmt.esm.util.crypto.pbe.AbstractPBE")) : class$com$sun$netstorage$mgmt$esm$util$crypto$pbe$AbstractPBE).getName().toCharArray();
    private static final byte[] PBE_SALT = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
    private static final int PBE_COUNT = 23;
    private boolean initCompleted = false;
    private Cipher myCipher = null;
    private SecretKey mySecretKey = null;
    private SecretKeyFactory myKeyFactory = null;
    private PBEParameterSpec myParameterSpec = null;
    private char[] myPassPhrase = null;
    private byte[] mySalt = null;
    private int myCount = 23;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$util$crypto$pbe$AbstractPBE;
    static /* synthetic */ Class class$javax$crypto$Cipher;
    static /* synthetic */ Class class$javax$crypto$SecretKey;
    static /* synthetic */ Class class$javax$crypto$SecretKeyFactory;

    protected static void addProvider() {
        Class[] classArray = new Class[]{};
        Object[] objectArray = new Object[]{};
        try {
            String string = PBE_PROVIDER;
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object obj = constructor.newInstance(objectArray);
            if (obj != null && obj instanceof Provider) {
                Provider provider = (Provider)obj;
                Security.addProvider(provider);
            }
        }
        catch (Throwable throwable) {}
    }

    protected AbstractPBE(char[] cArray, byte[] byArray, int n) {
        this.myPassPhrase = cArray;
        this.mySalt = byArray;
        this.myCount = n;
    }

    protected AbstractPBE(char[] cArray) {
        this(cArray, PBE_SALT, 23);
    }

    protected AbstractPBE() {
        this(PBE_PASS_PHRASE, PBE_SALT, 23);
    }

    private Cipher getCipher() throws PBEException {
        if (this.myCipher == null) {
            try {
                this.myCipher = Cipher.getInstance(PBE_ALGORITHM);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PBEException.WrapNoSuchAlgorithmException(noSuchAlgorithmException, class$javax$crypto$Cipher == null ? (class$javax$crypto$Cipher = AbstractPBE.class$("javax.crypto.Cipher")) : class$javax$crypto$Cipher);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new PBEException.WrapNoSuchPaddingException(noSuchPaddingException, class$javax$crypto$Cipher == null ? (class$javax$crypto$Cipher = AbstractPBE.class$("javax.crypto.Cipher")) : class$javax$crypto$Cipher);
            }
        }
        return this.myCipher;
    }

    protected final Cipher getEncrypter() throws PBEException {
        if (this.getCipher() != null) {
            this.initCipher(1);
        }
        return this.myCipher;
    }

    protected final Cipher getDecrypter() throws PBEException {
        if (this.getCipher() != null) {
            this.initCipher(2);
        }
        return this.myCipher;
    }

    private void initCipher(int n) throws PBEException {
        try {
            this.myCipher.init(n, (Key)this.getSecretKey(), this.getParameterSpec());
            this.initCompleted = true;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PBEException.WrapInvalidKeyException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new PBEException.WrapInvalidAlgorithmParameterException(invalidAlgorithmParameterException);
        }
    }

    private SecretKey getSecretKey() throws PBEException {
        if (this.mySecretKey == null) {
            try {
                PBEKeySpec pBEKeySpec = new PBEKeySpec(this.getPassPhrase());
                this.mySecretKey = this.getKeyFactory().generateSecret(pBEKeySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new PBEException.WrapInvalidKeySpecException(invalidKeySpecException, class$javax$crypto$SecretKey == null ? (class$javax$crypto$SecretKey = AbstractPBE.class$("javax.crypto.SecretKey")) : class$javax$crypto$SecretKey);
            }
            catch (NullPointerException nullPointerException) {
                throw new PBEException.NullSecretKeyFactoryException();
            }
        }
        return this.mySecretKey;
    }

    private SecretKeyFactory getKeyFactory() throws PBEException {
        if (this.myKeyFactory == null) {
            try {
                this.myKeyFactory = SecretKeyFactory.getInstance(PBE_ALGORITHM);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PBEException.WrapNoSuchAlgorithmException(noSuchAlgorithmException, class$javax$crypto$SecretKeyFactory == null ? (class$javax$crypto$SecretKeyFactory = AbstractPBE.class$("javax.crypto.SecretKeyFactory")) : class$javax$crypto$SecretKeyFactory);
            }
        }
        return this.myKeyFactory;
    }

    private PBEParameterSpec getParameterSpec() {
        if (this.myParameterSpec == null) {
            this.myParameterSpec = new PBEParameterSpec(this.getSalt(), this.getCount());
        }
        return this.myParameterSpec;
    }

    protected final char[] getPassPhrase() {
        if (this.myPassPhrase == null) {
            this.myPassPhrase = PBE_PASS_PHRASE;
        }
        return this.myPassPhrase;
    }

    protected final void setPassPhrase(char[] cArray) {
        this.checkSetterState();
        this.myPassPhrase = cArray;
    }

    protected final void setPassPhrase(String string) {
        if (string != null) {
            this.setPassPhrase(string.toCharArray());
        }
    }

    protected final byte[] getSalt() {
        if (this.mySalt == null) {
            this.mySalt = PBE_SALT;
        }
        return this.mySalt;
    }

    protected final void setSalt(byte[] byArray) {
        this.checkSetterState();
        this.mySalt = byArray;
    }

    protected final void setSalt(String string) {
        if (string != null) {
            this.setSalt(string.getBytes());
        }
    }

    protected final int getCount() {
        return this.myCount;
    }

    protected final void setCount(int n) {
        this.checkSetterState();
        this.myCount = n;
    }

    private void checkSetterState() {
        if (this.initCompleted) {
            throw new PBERuntimeException.SetNotAllowedAfterInitException();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        AbstractPBE.addProvider();
    }
}

