/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.crypto;

import com.sun.netstorage.mgmt.esm.util.crypto.SerializablePasswordAuthentication;
import com.sun.netstorage.mgmt.esm.util.crypto.pbe.AbstractPBE;
import com.sun.netstorage.mgmt.esm.util.crypto.pbe.PBEException;
import java.io.IOException;
import java.net.PasswordAuthentication;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SealedObject;

public final class SealedPasswordAuthentication
extends AbstractPBE {
    public static final String SCCS_ID = "@(#)SealedPasswordAuthentication.java 1.2   03/04/07 SMI";
    private static final String SOURCE_AND_TARGET_NULL = "mySource == null && myTarget == null";
    private static final String UNKNOWN_UNSEALED_TYPE = "unsealed object is not instanceof PasswordAuthentication";
    private static final char[] BUFFER = (class$com$sun$netstorage$mgmt$esm$util$crypto$SealedPasswordAuthentication == null ? (class$com$sun$netstorage$mgmt$esm$util$crypto$SealedPasswordAuthentication = SealedPasswordAuthentication.class$("com.sun.netstorage.mgmt.esm.util.crypto.SealedPasswordAuthentication")) : class$com$sun$netstorage$mgmt$esm$util$crypto$SealedPasswordAuthentication).getName().toCharArray();
    private PasswordAuthentication mySource = null;
    private SealedObject myTarget = null;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$util$crypto$SealedPasswordAuthentication;
    static /* synthetic */ Class class$javax$crypto$SealedObject;

    public SealedPasswordAuthentication(PasswordAuthentication passwordAuthentication, char[] cArray) {
        super(cArray);
        this.mySource = passwordAuthentication;
    }

    public SealedPasswordAuthentication(SealedObject sealedObject, char[] cArray) {
        super(cArray);
        this.myTarget = sealedObject;
    }

    public SealedPasswordAuthentication(PasswordAuthentication passwordAuthentication) {
        this(passwordAuthentication, BUFFER);
    }

    public SealedPasswordAuthentication(SealedObject sealedObject) {
        this(sealedObject, BUFFER);
    }

    private void initSource() throws PBEException {
        if (this.myTarget != null) {
            Cipher cipher = this.getDecrypter();
            try {
                Object object = this.myTarget.getObject(cipher);
                if (!(object instanceof SerializablePasswordAuthentication)) {
                    if (object != null) {
                        throw new UnknownTargetTypeException(object.getClass());
                    }
                    throw new UnknownTargetTypeException(null);
                }
                SerializablePasswordAuthentication serializablePasswordAuthentication = (SerializablePasswordAuthentication)object;
                this.mySource = serializablePasswordAuthentication.toPasswordAuthentication();
            }
            catch (IOException iOException) {
                throw new TargetDeserializationException(iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new TargetDeserializationException(classNotFoundException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new PBEException.WrapIllegalBlockSizeException(illegalBlockSizeException, class$javax$crypto$SealedObject == null ? (class$javax$crypto$SealedObject = SealedPasswordAuthentication.class$("javax.crypto.SealedObject")) : class$javax$crypto$SealedObject);
            }
            catch (BadPaddingException badPaddingException) {
                throw new PBEException.WrapBadPaddingException(badPaddingException, class$javax$crypto$SealedObject == null ? (class$javax$crypto$SealedObject = SealedPasswordAuthentication.class$("javax.crypto.SealedObject")) : class$javax$crypto$SealedObject);
            }
        } else {
            throw new NullSourceAndTargetException();
        }
    }

    public final PasswordAuthentication getSource() throws PBEException {
        if (this.mySource == null) {
            this.initSource();
        }
        return this.mySource;
    }

    private SerializablePasswordAuthentication getSerializableSource() {
        return new SerializablePasswordAuthentication(this.mySource);
    }

    private void initTarget() throws PBEException {
        if (this.mySource != null) {
            Cipher cipher = this.getEncrypter();
            try {
                this.myTarget = new SealedObject(this.getSerializableSource(), cipher);
            }
            catch (IOException iOException) {
                throw new TargetSerializationException(iOException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new PBEException.WrapIllegalBlockSizeException(illegalBlockSizeException, class$javax$crypto$SealedObject == null ? (class$javax$crypto$SealedObject = SealedPasswordAuthentication.class$("javax.crypto.SealedObject")) : class$javax$crypto$SealedObject);
            }
        } else {
            throw new NullSourceAndTargetException();
        }
    }

    public final SealedObject getTarget() throws PBEException {
        if (this.myTarget == null) {
            this.initTarget();
        }
        return this.myTarget;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class TargetDeserializationException
    extends PBEException {
        public TargetDeserializationException(IOException iOException) {
            super(iOException);
            super.getSupport().initMessage();
        }

        public TargetDeserializationException(ClassNotFoundException classNotFoundException) {
            super(classNotFoundException);
            super.getSupport().initMessage();
        }
    }

    public static class TargetSerializationException
    extends PBEException {
        public TargetSerializationException(IOException iOException) {
            super(iOException);
            super.getSupport().initMessage();
        }
    }

    public static class UnknownTargetTypeException
    extends PBEException {
        public UnknownTargetTypeException(Class clazz) {
            super((Throwable)null);
            super.getSupport().addMessageArg(clazz);
            super.getSupport().initMessage();
        }
    }

    public static class NullSourceAndTargetException
    extends PBEException {
        public NullSourceAndTargetException() {
            super((Throwable)null);
            super.getSupport().initMessage();
        }
    }
}

