/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.common.component;

import com.sun.netstorage.mgmt.esm.common.component.AbstractComponentDelegate;
import com.sun.netstorage.mgmt.esm.common.component.ComponentLogger;
import com.sun.netstorage.mgmt.esm.common.component.Contract;
import com.sun.netstorage.mgmt.esm.util.l10n.Message;
import com.sun.netstorage.mgmt.esm.util.l10n.Resource;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComponentLoggerDelegate
extends AbstractComponentDelegate
implements ComponentLogger {
    private static final String SCCS_ID = "@(#)ComponentLoggerDelegate.java 1.2   04/04/01 SMI";
    private Logger myLogger = null;

    public ComponentLoggerDelegate(Class clazz) {
        super(clazz);
    }

    private String getLoggerPackageName() {
        return this.getComponentPackageName();
    }

    public final Logger getLogger() {
        if (this.myLogger == null) {
            this.myLogger = Logger.getLogger(this.getLoggerPackageName());
        }
        return this.myLogger;
    }

    protected final void log(Level level, Resource resource) {
        if (resource != null) {
            this.log(level, new Message(resource));
        }
    }

    protected final void log(Level level, Message message) {
        Contract.requires(level != null, "theLevel != null");
        if (message != null) {
            this.getLogger().logp(level, this.getComponentBasename(), null, message.getLocalizedText());
        }
    }

    public final void logError(Resource resource) {
        this.log(Level.SEVERE, new Message(resource));
    }

    public final void logError(Message message) {
        this.log(Level.SEVERE, message);
    }

    public final void logWarning(Resource resource) {
        this.log(Level.WARNING, new Message(resource));
    }

    public final void logWarning(Message message) {
        this.log(Level.WARNING, message);
    }

    public final void logInfo(Resource resource) {
        this.log(Level.INFO, new Message(resource));
    }

    public final void logInfo(Message message) {
        this.log(Level.INFO, message);
    }

    public final void logConfig(Resource resource) {
        this.log(Level.CONFIG, new Message(resource));
    }

    public final void logConfig(Message message) {
        this.log(Level.CONFIG, message);
    }
}

