/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.common.array;

import com.sun.netstorage.mgmt.esm.common.array.DeviceStorageProfile;
import com.sun.netstorage.mgmt.esm.common.array.DeviceStorageSetting;
import com.sun.netstorage.mgmt.esm.common.array.GenericStorageSetting;
import com.sun.netstorage.mgmt.esm.common.array.StorageSetting;
import com.sun.netstorage.mgmt.esm.common.array.StorageSettingId;
import com.sun.netstorage.mgmt.esm.util.l10n.Resource;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.BasicName;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.BasicValue;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.Property;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.PropertyMap;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public final class StorageSettingFactory {
    private static final String SCCS_ID = "@(#)StorageSettingFactory.java 1.5   04/02/23 SMI";
    public static final String CONFIG_BASENAME = "StorageSettingFactory.properties";
    public static final String CONFIG_DIRNAME_PROPERTY = "StorageSettingFactory.dirname";
    public static final String CONFIG_DIRNAME_DEFAULT = "/tmp";
    public static final String CONFIG_DIRNAME = System.getProperty("StorageSettingFactory.dirname", "/tmp");
    public static final String CONFIG_FILENAME = CONFIG_DIRNAME + File.separator + "StorageSettingFactory.properties";
    public static final String CONFIG_GENERIC_LIST = "generic.list";
    public static final String CONFIG_SETTING_LIST = "setting.list";
    public static final String CONFIG_PROFILE_LIST = "profile.list";
    public static final String GENERIC_NSPOF = "NoSinglePointOfFailure";
    public static final String GENERIC_DATA_REDUNDANCY = "DataRedundancy";
    public static final String GENERIC_PACKAGE_REDUNDANCY = "PackageRedundancy";
    public static final String GENERIC_DELTA_RESERVATION = "DeltaReservation";
    public static final String[] GENERIC_SETTING_NAMES = new String[]{"NoSinglePointOfFailure", "DataRedundancy", "PackageRedundancy", "DeltaReservation"};
    public static final String[] SETTING_DATA_NAMES = new String[]{"Caption", "Description", "ElementName", "InstanceID"};
    public static final String[] STORAGE_SETTING_NAMES = new String[]{"NoSinglePointOfFailure", "DataRedundancyMin", "DataRedundancyMax", "DataRedundancyGoal", "PackageRedundancyMin", "PackageRedundancyMax", "PackageRedundancyGoal", "DeltaReservationMin", "DeltaReservationMax", "DeltaReservationGoal"};
    public static final String[] STORAGE_SETTING_WITH_HINTS_NAMES = new String[]{"AccessBandwidthWeight", "AccessDirectionHint", "AccessLatencyHint", "AccessRandomnessHint", "AccessSizeHint", "DataAvailabilityHint", "StorageCostHint", "StorageEfficiencyHint"};
    public static final String[] STORAGE_PROFILE_NAMES = new String[]{"ProductVersion", "SegmentSize", "ReadAhead", "RaidLevel", "ArrayType", "NumberOfDisks", "DedicatedHotSpare", "VirtualizationStrategy", "StripeSize", "NumberOfDisks", "SnapshotPoolPercent"};
    private static Properties ourConfig = null;
    private static StorageSetting[] ourWellKnownSettings = null;
    private static final HashMap ourInstances = new HashMap();
    private static boolean ourDebug;
    private static Locale ourLocale;

    private static Properties getConfig() {
        if (ourConfig == null) {
            ourConfig = StorageSettingFactory.loadConfig();
        }
        return ourConfig;
    }

    private static Properties loadConfig() {
        Properties properties = null;
        try {
            File file;
            File file2 = new File(CONFIG_DIRNAME);
            if (file2.exists() && (file = new File(file2, CONFIG_BASENAME)).exists() && file.canRead()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                properties = new Properties();
                properties.load(fileInputStream);
            }
        }
        catch (Exception exception) {
            properties = null;
        }
        return properties;
    }

    private static void listConfig() {
        if (StorageSettingFactory.getConfig() != null) {
            StorageSettingFactory.getConfig().list(System.err);
            System.err.println("-- end of config properties -- ");
            System.err.println();
        }
    }

    private static String getConfigProperty(String string) {
        String string2 = null;
        if (StorageSettingFactory.getConfig() != null) {
            string2 = StorageSettingFactory.getConfig().getProperty(string);
        }
        return string2;
    }

    private static String getConfigProperty(String string, String string2) {
        String string3 = string + "." + string2;
        return StorageSettingFactory.getConfigProperty(string3);
    }

    private static String[] getConfigPropertyAsCSV(String string) {
        String[] stringArray = null;
        if (StorageSettingFactory.getConfig() != null) {
            String string2 = StorageSettingFactory.getConfigProperty(string);
            stringArray = StorageSettingFactory.expandCSV(string2);
        }
        return stringArray;
    }

    static String getCanonicalVendor(String string) {
        String string2 = string.toLowerCase().replace(' ', '_');
        return StorageSettingFactory.getConfigProperty("vendor", string2);
    }

    static String getCanonicalModel(String string) {
        String string2 = string.toLowerCase().replace(' ', '_');
        return StorageSettingFactory.getConfigProperty("model", string2);
    }

    private static StorageSetting[] parseConfig() {
        StorageSetting[] storageSettingArray = null;
        StorageSetting[] storageSettingArray2 = StorageSettingFactory.parseGenericSettings();
        StorageSetting[] storageSettingArray3 = StorageSettingFactory.parseDeviceSettings();
        StorageSetting[] storageSettingArray4 = StorageSettingFactory.parseDeviceProfiles();
        ArrayList<StorageSetting> arrayList = new ArrayList<StorageSetting>();
        if (storageSettingArray2 != null && storageSettingArray2.length > 0) {
            arrayList.addAll(Arrays.asList(storageSettingArray2));
        }
        if (storageSettingArray3 != null && storageSettingArray3.length > 0) {
            arrayList.addAll(Arrays.asList(storageSettingArray3));
        }
        if (storageSettingArray4 != null && storageSettingArray4.length > 0) {
            arrayList.addAll(Arrays.asList(storageSettingArray4));
        }
        storageSettingArray = arrayList.toArray(new StorageSetting[arrayList.size()]);
        return storageSettingArray;
    }

    private static StorageSetting[] parseGenericSettings() {
        StorageSetting[] storageSettingArray = null;
        String[] stringArray = StorageSettingFactory.getConfigPropertyAsCSV(CONFIG_GENERIC_LIST);
        if (stringArray != null && stringArray.length > 0) {
            storageSettingArray = new StorageSetting[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                storageSettingArray[n] = StorageSettingFactory.parseGenericSetting(stringArray[n]);
                ++n;
            }
        }
        return storageSettingArray;
    }

    private static StorageSetting parseGenericSetting(String string) {
        StorageSetting storageSetting = null;
        String string2 = StorageSettingFactory.getConfigProperty(string, "name");
        String string3 = StorageSettingFactory.parseGenericProperty(string, GENERIC_NSPOF);
        String string4 = StorageSettingFactory.parseGenericProperty(string, GENERIC_DATA_REDUNDANCY);
        String string5 = StorageSettingFactory.parseGenericProperty(string, GENERIC_PACKAGE_REDUNDANCY);
        String string6 = StorageSettingFactory.parseGenericProperty(string, GENERIC_DELTA_RESERVATION);
        if (string3 == null || string4 == null || string5 == null) {
            return storageSetting;
        }
        if (string6 == null) {
            string6 = "1";
        }
        if (string2 == null) {
            string2 = string;
        }
        try {
            boolean bl = Boolean.valueOf(string3);
            int n = Integer.parseInt(string4);
            int n2 = Integer.parseInt(string5);
            int n3 = Integer.parseInt(string6);
            Resource resource = StorageSettingFactory.parseDescription(string, string2);
            storageSetting = StorageSettingFactory.createRAID(string, bl, n, n2, n3, resource);
        }
        catch (Exception exception) {
            StorageSettingFactory.error("invalid attribute type\n\texpect: boolean,int,int,int[,String]", exception);
        }
        return storageSetting;
    }

    private static String parseGenericProperty(String string, String string2) {
        String string3 = StorageSettingFactory.getConfigProperty(string, string2);
        if (string3 == null) {
            StorageSettingFactory.error("missing required 'generic' setting attribute\n\texpected: " + string + "." + string2);
        }
        return string3;
    }

    private static Resource parseDescription(String string, String string2) {
        Resource resource = null;
        String string3 = StorageSettingFactory.getConfigProperty(string, "Description");
        if (string3 != null) {
            if (string3.startsWith("%") && string3.endsWith("%")) {
                String string4 = string3.substring(1, string3.length() - 2);
                String string5 = StorageSettingFactory.getConfigProperty(string4);
                String[] stringArray = StorageSettingFactory.expandCSV(string5);
                if (stringArray != null) {
                    if (stringArray.length == 1) {
                        String string6 = stringArray[0];
                        resource = StorageSettingFactory.findResource(string6);
                    } else if (stringArray.length == 3) {
                        String string7 = stringArray[0];
                        String string8 = stringArray[1];
                        String string9 = stringArray[2];
                        resource = new Resource(string7, string8, string9);
                    }
                } else {
                    StorageSettingFactory.error("invalid description reference (" + string4 + ")" + "\n\texpect: <Resource> | <bundle>,<trinket>,<literal>" + "\n\tread: " + string5);
                }
            } else {
                resource = new Resource("bundle.this", string3, string3);
            }
        } else {
            resource = new Resource("bundle.this", string2, string2);
        }
        return resource;
    }

    private static StorageSetting[] parseDeviceSettings() {
        StorageSetting[] storageSettingArray = null;
        String[] stringArray = StorageSettingFactory.getConfigPropertyAsCSV(CONFIG_SETTING_LIST);
        if (stringArray != null && stringArray.length > 0) {
            storageSettingArray = new StorageSetting[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                storageSettingArray[n] = StorageSettingFactory.parseDeviceSetting(stringArray[n], false);
                ++n;
            }
        }
        return storageSettingArray;
    }

    private static StorageSetting[] parseDeviceProfiles() {
        StorageSetting[] storageSettingArray = null;
        String[] stringArray = StorageSettingFactory.getConfigPropertyAsCSV(CONFIG_PROFILE_LIST);
        if (stringArray != null && stringArray.length > 0) {
            storageSettingArray = new StorageSetting[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                storageSettingArray[n] = StorageSettingFactory.parseDeviceSetting(stringArray[n], true);
                ++n;
            }
        }
        return storageSettingArray;
    }

    private static StorageSetting parseDeviceSetting(String string, boolean bl) {
        DeviceStorageSetting deviceStorageSetting = null;
        String string2 = StorageSettingFactory.getConfigProperty(string, "name");
        String string3 = StorageSettingFactory.getConfigProperty(string, "vendor");
        String string4 = StorageSettingFactory.getConfigProperty(string, "model");
        String string5 = StorageSettingFactory.getConfigProperty(string, "properties");
        String[] stringArray = StorageSettingFactory.expandCSV(string5);
        PropertyMap propertyMap = new PropertyMap();
        Resource resource = StorageSettingFactory.parseDescription(string, string2);
        if (string2 == null) {
            string2 = string;
        }
        if (string3 == null) {
            StorageSettingFactory.error("missing required 'profile' attribute\n\texpected: " + string + ".vendor");
            return deviceStorageSetting;
        }
        if (string4 == null) {
            StorageSettingFactory.error("missing required 'profile' attribute\n\texpected: " + string + ".model");
            return deviceStorageSetting;
        }
        StorageSettingFactory.parseDeviceProperties(propertyMap, string, stringArray);
        StorageSettingFactory.parseDeviceProperties(propertyMap, string, SETTING_DATA_NAMES);
        StorageSettingFactory.parseDeviceProperties(propertyMap, string, STORAGE_SETTING_NAMES);
        if (bl) {
            StorageSettingFactory.parseDeviceProperties(propertyMap, string, STORAGE_SETTING_WITH_HINTS_NAMES);
            StorageSettingFactory.parseDeviceProperties(propertyMap, string, STORAGE_PROFILE_NAMES);
            deviceStorageSetting = new DeviceStorageProfile(string2, resource, string3, string4, propertyMap);
        } else {
            deviceStorageSetting = new DeviceStorageSetting(string2, resource, string3, string4, propertyMap);
        }
        return deviceStorageSetting;
    }

    private static void parseDeviceProperties(PropertyMap propertyMap, String string, String[] stringArray) {
        if (propertyMap != null && string != null && stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                String string3 = StorageSettingFactory.getConfigProperty(string, string2);
                if (string3 != null) {
                    BasicName basicName = new BasicName(string2);
                    BasicValue basicValue = new BasicValue(string3);
                    Property property = new Property(basicName, basicValue);
                    propertyMap.put(property);
                }
                ++n;
            }
        }
    }

    private static Resource findResource(String string) {
        Resource resource;
        block2: {
            resource = null;
            if (string == null) break block2;
            try {
                resource = Resource.getConstant(string);
            }
            catch (Exception exception) {
                StorageSettingFactory.error("description resource constant name format problem", exception);
            }
        }
        return resource;
    }

    public static StorageSetting[] getWellKnownSettings() {
        if (ourWellKnownSettings == null && (ourWellKnownSettings = StorageSettingFactory.parseConfig()) == null) {
            ourWellKnownSettings = new StorageSetting[]{GenericStorageSetting.RAID0, GenericStorageSetting.RAID1, GenericStorageSetting.RAID5};
        }
        return ourWellKnownSettings;
    }

    private static void listWellKnownSettings() {
        StorageSetting[] storageSettingArray = StorageSettingFactory.getWellKnownSettings();
        StorageSettingFactory.info("list of well known RAID settings:");
        if (storageSettingArray != null) {
            int n = 0;
            while (n < storageSettingArray.length) {
                if (storageSettingArray[n] != null) {
                    StorageSettingFactory.listStorageSetting(storageSettingArray[n]);
                }
                ++n;
            }
        }
    }

    private static void listStorageSetting(StorageSetting storageSetting) {
        Properties properties = storageSetting.getProperties(ourLocale);
        System.err.println(storageSetting);
        System.err.println();
        StorageSettingFactory.listProperty("Id", storageSetting.getId().toString());
        StorageSettingFactory.listProperty("Type", storageSetting.getType().getLocalizedText(ourLocale));
        StorageSettingFactory.listProperty("Name", storageSetting.getName());
        StorageSettingFactory.listProperty("Description", storageSetting.getDescription(ourLocale));
        if (properties != null && properties.size() > 0) {
            System.err.println("\tProperties:");
            properties.list(System.err);
            System.err.println("-- end setting details --");
        }
        System.err.println();
    }

    private static void listProperty(String string, String string2) {
        System.err.print("\t");
        System.err.print(string);
        System.err.print(": ");
        System.err.println(string2);
    }

    private static String toKey(StorageSettingId storageSettingId) {
        String string = storageSettingId != null ? storageSettingId.toString() : null;
        return StorageSettingFactory.toKey(string);
    }

    private static String toKey(String string) {
        return string != null ? string.toLowerCase() : null;
    }

    public static StorageSetting get(StorageSettingId storageSettingId) {
        StorageSetting storageSetting = null;
        if (storageSettingId != null) {
            storageSetting = StorageSettingFactory.get(storageSettingId.toString());
        }
        return storageSetting;
    }

    public static StorageSetting get(String string) {
        StorageSetting storageSetting = null;
        if (string != null) {
            String string2 = StorageSettingFactory.toKey(string);
            if (ourInstances.size() == 0) {
                StorageSettingFactory.cacheInit();
            }
            storageSetting = (StorageSetting)ourInstances.get(string2);
        }
        return storageSetting;
    }

    public static StorageSetting[] getAll() {
        StorageSetting[] storageSettingArray = ourInstances.entrySet().toArray(new StorageSetting[ourInstances.size()]);
        return storageSettingArray;
    }

    public static void cache(StorageSetting[] storageSettingArray) {
        if (storageSettingArray != null) {
            int n = 0;
            while (n < storageSettingArray.length) {
                StorageSettingFactory.cache(storageSettingArray[n]);
                ++n;
            }
        }
    }

    public static void cache(StorageSetting storageSetting) {
        if (storageSetting != null) {
            String string = StorageSettingFactory.toKey(storageSetting.getId());
            ourInstances.put(string, storageSetting);
            if (storageSetting instanceof GenericStorageSetting) {
                String string2 = StorageSettingFactory.toKey(storageSetting.getId().getDisplayName());
                ourInstances.put(string2, storageSetting);
            }
        }
    }

    private static void cacheInit() {
        StorageSettingFactory.cache(StorageSettingFactory.getWellKnownSettings());
    }

    public static void flush(StorageSetting[] storageSettingArray) {
        if (storageSettingArray != null) {
            int n = 0;
            while (n < storageSettingArray.length) {
                StorageSettingFactory.flush(storageSettingArray[n]);
                ++n;
            }
        }
    }

    public static void flush(StorageSetting storageSetting) {
        if (storageSetting != null) {
            String string = StorageSettingFactory.toKey(storageSetting.getId());
            ourInstances.remove(string);
            if (storageSetting instanceof GenericStorageSetting) {
                String string2 = StorageSettingFactory.toKey(storageSetting.getId().getDisplayName());
                ourInstances.remove(string2);
            }
        }
    }

    public static void flushAll() {
        ourInstances.clear();
        StorageSettingFactory.cacheInit();
    }

    private static void info(String string) {
        if (ourDebug) {
            System.err.print("StorageSettingFactory: INFO: ");
            System.err.println(string);
        }
    }

    private static void error(String string, Throwable throwable) {
        if (ourDebug) {
            System.err.print("StorageSettingFactory: ERROR: ");
            System.err.println(string);
            if (throwable != null) {
                System.err.print("\tbecause: ");
                System.err.println(throwable);
                throwable.printStackTrace(System.err);
            }
        }
    }

    private static void error(String string) {
        StorageSettingFactory.error(string, null);
    }

    public static StorageSetting createRAID(String string, boolean bl, int n, int n2, int n3, Resource resource) {
        GenericStorageSetting genericStorageSetting = GenericStorageSetting.getInstance(string);
        if (genericStorageSetting == null) {
            genericStorageSetting = GenericStorageSetting.createRAID(string, bl, n, n2, n3, resource);
        }
        return genericStorageSetting;
    }

    public static StorageSetting createRAID(String string, boolean bl, int n, int n2, int n3) {
        return StorageSettingFactory.createRAID(string, bl, n, n2, n3, GenericStorageSetting.toResource(string));
    }

    private static String[] expandCSV(String string) {
        String[] stringArray = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        ourDebug = true;
        if (stringArray != null && stringArray.length > 0) {
            ourLocale = new Locale(stringArray[0]);
        }
        StorageSettingFactory.listConfig();
        StorageSettingFactory.listWellKnownSettings();
        System.out.println("get( raid0 ) = " + StorageSettingFactory.get("raid0"));
        System.out.println("get( raid1 ) = " + StorageSettingFactory.get("raid1"));
        System.out.println("get( any/any/raid5 ) = " + StorageSettingFactory.get("any/any/raid5"));
        System.out.println("get( SUN/SE6920/Oracle ) = " + StorageSettingFactory.get("SUN/SE6920/Oracle"));
        StorageSettingFactory.flushAll();
        System.out.println("get( sun/se6920/Oracle ) = " + StorageSettingFactory.get("sun/se6920/Oracle"));
    }

    private StorageSettingFactory() {
    }

    static {
        StorageSettingFactory.cacheInit();
        ourDebug = false;
        ourLocale = Locale.getDefault();
    }
}

