/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.common.array;

import com.sun.netstorage.mgmt.esm.common.array.Contract;
import com.sun.netstorage.mgmt.esm.common.array.Localization;
import com.sun.netstorage.mgmt.esm.util.l10n.Localizable;
import com.sun.netstorage.mgmt.esm.util.l10n.Resource;
import java.io.Serializable;
import java.util.Locale;

public final class StorageCapacity
extends Number
implements Serializable {
    private static final String SCCS_ID = "@(#)StorageCapacity.java 1.3   04/02/10 SMI";
    static final long serialVersionUID = -5589850343031643264L;
    public static final String DISPLAYABLE_CAPACITY_TITLE = "Storage Capacity";
    private final UnitBase myUnitBase;
    private final UnitMagnitude myUnitMagnitude;
    private long myByteSize = 0L;

    public static String getLocalizedTitle() {
        return Localization.RES_DISPLAYABLE_CAPACITY_TITLE.getLocalizedText();
    }

    public static String getLocalizedTitle(Locale locale) {
        return Localization.RES_DISPLAYABLE_CAPACITY_TITLE.getLocalizedText(locale);
    }

    public StorageCapacity(long l, UnitMagnitude unitMagnitude, UnitBase unitBase) {
        Contract.requires(l >= 0L, "theByteSize >= 0");
        Contract.requires(unitMagnitude != null, "theUnitMagnitude != null");
        Contract.requires(unitBase != null, "theUnitBase != null");
        this.myByteSize = l;
        this.myUnitMagnitude = unitMagnitude;
        this.myUnitBase = unitBase;
    }

    public StorageCapacity(long l, UnitMagnitude unitMagnitude) {
        this(l, unitMagnitude, UnitBase.DEFAULT);
    }

    public StorageCapacity(long l, UnitBase unitBase) {
        this(l, UnitMagnitude.DEFAULT, unitBase);
    }

    public StorageCapacity(long l) {
        this(l, UnitMagnitude.DEFAULT, UnitBase.DEFAULT);
    }

    public StorageCapacity() {
        this(0L);
    }

    public boolean isUnitBase2() {
        return this.myUnitBase == UnitBase.TWO;
    }

    public boolean isUnitBase10() {
        return this.myUnitBase == UnitBase.TEN;
    }

    public StorageCapacity toUnitBase2() {
        StorageCapacity storageCapacity = new StorageCapacity(this.myByteSize, this.myUnitMagnitude, UnitBase.TWO);
        return storageCapacity;
    }

    public StorageCapacity toUnitBase10() {
        StorageCapacity storageCapacity = new StorageCapacity(this.myByteSize, this.myUnitMagnitude, UnitBase.TEN);
        return storageCapacity;
    }

    public StorageCapacity toUnitMagnitudeByte() {
        StorageCapacity storageCapacity = new StorageCapacity(this.myByteSize, UnitMagnitude.B, this.myUnitBase);
        return storageCapacity;
    }

    public StorageCapacity toUnitMagnitudeKB() {
        StorageCapacity storageCapacity = new StorageCapacity(this.myByteSize, UnitMagnitude.KB, this.myUnitBase);
        return storageCapacity;
    }

    public StorageCapacity toUnitMagnitudeMB() {
        StorageCapacity storageCapacity = new StorageCapacity(this.myByteSize, UnitMagnitude.MB, this.myUnitBase);
        return storageCapacity;
    }

    public StorageCapacity toUnitMagnitudeGB() {
        StorageCapacity storageCapacity = new StorageCapacity(this.myByteSize, UnitMagnitude.GB, this.myUnitBase);
        return storageCapacity;
    }

    public StorageCapacity toUnitMagnitudeTB() {
        StorageCapacity storageCapacity = new StorageCapacity(this.myByteSize, UnitMagnitude.TB, this.myUnitBase);
        return storageCapacity;
    }

    public long getByteSize() {
        return this.longByteSize();
    }

    public double doubleByteSize() {
        double d = this.myByteSize;
        Contract.ensures(d >= 0.0, "result >= 0");
        return d;
    }

    public long longByteSize() {
        long l = this.myByteSize;
        Contract.ensures(l >= 0L, "result >= 0");
        return l;
    }

    public void setByteSize(long l) {
        Contract.requires(l >= 0L, "theByteSize >= 0");
        this.myByteSize = l;
    }

    public double doubleKiloByteSize() {
        double d = UnitMagnitude.KB.doubleSize(this.myByteSize, this.myUnitBase);
        return d;
    }

    public long longKiloByteSize() {
        long l = UnitMagnitude.KB.longSize(this.myByteSize, this.myUnitBase);
        Contract.ensures(l >= 0L, "result >= 0");
        return l;
    }

    public void setKiloByteSize(long l) {
        Contract.requires(l >= 0L, "theSize >= 0");
        long l2 = UnitMagnitude.KB.toByteSize(l, this.myUnitBase);
        this.setByteSize(l2);
    }

    public double doubleMegaByteSize() {
        double d = UnitMagnitude.MB.doubleSize(this.myByteSize, this.myUnitBase);
        return d;
    }

    public long longMegaByteSize() {
        long l = UnitMagnitude.MB.longSize(this.myByteSize, this.myUnitBase);
        Contract.ensures(l >= 0L, "result >= 0");
        return l;
    }

    public void setMegaByteSize(long l) {
        Contract.requires(l >= 0L, "theSize >= 0");
        long l2 = UnitMagnitude.MB.toByteSize(l, this.myUnitBase);
        this.setByteSize(l2);
    }

    public double doubleGigaByteSize() {
        double d = UnitMagnitude.GB.doubleSize(this.myByteSize, this.myUnitBase);
        return d;
    }

    public long longGigaByteSize() {
        long l = UnitMagnitude.GB.longSize(this.myByteSize, this.myUnitBase);
        Contract.ensures(l >= 0L, "result >= 0");
        return l;
    }

    public void setGigaByteSize(long l) {
        Contract.requires(l >= 0L, "theSize >= 0");
        long l2 = UnitMagnitude.GB.toByteSize(l, this.myUnitBase);
        this.setByteSize(l2);
    }

    public double doubleTeraByteSize() {
        double d = UnitMagnitude.TB.doubleSize(this.myByteSize, this.myUnitBase);
        return d;
    }

    public long longTeraByteSize() {
        long l = UnitMagnitude.TB.longSize(this.myByteSize, this.myUnitBase);
        Contract.ensures(l >= 0L, "result >= 0");
        return l;
    }

    public void setTeraByteSize(long l) {
        Contract.requires(l >= 0L, "theSize >= 0");
        long l2 = UnitMagnitude.TB.toByteSize(l, this.myUnitBase);
        this.setByteSize(l2);
    }

    public int intValue() {
        return (int)this.longValue();
    }

    public long longValue() {
        long l = this.myUnitMagnitude.longSize(this.myByteSize, this.myUnitBase);
        return l;
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public double doubleValue() {
        double d = this.myUnitMagnitude.doubleSize(this.myByteSize, this.myUnitBase);
        return d;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof StorageCapacity) {
            StorageCapacity storageCapacity = (StorageCapacity)object;
            if (this.longByteSize() == storageCapacity.longByteSize()) {
                bl = true;
            }
        }
        return bl;
    }

    public int hashCode() {
        return (int)this.myByteSize;
    }

    public String toString() {
        return String.valueOf(this.longValue()) + ' ' + this.myUnitMagnitude;
    }

    public static class UnitMagnitude
    implements Serializable,
    Localizable {
        public static final String B_NAME = "B";
        public static final String KB_NAME = "KB";
        public static final String MB_NAME = "MB";
        public static final String GB_NAME = "GB";
        public static final String TB_NAME = "TB";
        public static final UnitMagnitude B = new UnitMagnitude(0, Localization.RES_B_NAME);
        public static final UnitMagnitude KB = new UnitMagnitude(1, Localization.RES_KB_NAME);
        public static final UnitMagnitude MB = new UnitMagnitude(2, Localization.RES_MB_NAME);
        public static final UnitMagnitude GB = new UnitMagnitude(3, Localization.RES_GB_NAME);
        public static final UnitMagnitude TB = new UnitMagnitude(4, Localization.RES_TB_NAME);
        public static final UnitMagnitude DEFAULT = GB;
        private final int myExponent;
        private final Resource myName;

        private UnitMagnitude(int n, Resource resource) {
            this.myExponent = n;
            this.myName = resource;
        }

        public String getAcronym() {
            return this.myName.getLiteralText();
        }

        public long longSize(long l, UnitBase unitBase) {
            long l2 = unitBase.getFactor(this.myExponent);
            long l3 = l / l2;
            Contract.ensures(l3 <= l, "result <= theByteSize");
            return l3;
        }

        public double doubleSize(long l, UnitBase unitBase) {
            long l2 = unitBase.getFactor(this.myExponent);
            double d = 1.0 * (double)l / (double)l2;
            Contract.ensures(d <= (double)l, "result <= theByteSize");
            return d;
        }

        public long toByteSize(long l, UnitBase unitBase) {
            long l2 = unitBase.getFactor(this.myExponent);
            long l3 = l * l2;
            Contract.ensures(l3 >= l, "result >= theOtherSize");
            return l3;
        }

        public final String getLocalizedText() {
            return this.getLocalizedText(Locale.getDefault());
        }

        public final String getLocalizedText(Locale locale) {
            String string = this.myName.getLocalizedText(locale);
            if (string == null) {
                string = this.myName.getLocalizedText();
            }
            if (string == null) {
                string = this.myName.getLiteralText();
            }
            return string;
        }

        public String toString() {
            return this.getLocalizedText();
        }
    }

    public static class UnitBase
    implements Serializable {
        public static final UnitBase TWO = new UnitBase(1024L);
        public static final UnitBase TEN = new UnitBase(1000L);
        public static final UnitBase DEFAULT = TWO;
        private final long myFactor;

        private UnitBase(long l) {
            this.myFactor = l;
        }

        public long getFactor(int n) {
            long l = 1L;
            int n2 = 0;
            while (n2 < n) {
                l *= this.myFactor;
                ++n2;
            }
            return l;
        }
    }
}

