/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.common.array;

import com.sun.netstorage.mgmt.esm.common.array.StorageSetting;
import com.sun.netstorage.mgmt.esm.common.array.StorageSettingId;
import com.sun.netstorage.mgmt.esm.common.array.StorageSettingType;
import com.sun.netstorage.mgmt.esm.util.l10n.Resource;
import java.util.Locale;

public abstract class AbstractStorageSetting
implements StorageSetting {
    private static final String SCCS_ID = "@(#)AbstractStorageSetting.java 1.2   04/02/10 SMI";
    private StorageSettingId myId = null;
    private StorageSettingType myType = null;
    private String myName = null;
    private Resource myDescription = null;

    public AbstractStorageSetting(StorageSettingId storageSettingId, StorageSettingType storageSettingType, String string, Resource resource) {
        this.myId = storageSettingId;
        this.myType = storageSettingType;
        this.myName = string;
        this.myDescription = resource;
    }

    public AbstractStorageSetting() {
        this(null, null, null, null);
    }

    protected final void setId(StorageSettingId storageSettingId) {
        if (this.myId == null) {
            this.myId = storageSettingId;
        }
    }

    protected final void setType(StorageSettingType storageSettingType) {
        if (this.myType == null) {
            this.myType = storageSettingType;
        }
    }

    protected final void setName(String string) {
        if (this.myName == null) {
            this.myName = string;
        }
    }

    protected final void setDescription(Resource resource) {
        if (this.myDescription == null) {
            this.myDescription = resource;
        }
    }

    protected final boolean matches(boolean bl, int n, int n2, int n3) {
        return false;
    }

    protected String getRaidDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        stringBuffer.append(this.isNoSinglePointOfFailure());
        stringBuffer.append(", ");
        stringBuffer.append(this.getDataRedundancy());
        stringBuffer.append(", ");
        stringBuffer.append(this.getPackageRedundancy());
        stringBuffer.append(", ");
        stringBuffer.append(this.getDeltaReservation());
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public final StorageSettingId getId() {
        return this.myId;
    }

    public final StorageSettingType getType() {
        return this.myType;
    }

    public final String getName() {
        return this.myName;
    }

    public final String getDescription(Locale locale) {
        String string = null;
        if (this.myDescription == null) {
            String string2 = this.getClass().getName();
            String string3 = "describe_this";
            this.myDescription = new Resource(string2, string3, this.getRaidDetails());
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string = this.myDescription.getLocalizedText(locale)) == null) {
            string = this.myDescription.getLiteralText();
        }
        return string;
    }

    public boolean isCompatible(StorageSetting storageSetting) {
        boolean bl = false;
        if (storageSetting != null && this.isNoSinglePointOfFailure() == storageSetting.isNoSinglePointOfFailure() && this.getDataRedundancy() == storageSetting.getDataRedundancy() && this.getPackageRedundancy() == storageSetting.getPackageRedundancy()) {
            bl = true;
        }
        return bl;
    }

    public int compareTo(Object object) {
        int n = -1;
        if (object instanceof StorageSetting) {
            StorageSetting storageSetting = (StorageSetting)object;
            n = this.getId().compareTo(storageSetting.getId());
        }
        return n;
    }

    public boolean equals(Object object) {
        StorageSetting storageSetting;
        boolean bl = false;
        if (object instanceof StorageSetting && this.isCompatible(storageSetting = (StorageSetting)object) && this.getId().equals(storageSetting.getId()) && this.getType().equals(storageSetting.getType()) && this.getName().equals(storageSetting.getName())) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getId());
        return stringBuffer.toString();
    }
}

