/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.component.model.api.cim;

import java.util.Calendar;

public class CIMDataTypeUtil {
    public static String getCalendarString(Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CIMDataTypeUtil.padLeadingZeros(calendar.get(1), 4));
        stringBuffer.append(CIMDataTypeUtil.padLeadingZeros(calendar.get(2) + 1, 2));
        stringBuffer.append(CIMDataTypeUtil.padLeadingZeros(calendar.get(5), 2));
        stringBuffer.append(CIMDataTypeUtil.padLeadingZeros(calendar.get(11), 2));
        stringBuffer.append(CIMDataTypeUtil.padLeadingZeros(calendar.get(12), 2));
        stringBuffer.append(CIMDataTypeUtil.padLeadingZeros(calendar.get(13), 2));
        stringBuffer.append(".");
        stringBuffer.append(CIMDataTypeUtil.padTrailingZeros(calendar.get(14), 6));
        int n = calendar.get(15);
        if (n < 0) {
            stringBuffer.append("-");
        } else {
            stringBuffer.append("+");
        }
        stringBuffer.append(CIMDataTypeUtil.padLeadingZeros(Math.abs(n / 60000), 3));
        return stringBuffer.toString();
    }

    public static String getArrayString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append("\"" + stringArray[n] + "\"");
            if (n < stringArray.length - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String padLeadingZeros(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = string.length();
        while (n2 < n) {
            stringBuffer.insert(0, 0);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static String padTrailingZeros(int n, int n2) {
        return CIMDataTypeUtil.padTrailingZeros(String.valueOf(n), n2);
    }

    private static String padLeadingZeros(int n, int n2) {
        return CIMDataTypeUtil.padLeadingZeros(String.valueOf(n), n2);
    }

    private static String padTrailingZeros(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = string.length();
        while (n2 < n) {
            stringBuffer.append(0);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

