/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.util.log;

import com.sun.jade.util.PropertiesPersistenceException;
import com.sun.jade.util.PropertiesPersister;
import com.sun.jade.util.log.LogFormatter;
import com.sun.jade.util.log.Logger;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class LoggerImpl
implements Logger {
    private boolean allTags;
    private boolean noDefaultTag;
    private boolean loggingEnabled;
    private LogFormatter formatter;
    private HashSet tagSet = new HashSet();
    private String name;
    private String header;
    private Level level;
    private static java.util.logging.Logger logger;
    private static Properties logProps;
    public static final String sccs_id = "@(#)LoggerImpl.java\t1.12 11/06/03 SMI";

    public LoggerImpl(boolean bl, String string) {
        String string2;
        this.loggingEnabled = bl;
        this.name = string;
        this.setProps();
        this.setLogger();
        this.mapLevel();
        String string3 = logProps.getProperty("jade.log." + string);
        if (string3 != null) {
            this.loggingEnabled = string3.equals("enable");
        }
        if ((string3 = System.getProperty("jade.log." + string)) != null) {
            this.loggingEnabled = string3.equals("enable");
        }
        if ((string2 = System.getProperty("jade.log.tag")) == null) {
            string2 = logProps.getProperty("jade.log.tag");
        }
        if (string2 != null && !string2.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                this.addTag(string4);
            }
        }
    }

    public boolean isEnabled() {
        return this.loggingEnabled && !this.noDefaultTag;
    }

    public boolean isEnabled(String string) {
        return this.loggingEnabled && (this.allTags || this.tagSet.contains(string));
    }

    public void log(Object object) {
        if (this.loggingEnabled && !this.noDefaultTag) {
            logger.log(this.level, this.header + object.toString());
        }
    }

    public void log(String string, Object object) {
        if (this.loggingEnabled && (this.allTags || this.tagSet.contains(string))) {
            logger.log(this.level, this.header + object.toString());
        }
    }

    public void log(Throwable throwable, Object object) {
        if (this.loggingEnabled && !this.noDefaultTag) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.print(this.header);
            printWriter.println(object.toString());
            throwable.printStackTrace(printWriter);
            logger.log(this.level, stringWriter.toString());
        }
    }

    public void log(String string, Throwable throwable, Object object) {
        if (this.allTags || this.tagSet.contains(string)) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.print(this.header);
            printWriter.println(object.toString());
            throwable.printStackTrace(printWriter);
            logger.log(this.level, stringWriter.toString());
        }
    }

    public void disableLogging() {
        this.loggingEnabled = false;
    }

    public void enableLogging() {
        this.loggingEnabled = true;
    }

    public void addTag(String string) {
        if ("ALL".equals(string)) {
            this.allTags = true;
        } else if ("NODEFAULT".equals(string)) {
            this.noDefaultTag = true;
        } else {
            this.tagSet.add(string);
        }
    }

    public void clearTag(String string) {
        if ("ALL".equals(string)) {
            this.allTags = false;
        } else if ("NODEFAULT".equals(string)) {
            this.noDefaultTag = false;
        } else {
            this.tagSet.remove(string);
        }
    }

    public void setFormatter(LogFormatter logFormatter) {
        if (logFormatter == null) {
            return;
        }
        this.formatter = logFormatter;
    }

    private void setProps() {
        block2: {
            if (logProps != null) break block2;
            try {
                logProps = PropertiesPersister.restoreProperties("Logger.properties");
            }
            catch (PropertiesPersistenceException propertiesPersistenceException) {
                logProps = new Properties();
            }
        }
    }

    private void setLogger() {
        String string;
        if (logger != null) {
            return;
        }
        int n = 50000;
        int n2 = 4;
        logger = java.util.logging.Logger.getAnonymousLogger();
        logger.setLevel(Level.ALL);
        String string2 = logProps.getProperty("jade.log.file.limit");
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string2 = logProps.getProperty("jade.log.file.count")) != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = System.getProperty("jade.log.output")) == null) {
            string = logProps.getProperty("jade.log.output");
        }
        StreamHandler streamHandler = null;
        if (string != null && !string.equals("")) {
            try {
                streamHandler = new FileHandler(string, n, n2);
            }
            catch (IOException iOException) {
                System.err.println("Failed to assign logger to file");
                iOException.printStackTrace();
            }
        } else {
            streamHandler = new ConsoleHandler();
        }
        if (streamHandler != null) {
            streamHandler.setFormatter(new DefaultFormatter());
            logger.addHandler(streamHandler);
            logger.setUseParentHandlers(false);
        }
    }

    private void mapLevel() {
        if ("error".equals(this.name)) {
            this.level = Level.SEVERE;
            this.header = "ERROR:";
        } else if ("warning".equals(this.name)) {
            this.level = Level.WARNING;
            this.header = "WARNING:";
        } else if ("info".equals(this.name)) {
            this.level = Level.INFO;
            this.header = "INFO:";
        } else if ("audit".equals(this.name)) {
            this.level = Level.INFO;
            this.header = "AUDIT:";
        } else if ("debug".equals(this.name)) {
            this.level = Level.INFO;
            this.header = "DEBUG:";
        } else if ("trace".equals(this.name)) {
            this.level = Level.INFO;
            this.header = "TRACE:";
        }
    }

    private class DefaultFormatter
    extends Formatter {
        private DefaultFormatter() {
        }

        public String format(LogRecord logRecord) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getTime());
            stringBuffer.append(" ");
            stringBuffer.append(this.getLocation(new Exception()));
            stringBuffer.append("\n");
            stringBuffer.append(logRecord.getMessage());
            stringBuffer.append("\n\n");
            return stringBuffer.toString();
        }

        private String getLocation(Exception exception) {
            String string = "?";
            try {
                StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                int n = 0;
                int n2 = 1;
                int n3 = 0;
                while (n3 < stackTraceElementArray.length) {
                    if ("LoggerImpl.java".equals(stackTraceElementArray[n3].getFileName())) {
                        n = n3;
                    }
                    ++n3;
                }
                if (n + n2 < stackTraceElementArray.length) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[n + n2];
                    string = stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber();
                }
            }
            catch (Exception exception2) {}
            return string;
        }

        private String getTime() {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            StringBuffer stringBuffer = new StringBuffer();
            int n = gregorianCalendar.get(2) + 1;
            if (n <= 9) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n);
            stringBuffer.append("/");
            n = gregorianCalendar.get(5);
            if (n <= 9) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n);
            stringBuffer.append(" ");
            n = gregorianCalendar.get(11);
            if (n <= 9) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n);
            stringBuffer.append(":");
            n = gregorianCalendar.get(12);
            if (n <= 9) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n);
            stringBuffer.append(".");
            n = gregorianCalendar.get(13);
            if (n <= 9) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n);
            return stringBuffer.toString();
        }
    }
}

