/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.util.locale;

import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.unittest.UnitTest;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localizer
implements Serializable {
    private transient ResourceBundle rb;
    private String resourceName;
    private boolean deferLocalization;
    private Locale defaultLocale;
    private static final String sccs_id = "@(#)Localizer.java\t1.9 02/20/03 SMI";

    public Localizer(String string) {
        this.resourceName = string;
        this.setLocale(Locale.getDefault());
    }

    public Localizer(String string, boolean bl) {
        this(string);
        this.deferLocalization = bl;
    }

    public Localizer(Locale locale, String string, boolean bl) {
        this.resourceName = string;
        this.setLocale(locale);
        this.deferLocalization = bl;
    }

    public void setDeferLocalization(boolean bl) {
        this.deferLocalization = bl;
    }

    public void setLocale(Locale locale) {
        this.defaultLocale = locale;
        if (this.resourceName != null) {
            try {
                this.rb = ResourceBundle.getBundle(this.resourceName, this.defaultLocale);
            }
            catch (MissingResourceException missingResourceException) {
                this.rb = null;
            }
        } else {
            this.rb = null;
        }
    }

    public Locale getLocale() {
        return this.defaultLocale;
    }

    public ResourceBundle getRB() {
        return this.rb;
    }

    public String getString(String string) {
        if (this.deferLocalization) {
            LocalizedString localizedString = new LocalizedString(this.resourceName, string, this.rb.getString(string));
            return localizedString.toString();
        }
        if (this.rb == null) {
            return string;
        }
        try {
            return this.rb.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public String getString(Locale locale, String string) {
        LocalizedString localizedString = new LocalizedString(this.resourceName, string, string);
        return localizedString.getLocalizedMessage(locale);
    }

    public String getString(String string, String string2) {
        if (this.deferLocalization) {
            LocalizedString localizedString = new LocalizedString(this.resourceName, string, this.rb.getString(string));
            return localizedString.toString();
        }
        if (this.rb == null) {
            return string2;
        }
        try {
            return this.rb.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    public String getString(Locale locale, String string, String string2) {
        LocalizedString localizedString = new LocalizedString(this.resourceName, string, string2);
        return localizedString.getLocalizedMessage(locale);
    }

    public String getFormattedString(String string, Object[] objectArray) {
        if (this.deferLocalization) {
            String string2;
            try {
                string2 = this.rb.getString(string);
            }
            catch (Exception exception) {
                string2 = string;
            }
            LocalizedString localizedString = new LocalizedString(this.resourceName, string, string2, objectArray);
            return localizedString.toString();
        }
        return MessageFormat.format(this.getString(string), objectArray);
    }

    public String getFomattedString(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return this.getFormattedString(string, objectArray);
    }

    public String getFomattedString(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return this.getFormattedString(string, objectArray);
    }

    public String getFomattedString(String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return this.getFormattedString(string, objectArray);
    }

    public String getFomattedString(String string, Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        return this.getFormattedString(string, objectArray);
    }

    public String getFormattedString(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return this.getFormattedString(string, objectArray);
    }

    public String getFormattedString(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return this.getFormattedString(string, objectArray);
    }

    public String getFormattedString(String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return this.getFormattedString(string, objectArray);
    }

    public String getFormattedString(String string, Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        return this.getFormattedString(string, objectArray);
    }

    public LocalizedString getLocalizedString(String string) {
        return new LocalizedString(this.resourceName, string, this.rb.getString(string));
    }

    public LocalizedString getLocalizedString(String string, String string2) {
        return new LocalizedString(this.resourceName, string2, this.rb.getString(string));
    }

    public LocalizedString getLocalizedString(String string, Object[] objectArray) {
        String string2 = MessageFormat.format(this.getString(string), objectArray);
        return new LocalizedString(this.resourceName, string, string2, objectArray);
    }

    public static class Test
    extends UnitTest {
        Localizer loc;

        public void testAll() {
            this.loc = new Localizer("com.sun.jade.util.locale.missingResource");
            this.loc = new Localizer("");
            this.loc = new Localizer(null);
            this.loc = new Localizer("com.sun.jade.util.locale.TestResource");
            this.loc.deferLocalization = false;
            this.assertEquals(this.loc.getString("propertyX"), "propertyX");
            this.assertEquals(this.loc.getString("propertyX", "defaultX"), "defaultX");
            this.assertEquals(this.loc.getString("propertyA", "!A"), "A");
            this.assertEquals(this.loc.getString("propertyA"), "A");
            this.assertEquals(this.loc.getFormattedString("value", new Integer(9)), "The value is 9.");
        }
    }
}

