/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.message;

import com.sun.jade.cim.util.CIMBeanUtil;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class MessageCode {
    private int msg_id;
    static final String defineDir = "messageCode";
    static final String MSG_BASE = "com.sun.jade.message";
    static final String MSG_TYPE = "MessageType";
    static final String SUBJ_TYPE = "SubjectType";
    static final String SUB_TYPE = "SubjectSubType";
    static final String CAT_TYPE = "MessageCategory";
    static final String MESSAGES = "Messages";
    public static final String DESCRIPTION = "description";
    public static final String PROBABLE_CAUSE = "probableCause";
    public static final String PROBABLE_CAUSE_DESCRIPTION = "probableCauseDescription";
    private static final String MESSAGE_PROP = "description";
    private static final String ARGS_PROP = "args";
    private static final String FILTER_PROP = "filter.property";
    public static final String sccs_id = "@(#)MessageCode.java\t1.21 05/07/03 SMI";

    public MessageCode(String string) {
        this.msg_id = Integer.parseInt(string, 16);
    }

    public MessageCode(long l) {
        this.msg_id = (int)l;
    }

    public MessageCode(String string, int n) {
        this.msg_id = this.getId(string) + n;
    }

    public String getMessageCode() {
        return Integer.toHexString(this.msg_id);
    }

    public Properties getMessageProperties() {
        ResourceBundle resourceBundle = MessageCode.getResourceBundle(this.getResource(this.msg_id));
        return this.getProperties(resourceBundle);
    }

    public Properties getMessageProperties(Locale locale) {
        ResourceBundle resourceBundle = MessageCode.getResourceBundle(this.getResource(this.msg_id), locale);
        return this.getProperties(resourceBundle);
    }

    public String getProperty(Locale locale, String string) {
        int n = this.msg_id & 0xFF;
        String string2 = "" + n + "." + string;
        ResourceBundle resourceBundle = MessageCode.getResourceBundle(this.getResource(this.msg_id), locale);
        try {
            return resourceBundle.getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public String getProperty(String string) {
        return this.getProperty(Locale.getDefault(), string);
    }

    public static void RegisterSubjectSubType(String string, int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.toString(Locale.getDefault(), null);
    }

    public String toString(Object[] objectArray) {
        return this.toString(Locale.getDefault(), objectArray);
    }

    public String toString(Locale locale) {
        return this.toString(locale, null);
    }

    public String toString(Locale locale, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        Properties properties = this.getMessageProperties(locale);
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(properties);
        Set<Map.Entry<Object, Object>> set = treeMap.entrySet();
        stringBuffer.append(this.getMessageCode());
        stringBuffer.append(":");
        ResourceBundle resourceBundle = MessageCode.getResourceBundle("com.sun.jade.message.MessageCode");
        if (resourceBundle != null) {
            Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                if ("description".equals(string) && objectArray != null) {
                    string2 = MessageFormat.format(string2, objectArray);
                }
                String string3 = string;
                try {
                    string3 = resourceBundle.getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                stringBuffer.append("\n\t");
                stringBuffer.append(string3);
                stringBuffer.append(" = ");
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    public String getMessage() {
        return this.getMessage(Locale.getDefault(), null);
    }

    public String getMessage(Object[] objectArray) {
        return this.getMessage(Locale.getDefault(), objectArray);
    }

    public String getMessage(Locale locale) {
        return this.getMessage(locale, null);
    }

    public String getMessage(Locale locale, Object[] objectArray) {
        Properties properties = this.getMessageProperties(locale);
        String string = properties.getProperty("description");
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if ((objectArray = this.localizeArgs(objectArray, locale, false)) != null) {
            string = MessageFormat.format(string, objectArray);
        }
        stringBuffer.append(string);
        stringBuffer.append(" (");
        stringBuffer.append(this.getMessageCode());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public LocalizedString getLocalizedStringMessage(Object[] objectArray) {
        int n = this.msg_id & 0xFF;
        String string = "" + n + ".";
        return new LocalizedString(this.getResource(this.msg_id), string + "description", this.getMessage(objectArray), this.localizeArgs(objectArray, Locale.getDefault(), true));
    }

    public LocalizedString getLocalizedStringMessage() {
        int n = this.msg_id & 0xFF;
        String string = "" + n + ".";
        return new LocalizedString(this.getResource(this.msg_id), string + "description", this.getMessage());
    }

    public LocalizedString getLocalizedStringProperty(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return null;
        }
        int n = this.msg_id & 0xFF;
        String string3 = "" + n + ".";
        return new LocalizedString(this.getResource(this.msg_id), string3 + string, string2);
    }

    private int getId(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            String string6 = MSG_BASE;
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string6 + "." + MSG_TYPE);
            String string7 = resourceBundle.getString(string2 + ".package");
            String string8 = resourceBundle.getString(string2 + ".id");
            string6 = string7 == null ? "com.sun.jade.message." + string2 : string7;
            n = Integer.parseInt(string8);
            resourceBundle = ResourceBundle.getBundle(string6 + "." + SUBJ_TYPE);
            string7 = this.getValue(resourceBundle, string3 + ".package");
            string8 = this.getValue(resourceBundle, string3 + ".id");
            string6 = string7 == null ? string6 + "." + string3 : string7;
            n2 = Integer.parseInt(string8);
            resourceBundle = ResourceBundle.getBundle(string6 + "." + SUB_TYPE);
            string7 = this.getValue(resourceBundle, string4 + ".package");
            string8 = this.getValue(resourceBundle, string4 + ".id");
            string6 = string7 == null ? string6 + "." + string4 : string7;
            n3 = Integer.parseInt(string8);
            resourceBundle = ResourceBundle.getBundle(string6 + "." + CAT_TYPE);
            string8 = this.getValue(resourceBundle, string5 + ".id");
            n4 = Integer.parseInt(string8);
            return (n << 28) + (n2 << 24) + (n3 << 16) + (n4 << 8);
        }
        catch (MissingResourceException missingResourceException) {
            Report.error.log(missingResourceException, (Object)"Can't load message code resource");
            return 0;
        }
    }

    private String getResource(int n) {
        int n2 = n >>> 28;
        int n3 = n >> 24 & 0xF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        try {
            String string = MSG_BASE;
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string + "." + MSG_TYPE);
            String string2 = this.getSymbol(resourceBundle, n2);
            if (string2 == null) {
                return null;
            }
            String string3 = resourceBundle.getString(string2 + ".package");
            string = string3 == null ? "com.sun.jade.message." + string2 : string3;
            String string4 = this.getSymbol(resourceBundle = ResourceBundle.getBundle(string + "." + SUBJ_TYPE), n3);
            if (string4 == null) {
                return null;
            }
            string3 = this.getValue(resourceBundle, string4 + ".package");
            string = string3 == null ? string + "." + string4 : string3;
            String string5 = this.getSymbol(resourceBundle = ResourceBundle.getBundle(string + "." + SUB_TYPE), n4);
            if (string5 == null) {
                return null;
            }
            string3 = this.getValue(resourceBundle, string5 + ".package");
            string = string3 == null ? string + "." + string5 : string3;
            String string6 = this.getSymbol(resourceBundle = ResourceBundle.getBundle(string + "." + CAT_TYPE), n5);
            if (string6 == null) {
                return null;
            }
            string3 = this.getValue(resourceBundle, string6 + ".package");
            if (string3 == null) {
                return string + "." + string6;
            }
            return string3;
        }
        catch (MissingResourceException missingResourceException) {
            Report.error.log(missingResourceException, (Object)"Can't load message code resource");
            return null;
        }
    }

    private Properties getProperties(ResourceBundle resourceBundle) {
        Properties properties = new Properties();
        if (resourceBundle == null) {
            return properties;
        }
        int n = this.msg_id & 0xFF;
        String string = "" + n + ".";
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            properties.setProperty(string2.substring(string.length()), resourceBundle.getString(string2));
        }
        return properties;
    }

    static ResourceBundle getResourceBundle(String string) {
        if (string == null) {
            return null;
        }
        try {
            return ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static ResourceBundle getResourceBundle(String string, Locale locale) {
        if (string == null) {
            return null;
        }
        try {
            return ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private String getValue(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private String getSymbol(ResourceBundle resourceBundle, int n) {
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string;
            int n2;
            String string2 = enumeration.nextElement();
            if (!string2.endsWith(".id") || n != (n2 = Integer.parseInt(string = resourceBundle.getString(string2)))) continue;
            return string2.substring(0, string2.length() - 3);
        }
        return null;
    }

    private Object[] localizeArgs(Object[] objectArray, Locale locale, boolean bl) {
        if (objectArray == null || objectArray.length == 0) {
            return objectArray;
        }
        Properties properties = this.getMessageProperties(locale);
        String string = properties.getProperty("description");
        String string2 = properties.getProperty(FILTER_PROP);
        if (string == null) {
            Report.error.log("Property description not defined for message " + this.getResource(this.msg_id) + ":" + this.getMessageCode());
            return objectArray;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        if (string2 != null) {
            int n = string2.indexOf(46);
            if (n <= 0) {
                return objectArray2;
            }
            String string3 = string2.substring(0, n);
            String string4 = properties.getProperty(ARGS_PROP);
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                LocalizedString localizedString = CIMBeanUtil.getLocalizedString(string3, string5, objectArray[n2]);
                objectArray2[n2] = bl ? localizedString.toString() : localizedString.getString();
                ++n2;
            }
        } else {
            int n = 0;
            while (n < objectArray.length) {
                String string6 = null;
                String string7 = properties.getProperty("description.args." + n);
                if (string7 != null) {
                    int n3 = string7.indexOf(44);
                    if (n3 >= 1) {
                        String string8 = string7.substring(0, n3);
                        String string9 = string7.substring(n3 + 1);
                        string9 = string9 + "." + objectArray[n];
                        try {
                            ResourceBundle resourceBundle = ResourceBundle.getBundle(string8, locale);
                            string6 = resourceBundle.getString(string9);
                        }
                        catch (MissingResourceException missingResourceException) {
                            Report.error.log("Resource missing for " + string8);
                        }
                    } else {
                        Report.error.log("Attribute name not specified in argument mapping (" + string7 + ") line for argument " + "description" + "." + ARGS_PROP + "." + "  Message code: " + this.getMessageCode());
                    }
                }
                if (string6 != null) {
                    objectArray2[n] = string6;
                }
                ++n;
            }
        }
        return objectArray2;
    }

    private static ResourceBundle getResourceBundleForID(int n) {
        return null;
    }

    public static class Test
    extends UnitTest {
        public void test_getResource() {
            Object[] objectArray = new String[]{"blah.file", "blah.domain"};
            MessageCode messageCode = new MessageCode("33020001");
            this.assertEquals("com.sun.jade.message.app.sade3.installer.error", messageCode.getResource(messageCode.msg_id));
            messageCode = new MessageCode("app.sade3.installer.error", 1);
            this.assertEquals("Can't find configuration file blah.file for domain blah.domain (33020001)", messageCode.getMessage(objectArray));
        }

        public void test(boolean bl) {
            MessageCode messageCode = new MessageCode("app.sade3.general.test", 1);
            Object[] objectArray = new Object[]{new Integer(8), new Integer(99)};
            LocalizedString localizedString = messageCode.getLocalizedStringMessage(objectArray);
            System.out.println(localizedString.getLocalizedMessage());
            System.out.println(localizedString.toString());
        }

        public void testProbableCause() {
            MessageCode messageCode = new MessageCode("app.sade3.general.error", 6);
            messageCode = new MessageCode("app.sade3.general.test", 1);
            LocalizedString localizedString = messageCode.getLocalizedStringProperty(MessageCode.PROBABLE_CAUSE);
            LocalizedString localizedString2 = messageCode.getLocalizedStringProperty("recommendedAction");
            this.assertEquals(localizedString.getString(), "Availability changed.");
            this.assertEquals(localizedString2.getString(), "Test Action.");
        }

        public static void main(String[] stringArray) {
            MessageCode messageCode = null;
            if (stringArray.length == 2) {
                messageCode = new MessageCode(stringArray[0], Integer.parseInt(stringArray[1]));
            } else if (stringArray.length == 1) {
                messageCode = new MessageCode(stringArray[0]);
            }
            LocalizedString localizedString = messageCode.getLocalizedStringMessage(stringArray);
            System.out.println("Message=" + localizedString.getLocalizedMessage());
            System.out.println("MessageCode=" + messageCode.getMessageCode());
            Properties properties = messageCode.getMessageProperties();
            System.out.println("Properties=");
            properties.list(System.out);
            System.out.println("Resource=" + messageCode.getResource(messageCode.msg_id));
        }
    }
}

