/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.jade.device.protocol.snmp.SNMP;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.ProbeResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.PACKAGE;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.ProbeRootImpl;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class SNMPProbe
extends ProbeRootImpl {
    public static final String PROBE_NAME = "SNMP";
    public static final String SYS_DESCR = "snmp.sysDescr";
    public static final String sccs_id = "@(#)SNMPProbe.java\t1.7 10/31/03 SMI";

    public SNMPProbe() {
        super(PROBE_NAME);
    }

    public ProbeResult probe(Properties properties) {
        String string = properties.getProperty("ip");
        int n = 1;
        String string2 = properties.getProperty("timeout");
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                PACKAGE.ERROR("Bad timeout value", exception);
            }
        }
        SNMP sNMP = new SNMP(n * 1000);
        Properties properties2 = sNMP.getBaseProperties(string);
        return super.probe(SNMPProbe.mergeSNMPProperties(properties, properties2));
    }

    private static Properties mergeSNMPProperties(Properties properties, Properties properties2) {
        if (properties2 == null) {
            return properties;
        }
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(properties2);
        Set<Map.Entry<Object, Object>> set = treeMap.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            properties.setProperty("snmp." + (String)entry.getKey(), (String)entry.getValue());
        }
        return properties;
    }
}

